/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportTransitGatewayRoutesResponse extends Ec2Response implements
        ToCopyableBuilder<ExportTransitGatewayRoutesResponse.Builder, ExportTransitGatewayRoutesResponse> {
    private static final SdkField<String> S3_LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportTransitGatewayRoutesResponse::s3Location))
            .setter(setter(Builder::s3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Location")
                    .unmarshallLocationName("s3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_LOCATION_FIELD));

    private final String s3Location;

    private ExportTransitGatewayRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.s3Location = builder.s3Location;
    }

    /**
     * <p>
     * The URL of the exported file in Amazon S3. For example,
     * s3://<i>bucket_name</i>/VPCTransitGateway/TransitGatewayRouteTables/<i>file_name</i>.
     * </p>
     * 
     * @return The URL of the exported file in Amazon S3. For example,
     *         s3://<i>bucket_name</i>/VPCTransitGateway/TransitGatewayRouteTables/<i>file_name</i>.
     */
    public String s3Location() {
        return s3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTransitGatewayRoutesResponse)) {
            return false;
        }
        ExportTransitGatewayRoutesResponse other = (ExportTransitGatewayRoutesResponse) obj;
        return Objects.equals(s3Location(), other.s3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportTransitGatewayRoutesResponse").add("S3Location", s3Location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTransitGatewayRoutesResponse, T> g) {
        return obj -> g.apply((ExportTransitGatewayRoutesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ExportTransitGatewayRoutesResponse> {
        /**
         * <p>
         * The URL of the exported file in Amazon S3. For example,
         * s3://<i>bucket_name</i>/VPCTransitGateway/TransitGatewayRouteTables/<i>file_name</i>.
         * </p>
         * 
         * @param s3Location
         *        The URL of the exported file in Amazon S3. For example,
         *        s3://<i>bucket_name</i>/VPCTransitGateway/TransitGatewayRouteTables/<i>file_name</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(String s3Location);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTransitGatewayRoutesResponse model) {
            super(model);
            s3Location(model.s3Location);
        }

        public final String getS3Location() {
            return s3Location;
        }

        @Override
        public final Builder s3Location(String s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(String s3Location) {
            this.s3Location = s3Location;
        }

        @Override
        public ExportTransitGatewayRoutesResponse build() {
            return new ExportTransitGatewayRoutesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
