/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request information of license configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportImageLicenseConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportImageLicenseConfigurationRequest.Builder, ImportImageLicenseConfigurationRequest> {
    private static final SdkField<String> LICENSE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImportImageLicenseConfigurationRequest::licenseConfigurationArn))
            .setter(setter(Builder::licenseConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConfigurationArn")
                    .unmarshallLocationName("LicenseConfigurationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LICENSE_CONFIGURATION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String licenseConfigurationArn;

    private ImportImageLicenseConfigurationRequest(BuilderImpl builder) {
        this.licenseConfigurationArn = builder.licenseConfigurationArn;
    }

    /**
     * <p>
     * The ARN of a license configuration.
     * </p>
     * 
     * @return The ARN of a license configuration.
     */
    public String licenseConfigurationArn() {
        return licenseConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(licenseConfigurationArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageLicenseConfigurationRequest)) {
            return false;
        }
        ImportImageLicenseConfigurationRequest other = (ImportImageLicenseConfigurationRequest) obj;
        return Objects.equals(licenseConfigurationArn(), other.licenseConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportImageLicenseConfigurationRequest")
                .add("LicenseConfigurationArn", licenseConfigurationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseConfigurationArn":
            return Optional.ofNullable(clazz.cast(licenseConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportImageLicenseConfigurationRequest, T> g) {
        return obj -> g.apply((ImportImageLicenseConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportImageLicenseConfigurationRequest> {
        /**
         * <p>
         * The ARN of a license configuration.
         * </p>
         * 
         * @param licenseConfigurationArn
         *        The ARN of a license configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArn(String licenseConfigurationArn);
    }

    static final class BuilderImpl implements Builder {
        private String licenseConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageLicenseConfigurationRequest model) {
            licenseConfigurationArn(model.licenseConfigurationArn);
        }

        public final String getLicenseConfigurationArn() {
            return licenseConfigurationArn;
        }

        @Override
        public final Builder licenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
            return this;
        }

        public final void setLicenseConfigurationArn(String licenseConfigurationArn) {
            this.licenseConfigurationArn = licenseConfigurationArn;
        }

        @Override
        public ImportImageLicenseConfigurationRequest build() {
            return new ImportImageLicenseConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
