/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the disks that are available for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceStorageInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceStorageInfo.Builder, InstanceStorageInfo> {
    private static final SdkField<Long> TOTAL_SIZE_IN_GB_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(InstanceStorageInfo::totalSizeInGB))
            .setter(setter(Builder::totalSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSizeInGB")
                    .unmarshallLocationName("totalSizeInGB").build()).build();

    private static final SdkField<List<DiskInfo>> DISKS_FIELD = SdkField
            .<List<DiskInfo>> builder(MarshallingType.LIST)
            .getter(getter(InstanceStorageInfo::disks))
            .setter(setter(Builder::disks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disks")
                    .unmarshallLocationName("disks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DiskInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DiskInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_SIZE_IN_GB_FIELD,
            DISKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long totalSizeInGB;

    private final List<DiskInfo> disks;

    private InstanceStorageInfo(BuilderImpl builder) {
        this.totalSizeInGB = builder.totalSizeInGB;
        this.disks = builder.disks;
    }

    /**
     * <p>
     * The total size of the disks, in GiB.
     * </p>
     * 
     * @return The total size of the disks, in GiB.
     */
    public Long totalSizeInGB() {
        return totalSizeInGB;
    }

    /**
     * <p>
     * Array describing the disks that are available for the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array describing the disks that are available for the instance type.
     */
    public List<DiskInfo> disks() {
        return disks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(disks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStorageInfo)) {
            return false;
        }
        InstanceStorageInfo other = (InstanceStorageInfo) obj;
        return Objects.equals(totalSizeInGB(), other.totalSizeInGB()) && Objects.equals(disks(), other.disks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceStorageInfo").add("TotalSizeInGB", totalSizeInGB()).add("Disks", disks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalSizeInGB":
            return Optional.ofNullable(clazz.cast(totalSizeInGB()));
        case "Disks":
            return Optional.ofNullable(clazz.cast(disks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStorageInfo, T> g) {
        return obj -> g.apply((InstanceStorageInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceStorageInfo> {
        /**
         * <p>
         * The total size of the disks, in GiB.
         * </p>
         * 
         * @param totalSizeInGB
         *        The total size of the disks, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSizeInGB(Long totalSizeInGB);

        /**
         * <p>
         * Array describing the disks that are available for the instance type.
         * </p>
         * 
         * @param disks
         *        Array describing the disks that are available for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(Collection<DiskInfo> disks);

        /**
         * <p>
         * Array describing the disks that are available for the instance type.
         * </p>
         * 
         * @param disks
         *        Array describing the disks that are available for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(DiskInfo... disks);

        /**
         * <p>
         * Array describing the disks that are available for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DiskInfo>.Builder} avoiding the need to
         * create one manually via {@link List<DiskInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DiskInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #disks(List<DiskInfo>)}.
         * 
         * @param disks
         *        a consumer that will call methods on {@link List<DiskInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disks(List<DiskInfo>)
         */
        Builder disks(Consumer<DiskInfo.Builder>... disks);
    }

    static final class BuilderImpl implements Builder {
        private Long totalSizeInGB;

        private List<DiskInfo> disks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStorageInfo model) {
            totalSizeInGB(model.totalSizeInGB);
            disks(model.disks);
        }

        public final Long getTotalSizeInGB() {
            return totalSizeInGB;
        }

        @Override
        public final Builder totalSizeInGB(Long totalSizeInGB) {
            this.totalSizeInGB = totalSizeInGB;
            return this;
        }

        public final void setTotalSizeInGB(Long totalSizeInGB) {
            this.totalSizeInGB = totalSizeInGB;
        }

        public final Collection<DiskInfo.Builder> getDisks() {
            return disks != null ? disks.stream().map(DiskInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder disks(Collection<DiskInfo> disks) {
            this.disks = DiskInfoListCopier.copy(disks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(DiskInfo... disks) {
            disks(Arrays.asList(disks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Consumer<DiskInfo.Builder>... disks) {
            disks(Stream.of(disks).map(c -> DiskInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDisks(Collection<DiskInfo.BuilderImpl> disks) {
            this.disks = DiskInfoListCopier.copyFromBuilder(disks);
        }

        @Override
        public InstanceStorageInfo build() {
            return new InstanceStorageInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
