/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateSubnetCidrBlockResponse extends Ec2Response implements
        ToCopyableBuilder<DisassociateSubnetCidrBlockResponse.Builder, DisassociateSubnetCidrBlockResponse> {
    private static final SdkField<SubnetIpv6CidrBlockAssociation> IPV6_CIDR_BLOCK_ASSOCIATION_FIELD = SdkField
            .<SubnetIpv6CidrBlockAssociation> builder(MarshallingType.SDK_POJO)
            .getter(getter(DisassociateSubnetCidrBlockResponse::ipv6CidrBlockAssociation))
            .setter(setter(Builder::ipv6CidrBlockAssociation))
            .constructor(SubnetIpv6CidrBlockAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociation")
                    .unmarshallLocationName("ipv6CidrBlockAssociation").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DisassociateSubnetCidrBlockResponse::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IPV6_CIDR_BLOCK_ASSOCIATION_FIELD, SUBNET_ID_FIELD));

    private final SubnetIpv6CidrBlockAssociation ipv6CidrBlockAssociation;

    private final String subnetId;

    private DisassociateSubnetCidrBlockResponse(BuilderImpl builder) {
        super(builder);
        this.ipv6CidrBlockAssociation = builder.ipv6CidrBlockAssociation;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * Information about the IPv6 CIDR block association.
     * </p>
     * 
     * @return Information about the IPv6 CIDR block association.
     */
    public SubnetIpv6CidrBlockAssociation ipv6CidrBlockAssociation() {
        return ipv6CidrBlockAssociation;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlockAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateSubnetCidrBlockResponse)) {
            return false;
        }
        DisassociateSubnetCidrBlockResponse other = (DisassociateSubnetCidrBlockResponse) obj;
        return Objects.equals(ipv6CidrBlockAssociation(), other.ipv6CidrBlockAssociation())
                && Objects.equals(subnetId(), other.subnetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisassociateSubnetCidrBlockResponse")
                .add("Ipv6CidrBlockAssociation", ipv6CidrBlockAssociation()).add("SubnetId", subnetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6CidrBlockAssociation":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockAssociation()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateSubnetCidrBlockResponse, T> g) {
        return obj -> g.apply((DisassociateSubnetCidrBlockResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateSubnetCidrBlockResponse> {
        /**
         * <p>
         * Information about the IPv6 CIDR block association.
         * </p>
         * 
         * @param ipv6CidrBlockAssociation
         *        Information about the IPv6 CIDR block association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociation(SubnetIpv6CidrBlockAssociation ipv6CidrBlockAssociation);

        /**
         * <p>
         * Information about the IPv6 CIDR block association.
         * </p>
         * This is a convenience that creates an instance of the {@link SubnetIpv6CidrBlockAssociation.Builder} avoiding
         * the need to create one manually via {@link SubnetIpv6CidrBlockAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link SubnetIpv6CidrBlockAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6CidrBlockAssociation(SubnetIpv6CidrBlockAssociation)}.
         * 
         * @param ipv6CidrBlockAssociation
         *        a consumer that will call methods on {@link SubnetIpv6CidrBlockAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrBlockAssociation(SubnetIpv6CidrBlockAssociation)
         */
        default Builder ipv6CidrBlockAssociation(Consumer<SubnetIpv6CidrBlockAssociation.Builder> ipv6CidrBlockAssociation) {
            return ipv6CidrBlockAssociation(SubnetIpv6CidrBlockAssociation.builder().applyMutation(ipv6CidrBlockAssociation)
                    .build());
        }

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private SubnetIpv6CidrBlockAssociation ipv6CidrBlockAssociation;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateSubnetCidrBlockResponse model) {
            super(model);
            ipv6CidrBlockAssociation(model.ipv6CidrBlockAssociation);
            subnetId(model.subnetId);
        }

        public final SubnetIpv6CidrBlockAssociation.Builder getIpv6CidrBlockAssociation() {
            return ipv6CidrBlockAssociation != null ? ipv6CidrBlockAssociation.toBuilder() : null;
        }

        @Override
        public final Builder ipv6CidrBlockAssociation(SubnetIpv6CidrBlockAssociation ipv6CidrBlockAssociation) {
            this.ipv6CidrBlockAssociation = ipv6CidrBlockAssociation;
            return this;
        }

        public final void setIpv6CidrBlockAssociation(SubnetIpv6CidrBlockAssociation.BuilderImpl ipv6CidrBlockAssociation) {
            this.ipv6CidrBlockAssociation = ipv6CidrBlockAssociation != null ? ipv6CidrBlockAssociation.build() : null;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public DisassociateSubnetCidrBlockResponse build() {
            return new DisassociateSubnetCidrBlockResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
