/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a local gateway virtual interface group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalGatewayVirtualInterfaceGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<LocalGatewayVirtualInterfaceGroup.Builder, LocalGatewayVirtualInterfaceGroup> {
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGatewayVirtualInterfaceGroup::localGatewayVirtualInterfaceGroupId))
            .setter(setter(Builder::localGatewayVirtualInterfaceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayVirtualInterfaceGroupId")
                    .unmarshallLocationName("localGatewayVirtualInterfaceGroupId").build()).build();

    private static final SdkField<List<String>> LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(LocalGatewayVirtualInterfaceGroup::localGatewayVirtualInterfaceIds))
            .setter(setter(Builder::localGatewayVirtualInterfaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceIdSet")
                    .unmarshallLocationName("localGatewayVirtualInterfaceIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGatewayVirtualInterfaceGroup::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("localGatewayId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_IDS_FIELD, LOCAL_GATEWAY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String localGatewayVirtualInterfaceGroupId;

    private final List<String> localGatewayVirtualInterfaceIds;

    private final String localGatewayId;

    private LocalGatewayVirtualInterfaceGroup(BuilderImpl builder) {
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.localGatewayVirtualInterfaceIds = builder.localGatewayVirtualInterfaceIds;
        this.localGatewayId = builder.localGatewayId;
    }

    /**
     * <p>
     * The ID of the virtual interface group.
     * </p>
     * 
     * @return The ID of the virtual interface group.
     */
    public String localGatewayVirtualInterfaceGroupId() {
        return localGatewayVirtualInterfaceGroupId;
    }

    /**
     * <p>
     * The IDs of the virtual interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the virtual interfaces.
     */
    public List<String> localGatewayVirtualInterfaceIds() {
        return localGatewayVirtualInterfaceIds;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public String localGatewayId() {
        return localGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceIds());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayVirtualInterfaceGroup)) {
            return false;
        }
        LocalGatewayVirtualInterfaceGroup other = (LocalGatewayVirtualInterfaceGroup) obj;
        return Objects.equals(localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId())
                && Objects.equals(localGatewayVirtualInterfaceIds(), other.localGatewayVirtualInterfaceIds())
                && Objects.equals(localGatewayId(), other.localGatewayId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LocalGatewayVirtualInterfaceGroup")
                .add("LocalGatewayVirtualInterfaceGroupId", localGatewayVirtualInterfaceGroupId())
                .add("LocalGatewayVirtualInterfaceIds", localGatewayVirtualInterfaceIds())
                .add("LocalGatewayId", localGatewayId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayVirtualInterfaceGroupId":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceGroupId()));
        case "LocalGatewayVirtualInterfaceIds":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceIds()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayVirtualInterfaceGroup, T> g) {
        return obj -> g.apply((LocalGatewayVirtualInterfaceGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalGatewayVirtualInterfaceGroup> {
        /**
         * <p>
         * The ID of the virtual interface group.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceGroupId
         *        The ID of the virtual interface group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId);

        /**
         * <p>
         * The IDs of the virtual interfaces.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceIds
         *        The IDs of the virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds);

        /**
         * <p>
         * The IDs of the virtual interfaces.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceIds
         *        The IDs of the virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceIds(String... localGatewayVirtualInterfaceIds);

        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);
    }

    static final class BuilderImpl implements Builder {
        private String localGatewayVirtualInterfaceGroupId;

        private List<String> localGatewayVirtualInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private String localGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayVirtualInterfaceGroup model) {
            localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            localGatewayVirtualInterfaceIds(model.localGatewayVirtualInterfaceIds);
            localGatewayId(model.localGatewayId);
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        public final Collection<String> getLocalGatewayVirtualInterfaceIds() {
            return localGatewayVirtualInterfaceIds;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIdSetCopier.copy(localGatewayVirtualInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayVirtualInterfaceIds(String... localGatewayVirtualInterfaceIds) {
            localGatewayVirtualInterfaceIds(Arrays.asList(localGatewayVirtualInterfaceIds));
            return this;
        }

        public final void setLocalGatewayVirtualInterfaceIds(Collection<String> localGatewayVirtualInterfaceIds) {
            this.localGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIdSetCopier.copy(localGatewayVirtualInterfaceIds);
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        @Override
        public LocalGatewayVirtualInterfaceGroup build() {
            return new LocalGatewayVirtualInterfaceGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
