/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the resources associated with the transit gateway multicast domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayMulticastDomainAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayMulticastDomainAssociation.Builder, TransitGatewayMulticastDomainAssociation> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastDomainAssociation::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("transitGatewayAttachmentId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastDomainAssociation::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastDomainAssociation::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<SubnetAssociation> SUBNET_FIELD = SdkField
            .<SubnetAssociation> builder(MarshallingType.SDK_POJO)
            .getter(getter(TransitGatewayMulticastDomainAssociation::subnet))
            .setter(setter(Builder::subnet))
            .constructor(SubnetAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet")
                    .unmarshallLocationName("subnet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, SUBNET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayAttachmentId;

    private final String resourceId;

    private final String resourceType;

    private final SubnetAssociation subnet;

    private TransitGatewayMulticastDomainAssociation(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.subnet = builder.subnet;
    }

    /**
     * <p>
     * The ID of the transit gateway attachment.
     * </p>
     * 
     * @return The ID of the transit gateway attachment.
     */
    public String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of resource, for example a VPC attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource, for example a VPC attachment.
     * @see TransitGatewayAttachmentResourceType
     */
    public TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource, for example a VPC attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource, for example a VPC attachment.
     * @see TransitGatewayAttachmentResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The subnet associated with the transit gateway multicast domain.
     * </p>
     * 
     * @return The subnet associated with the transit gateway multicast domain.
     */
    public SubnetAssociation subnet() {
        return subnet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subnet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMulticastDomainAssociation)) {
            return false;
        }
        TransitGatewayMulticastDomainAssociation other = (TransitGatewayMulticastDomainAssociation) obj;
        return Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(subnet(), other.subnet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransitGatewayMulticastDomainAssociation")
                .add("TransitGatewayAttachmentId", transitGatewayAttachmentId()).add("ResourceId", resourceId())
                .add("ResourceType", resourceTypeAsString()).add("Subnet", subnet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "Subnet":
            return Optional.ofNullable(clazz.cast(subnet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMulticastDomainAssociation, T> g) {
        return obj -> g.apply((TransitGatewayMulticastDomainAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayMulticastDomainAssociation> {
        /**
         * <p>
         * The ID of the transit gateway attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the transit gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of resource, for example a VPC attachment.
         * </p>
         * 
         * @param resourceType
         *        The type of resource, for example a VPC attachment.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource, for example a VPC attachment.
         * </p>
         * 
         * @param resourceType
         *        The type of resource, for example a VPC attachment.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(TransitGatewayAttachmentResourceType resourceType);

        /**
         * <p>
         * The subnet associated with the transit gateway multicast domain.
         * </p>
         * 
         * @param subnet
         *        The subnet associated with the transit gateway multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnet(SubnetAssociation subnet);

        /**
         * <p>
         * The subnet associated with the transit gateway multicast domain.
         * </p>
         * This is a convenience that creates an instance of the {@link SubnetAssociation.Builder} avoiding the need to
         * create one manually via {@link SubnetAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link SubnetAssociation.Builder#build()} is called immediately and its
         * result is passed to {@link #subnet(SubnetAssociation)}.
         * 
         * @param subnet
         *        a consumer that will call methods on {@link SubnetAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnet(SubnetAssociation)
         */
        default Builder subnet(Consumer<SubnetAssociation.Builder> subnet) {
            return subnet(SubnetAssociation.builder().applyMutation(subnet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayAttachmentId;

        private String resourceId;

        private String resourceType;

        private SubnetAssociation subnet;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMulticastDomainAssociation model) {
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            subnet(model.subnet);
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final SubnetAssociation.Builder getSubnet() {
            return subnet != null ? subnet.toBuilder() : null;
        }

        @Override
        public final Builder subnet(SubnetAssociation subnet) {
            this.subnet = subnet;
            return this;
        }

        public final void setSubnet(SubnetAssociation.BuilderImpl subnet) {
            this.subnet = subnet != null ? subnet.build() : null;
        }

        @Override
        public TransitGatewayMulticastDomainAssociation build() {
            return new TransitGatewayMulticastDomainAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
