/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> {
    private static final SdkField<List<LocalGatewayRouteTableVirtualInterfaceGroupAssociation>> LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.getter(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse::localGatewayRouteTableVirtualInterfaceGroupAssociations)).setter(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.setter(Builder::localGatewayRouteTableVirtualInterfaceGroupAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableVirtualInterfaceGroupAssociationSet").unmarshallLocationName("localGatewayRouteTableVirtualInterfaceGroupAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.getter(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse::nextToken)).setter(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> localGatewayRouteTableVirtualInterfaceGroupAssociations;
    private final String nextToken;

    private DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.localGatewayRouteTableVirtualInterfaceGroupAssociations = builder.localGatewayRouteTableVirtualInterfaceGroupAssociations;
        this.nextToken = builder.nextToken;
    }

    public List<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> localGatewayRouteTableVirtualInterfaceGroupAssociations() {
        return this.localGatewayRouteTableVirtualInterfaceGroupAssociations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayRouteTableVirtualInterfaceGroupAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse)) {
            return false;
        }
        DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse other = (DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse)((Object)obj);
        return Objects.equals(this.localGatewayRouteTableVirtualInterfaceGroupAssociations(), other.localGatewayRouteTableVirtualInterfaceGroupAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse").add("LocalGatewayRouteTableVirtualInterfaceGroupAssociations", this.localGatewayRouteTableVirtualInterfaceGroupAssociations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalGatewayRouteTableVirtualInterfaceGroupAssociations": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTableVirtualInterfaceGroupAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> localGatewayRouteTableVirtualInterfaceGroupAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse model) {
            super(model);
            this.localGatewayRouteTableVirtualInterfaceGroupAssociations(model.localGatewayRouteTableVirtualInterfaceGroupAssociations);
            this.nextToken(model.nextToken);
        }

        public final Collection<LocalGatewayRouteTableVirtualInterfaceGroupAssociation.Builder> getLocalGatewayRouteTableVirtualInterfaceGroupAssociations() {
            return this.localGatewayRouteTableVirtualInterfaceGroupAssociations != null ? (Collection)this.localGatewayRouteTableVirtualInterfaceGroupAssociations.stream().map(LocalGatewayRouteTableVirtualInterfaceGroupAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(Collection<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> localGatewayRouteTableVirtualInterfaceGroupAssociations) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociations = LocalGatewayRouteTableVirtualInterfaceGroupAssociationSetCopier.copy(localGatewayRouteTableVirtualInterfaceGroupAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(LocalGatewayRouteTableVirtualInterfaceGroupAssociation ... localGatewayRouteTableVirtualInterfaceGroupAssociations) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociations(Arrays.asList(localGatewayRouteTableVirtualInterfaceGroupAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(Consumer<LocalGatewayRouteTableVirtualInterfaceGroupAssociation.Builder> ... localGatewayRouteTableVirtualInterfaceGroupAssociations) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociations(Stream.of(localGatewayRouteTableVirtualInterfaceGroupAssociations).map(c -> (LocalGatewayRouteTableVirtualInterfaceGroupAssociation)((LocalGatewayRouteTableVirtualInterfaceGroupAssociation.Builder)LocalGatewayRouteTableVirtualInterfaceGroupAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalGatewayRouteTableVirtualInterfaceGroupAssociations(Collection<LocalGatewayRouteTableVirtualInterfaceGroupAssociation.BuilderImpl> localGatewayRouteTableVirtualInterfaceGroupAssociations) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociations = LocalGatewayRouteTableVirtualInterfaceGroupAssociationSetCopier.copyFromBuilder(localGatewayRouteTableVirtualInterfaceGroupAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse build() {
            return new DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> {
        public Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(Collection<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> var1);

        public Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(LocalGatewayRouteTableVirtualInterfaceGroupAssociation ... var1);

        public Builder localGatewayRouteTableVirtualInterfaceGroupAssociations(Consumer<LocalGatewayRouteTableVirtualInterfaceGroupAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

