/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransitGatewayPeeringAttachmentRequest extends Ec2Request implements
        ToCopyableBuilder<CreateTransitGatewayPeeringAttachmentRequest.Builder, CreateTransitGatewayPeeringAttachmentRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTransitGatewayPeeringAttachmentRequest::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("TransitGatewayId").build()).build();

    private static final SdkField<String> PEER_TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTransitGatewayPeeringAttachmentRequest::peerTransitGatewayId))
            .setter(setter(Builder::peerTransitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerTransitGatewayId")
                    .unmarshallLocationName("PeerTransitGatewayId").build()).build();

    private static final SdkField<String> PEER_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTransitGatewayPeeringAttachmentRequest::peerAccountId))
            .setter(setter(Builder::peerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAccountId")
                    .unmarshallLocationName("PeerAccountId").build()).build();

    private static final SdkField<String> PEER_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTransitGatewayPeeringAttachmentRequest::peerRegion))
            .setter(setter(Builder::peerRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerRegion")
                    .unmarshallLocationName("PeerRegion").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .getter(getter(CreateTransitGatewayPeeringAttachmentRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ID_FIELD,
            PEER_TRANSIT_GATEWAY_ID_FIELD, PEER_ACCOUNT_ID_FIELD, PEER_REGION_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final String transitGatewayId;

    private final String peerTransitGatewayId;

    private final String peerAccountId;

    private final String peerRegion;

    private final List<TagSpecification> tagSpecifications;

    private CreateTransitGatewayPeeringAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayId = builder.transitGatewayId;
        this.peerTransitGatewayId = builder.peerTransitGatewayId;
        this.peerAccountId = builder.peerAccountId;
        this.peerRegion = builder.peerRegion;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The ID of the transit gateway.
     * </p>
     * 
     * @return The ID of the transit gateway.
     */
    public String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The ID of the peer transit gateway with which to create the peering attachment.
     * </p>
     * 
     * @return The ID of the peer transit gateway with which to create the peering attachment.
     */
    public String peerTransitGatewayId() {
        return peerTransitGatewayId;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the peer transit gateway.
     * </p>
     * 
     * @return The AWS account ID of the owner of the peer transit gateway.
     */
    public String peerAccountId() {
        return peerAccountId;
    }

    /**
     * <p>
     * The Region where the peer transit gateway is located.
     * </p>
     * 
     * @return The Region where the peer transit gateway is located.
     */
    public String peerRegion() {
        return peerRegion;
    }

    /**
     * <p>
     * The tags to apply to the transit gateway peering attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to apply to the transit gateway peering attachment.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(peerTransitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(peerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(peerRegion());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayPeeringAttachmentRequest)) {
            return false;
        }
        CreateTransitGatewayPeeringAttachmentRequest other = (CreateTransitGatewayPeeringAttachmentRequest) obj;
        return Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(peerTransitGatewayId(), other.peerTransitGatewayId())
                && Objects.equals(peerAccountId(), other.peerAccountId()) && Objects.equals(peerRegion(), other.peerRegion())
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTransitGatewayPeeringAttachmentRequest").add("TransitGatewayId", transitGatewayId())
                .add("PeerTransitGatewayId", peerTransitGatewayId()).add("PeerAccountId", peerAccountId())
                .add("PeerRegion", peerRegion()).add("TagSpecifications", tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "PeerTransitGatewayId":
            return Optional.ofNullable(clazz.cast(peerTransitGatewayId()));
        case "PeerAccountId":
            return Optional.ofNullable(clazz.cast(peerAccountId()));
        case "PeerRegion":
            return Optional.ofNullable(clazz.cast(peerRegion()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayPeeringAttachmentRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayPeeringAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTransitGatewayPeeringAttachmentRequest> {
        /**
         * <p>
         * The ID of the transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The ID of the peer transit gateway with which to create the peering attachment.
         * </p>
         * 
         * @param peerTransitGatewayId
         *        The ID of the peer transit gateway with which to create the peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerTransitGatewayId(String peerTransitGatewayId);

        /**
         * <p>
         * The AWS account ID of the owner of the peer transit gateway.
         * </p>
         * 
         * @param peerAccountId
         *        The AWS account ID of the owner of the peer transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAccountId(String peerAccountId);

        /**
         * <p>
         * The Region where the peer transit gateway is located.
         * </p>
         * 
         * @param peerRegion
         *        The Region where the peer transit gateway is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerRegion(String peerRegion);

        /**
         * <p>
         * The tags to apply to the transit gateway peering attachment.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the transit gateway peering attachment.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the transit gateway peering attachment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String transitGatewayId;

        private String peerTransitGatewayId;

        private String peerAccountId;

        private String peerRegion;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayPeeringAttachmentRequest model) {
            super(model);
            transitGatewayId(model.transitGatewayId);
            peerTransitGatewayId(model.peerTransitGatewayId);
            peerAccountId(model.peerAccountId);
            peerRegion(model.peerRegion);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final String getPeerTransitGatewayId() {
            return peerTransitGatewayId;
        }

        @Override
        public final Builder peerTransitGatewayId(String peerTransitGatewayId) {
            this.peerTransitGatewayId = peerTransitGatewayId;
            return this;
        }

        public final void setPeerTransitGatewayId(String peerTransitGatewayId) {
            this.peerTransitGatewayId = peerTransitGatewayId;
        }

        public final String getPeerAccountId() {
            return peerAccountId;
        }

        @Override
        public final Builder peerAccountId(String peerAccountId) {
            this.peerAccountId = peerAccountId;
            return this;
        }

        public final void setPeerAccountId(String peerAccountId) {
            this.peerAccountId = peerAccountId;
        }

        public final String getPeerRegion() {
            return peerRegion;
        }

        @Override
        public final Builder peerRegion(String peerRegion) {
            this.peerRegion = peerRegion;
            return this;
        }

        public final void setPeerRegion(String peerRegion) {
            this.peerRegion = peerRegion;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayPeeringAttachmentRequest build() {
            return new CreateTransitGatewayPeeringAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
