/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Inference accelerators for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceAcceleratorInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceAcceleratorInfo.Builder, InferenceAcceleratorInfo> {
    private static final SdkField<List<InferenceDeviceInfo>> ACCELERATORS_FIELD = SdkField
            .<List<InferenceDeviceInfo>> builder(MarshallingType.LIST)
            .getter(getter(InferenceAcceleratorInfo::accelerators))
            .setter(setter(Builder::accelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerators")
                    .unmarshallLocationName("accelerators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceDeviceInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceDeviceInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InferenceDeviceInfo> accelerators;

    private InferenceAcceleratorInfo(BuilderImpl builder) {
        this.accelerators = builder.accelerators;
    }

    /**
     * <p>
     * Describes the Inference accelerators for the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Describes the Inference accelerators for the instance type.
     */
    public List<InferenceDeviceInfo> accelerators() {
        return accelerators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accelerators());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceAcceleratorInfo)) {
            return false;
        }
        InferenceAcceleratorInfo other = (InferenceAcceleratorInfo) obj;
        return Objects.equals(accelerators(), other.accelerators());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InferenceAcceleratorInfo").add("Accelerators", accelerators()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accelerators":
            return Optional.ofNullable(clazz.cast(accelerators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceAcceleratorInfo, T> g) {
        return obj -> g.apply((InferenceAcceleratorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceAcceleratorInfo> {
        /**
         * <p>
         * Describes the Inference accelerators for the instance type.
         * </p>
         * 
         * @param accelerators
         *        Describes the Inference accelerators for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerators(Collection<InferenceDeviceInfo> accelerators);

        /**
         * <p>
         * Describes the Inference accelerators for the instance type.
         * </p>
         * 
         * @param accelerators
         *        Describes the Inference accelerators for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerators(InferenceDeviceInfo... accelerators);

        /**
         * <p>
         * Describes the Inference accelerators for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InferenceDeviceInfo>.Builder} avoiding the
         * need to create one manually via {@link List<InferenceDeviceInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InferenceDeviceInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #accelerators(List<InferenceDeviceInfo>)}.
         * 
         * @param accelerators
         *        a consumer that will call methods on {@link List<InferenceDeviceInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accelerators(List<InferenceDeviceInfo>)
         */
        Builder accelerators(Consumer<InferenceDeviceInfo.Builder>... accelerators);
    }

    static final class BuilderImpl implements Builder {
        private List<InferenceDeviceInfo> accelerators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceAcceleratorInfo model) {
            accelerators(model.accelerators);
        }

        public final Collection<InferenceDeviceInfo.Builder> getAccelerators() {
            return accelerators != null ? accelerators.stream().map(InferenceDeviceInfo::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder accelerators(Collection<InferenceDeviceInfo> accelerators) {
            this.accelerators = InferenceDeviceInfoListCopier.copy(accelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(InferenceDeviceInfo... accelerators) {
            accelerators(Arrays.asList(accelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(Consumer<InferenceDeviceInfo.Builder>... accelerators) {
            accelerators(Stream.of(accelerators).map(c -> InferenceDeviceInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccelerators(Collection<InferenceDeviceInfo.BuilderImpl> accelerators) {
            this.accelerators = InferenceDeviceInfoListCopier.copyFromBuilder(accelerators);
        }

        @Override
        public InferenceAcceleratorInfo build() {
            return new InferenceAcceleratorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
