/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteTable implements SdkPojo, Serializable, ToCopyableBuilder<RouteTable.Builder, RouteTable> {
    private static final SdkField<List<RouteTableAssociation>> ASSOCIATIONS_FIELD = SdkField
            .<List<RouteTableAssociation>> builder(MarshallingType.LIST)
            .getter(getter(RouteTable::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSet")
                    .unmarshallLocationName("associationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RouteTableAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteTableAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<PropagatingVgw>> PROPAGATING_VGWS_FIELD = SdkField
            .<List<PropagatingVgw>> builder(MarshallingType.LIST)
            .getter(getter(RouteTable::propagatingVgws))
            .setter(setter(Builder::propagatingVgws))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagatingVgwSet")
                    .unmarshallLocationName("propagatingVgwSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PropagatingVgw> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropagatingVgw::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RouteTable::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId")
                    .unmarshallLocationName("routeTableId").build()).build();

    private static final SdkField<List<Route>> ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .getter(getter(RouteTable::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSet")
                    .unmarshallLocationName("routeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(RouteTable::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RouteTable::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RouteTable::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD,
            PROPAGATING_VGWS_FIELD, ROUTE_TABLE_ID_FIELD, ROUTES_FIELD, TAGS_FIELD, VPC_ID_FIELD, OWNER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RouteTableAssociation> associations;

    private final List<PropagatingVgw> propagatingVgws;

    private final String routeTableId;

    private final List<Route> routes;

    private final List<Tag> tags;

    private final String vpcId;

    private final String ownerId;

    private RouteTable(BuilderImpl builder) {
        this.associations = builder.associations;
        this.propagatingVgws = builder.propagatingVgws;
        this.routeTableId = builder.routeTableId;
        this.routes = builder.routes;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
        this.ownerId = builder.ownerId;
    }

    /**
     * <p>
     * The associations between the route table and one or more subnets or a gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The associations between the route table and one or more subnets or a gateway.
     */
    public List<RouteTableAssociation> associations() {
        return associations;
    }

    /**
     * <p>
     * Any virtual private gateway (VGW) propagating routes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any virtual private gateway (VGW) propagating routes.
     */
    public List<PropagatingVgw> propagatingVgws() {
        return propagatingVgws;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * The routes in the route table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The routes in the route table.
     */
    public List<Route> routes() {
        return routes;
    }

    /**
     * <p>
     * Any tags assigned to the route table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the route table.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the route table.
     * </p>
     * 
     * @return The ID of the AWS account that owns the route table.
     */
    public String ownerId() {
        return ownerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associations());
        hashCode = 31 * hashCode + Objects.hashCode(propagatingVgws());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(routes());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTable)) {
            return false;
        }
        RouteTable other = (RouteTable) obj;
        return Objects.equals(associations(), other.associations()) && Objects.equals(propagatingVgws(), other.propagatingVgws())
                && Objects.equals(routeTableId(), other.routeTableId()) && Objects.equals(routes(), other.routes())
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(ownerId(), other.ownerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RouteTable").add("Associations", associations()).add("PropagatingVgws", propagatingVgws())
                .add("RouteTableId", routeTableId()).add("Routes", routes()).add("Tags", tags()).add("VpcId", vpcId())
                .add("OwnerId", ownerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "PropagatingVgws":
            return Optional.ofNullable(clazz.cast(propagatingVgws()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteTable, T> g) {
        return obj -> g.apply((RouteTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteTable> {
        /**
         * <p>
         * The associations between the route table and one or more subnets or a gateway.
         * </p>
         * 
         * @param associations
         *        The associations between the route table and one or more subnets or a gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<RouteTableAssociation> associations);

        /**
         * <p>
         * The associations between the route table and one or more subnets or a gateway.
         * </p>
         * 
         * @param associations
         *        The associations between the route table and one or more subnets or a gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(RouteTableAssociation... associations);

        /**
         * <p>
         * The associations between the route table and one or more subnets or a gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RouteTableAssociation>.Builder} avoiding
         * the need to create one manually via {@link List<RouteTableAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RouteTableAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #associations(List<RouteTableAssociation>)}.
         * 
         * @param associations
         *        a consumer that will call methods on {@link List<RouteTableAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(List<RouteTableAssociation>)
         */
        Builder associations(Consumer<RouteTableAssociation.Builder>... associations);

        /**
         * <p>
         * Any virtual private gateway (VGW) propagating routes.
         * </p>
         * 
         * @param propagatingVgws
         *        Any virtual private gateway (VGW) propagating routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatingVgws(Collection<PropagatingVgw> propagatingVgws);

        /**
         * <p>
         * Any virtual private gateway (VGW) propagating routes.
         * </p>
         * 
         * @param propagatingVgws
         *        Any virtual private gateway (VGW) propagating routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatingVgws(PropagatingVgw... propagatingVgws);

        /**
         * <p>
         * Any virtual private gateway (VGW) propagating routes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PropagatingVgw>.Builder} avoiding the need
         * to create one manually via {@link List<PropagatingVgw>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PropagatingVgw>.Builder#build()} is called immediately and
         * its result is passed to {@link #propagatingVgws(List<PropagatingVgw>)}.
         * 
         * @param propagatingVgws
         *        a consumer that will call methods on {@link List<PropagatingVgw>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propagatingVgws(List<PropagatingVgw>)
         */
        Builder propagatingVgws(Consumer<PropagatingVgw.Builder>... propagatingVgws);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The routes in the route table.
         * </p>
         * 
         * @param routes
         *        The routes in the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<Route> routes);

        /**
         * <p>
         * The routes in the route table.
         * </p>
         * 
         * @param routes
         *        The routes in the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Route... routes);

        /**
         * <p>
         * The routes in the route table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Route>.Builder} avoiding the need to create
         * one manually via {@link List<Route>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Route>.Builder#build()} is called immediately and its result
         * is passed to {@link #routes(List<Route>)}.
         * 
         * @param routes
         *        a consumer that will call methods on {@link List<Route>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(List<Route>)
         */
        Builder routes(Consumer<Route.Builder>... routes);

        /**
         * <p>
         * Any tags assigned to the route table.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the route table.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the route table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The ID of the AWS account that owns the route table.
         * </p>
         * 
         * @param ownerId
         *        The ID of the AWS account that owns the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);
    }

    static final class BuilderImpl implements Builder {
        private List<RouteTableAssociation> associations = DefaultSdkAutoConstructList.getInstance();

        private List<PropagatingVgw> propagatingVgws = DefaultSdkAutoConstructList.getInstance();

        private String routeTableId;

        private List<Route> routes = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private String ownerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTable model) {
            associations(model.associations);
            propagatingVgws(model.propagatingVgws);
            routeTableId(model.routeTableId);
            routes(model.routes);
            tags(model.tags);
            vpcId(model.vpcId);
            ownerId(model.ownerId);
        }

        public final Collection<RouteTableAssociation.Builder> getAssociations() {
            return associations != null ? associations.stream().map(RouteTableAssociation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associations(Collection<RouteTableAssociation> associations) {
            this.associations = RouteTableAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(RouteTableAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<RouteTableAssociation.Builder>... associations) {
            associations(Stream.of(associations).map(c -> RouteTableAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAssociations(Collection<RouteTableAssociation.BuilderImpl> associations) {
            this.associations = RouteTableAssociationListCopier.copyFromBuilder(associations);
        }

        public final Collection<PropagatingVgw.Builder> getPropagatingVgws() {
            return propagatingVgws != null ? propagatingVgws.stream().map(PropagatingVgw::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder propagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copy(propagatingVgws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgws(PropagatingVgw... propagatingVgws) {
            propagatingVgws(Arrays.asList(propagatingVgws));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgws(Consumer<PropagatingVgw.Builder>... propagatingVgws) {
            propagatingVgws(Stream.of(propagatingVgws).map(c -> PropagatingVgw.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPropagatingVgws(Collection<PropagatingVgw.BuilderImpl> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copyFromBuilder(propagatingVgws);
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final Collection<Route.Builder> getRoutes() {
            return routes != null ? routes.stream().map(Route::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = RouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<Route.Builder>... routes) {
            routes(Stream.of(routes).map(c -> Route.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoutes(Collection<Route.BuilderImpl> routes) {
            this.routes = RouteListCopier.copyFromBuilder(routes);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public RouteTable build() {
            return new RouteTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
