/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the instances that were launched by the fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateFleetInstance.Builder, CreateFleetInstance> {
    private static final SdkField<LaunchTemplateAndOverridesResponse> LAUNCH_TEMPLATE_AND_OVERRIDES_FIELD = SdkField
            .<LaunchTemplateAndOverridesResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFleetInstance::launchTemplateAndOverrides))
            .setter(setter(Builder::launchTemplateAndOverrides))
            .constructor(LaunchTemplateAndOverridesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateAndOverrides")
                    .unmarshallLocationName("launchTemplateAndOverrides").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFleetInstance::lifecycleAsString))
            .setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle")
                    .unmarshallLocationName("lifecycle").build()).build();

    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateFleetInstance::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds")
                    .unmarshallLocationName("instanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFleetInstance::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFleetInstance::platformAsString))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("platform").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_TEMPLATE_AND_OVERRIDES_FIELD, LIFECYCLE_FIELD, INSTANCE_IDS_FIELD, INSTANCE_TYPE_FIELD, PLATFORM_FIELD));

    private static final long serialVersionUID = 1L;

    private final LaunchTemplateAndOverridesResponse launchTemplateAndOverrides;

    private final String lifecycle;

    private final List<String> instanceIds;

    private final String instanceType;

    private final String platform;

    private CreateFleetInstance(BuilderImpl builder) {
        this.launchTemplateAndOverrides = builder.launchTemplateAndOverrides;
        this.lifecycle = builder.lifecycle;
        this.instanceIds = builder.instanceIds;
        this.instanceType = builder.instanceType;
        this.platform = builder.platform;
    }

    /**
     * <p>
     * The launch templates and overrides that were used for launching the instances. Any parameters that you specify in
     * the Overrides override the same parameters in the launch template.
     * </p>
     * 
     * @return The launch templates and overrides that were used for launching the instances. Any parameters that you
     *         specify in the Overrides override the same parameters in the launch template.
     */
    public LaunchTemplateAndOverridesResponse launchTemplateAndOverrides() {
        return launchTemplateAndOverrides;
    }

    /**
     * <p>
     * Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link InstanceLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
     * @see InstanceLifecycle
     */
    public InstanceLifecycle lifecycle() {
        return InstanceLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link InstanceLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
     * @see InstanceLifecycle
     */
    public String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * Returns true if the InstanceIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the instances.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The value is <code>Windows</code> for Windows instances; otherwise blank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The value is <code>Windows</code> for Windows instances; otherwise blank.
     * @see PlatformValues
     */
    public PlatformValues platform() {
        return PlatformValues.fromValue(platform);
    }

    /**
     * <p>
     * The value is <code>Windows</code> for Windows instances; otherwise blank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The value is <code>Windows</code> for Windows instances; otherwise blank.
     * @see PlatformValues
     */
    public String platformAsString() {
        return platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateAndOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetInstance)) {
            return false;
        }
        CreateFleetInstance other = (CreateFleetInstance) obj;
        return Objects.equals(launchTemplateAndOverrides(), other.launchTemplateAndOverrides())
                && Objects.equals(lifecycleAsString(), other.lifecycleAsString())
                && Objects.equals(instanceIds(), other.instanceIds())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(platformAsString(), other.platformAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFleetInstance").add("LaunchTemplateAndOverrides", launchTemplateAndOverrides())
                .add("Lifecycle", lifecycleAsString()).add("InstanceIds", instanceIds())
                .add("InstanceType", instanceTypeAsString()).add("Platform", platformAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateAndOverrides":
            return Optional.ofNullable(clazz.cast(launchTemplateAndOverrides()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetInstance, T> g) {
        return obj -> g.apply((CreateFleetInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateFleetInstance> {
        /**
         * <p>
         * The launch templates and overrides that were used for launching the instances. Any parameters that you
         * specify in the Overrides override the same parameters in the launch template.
         * </p>
         * 
         * @param launchTemplateAndOverrides
         *        The launch templates and overrides that were used for launching the instances. Any parameters that you
         *        specify in the Overrides override the same parameters in the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse launchTemplateAndOverrides);

        /**
         * <p>
         * The launch templates and overrides that were used for launching the instances. Any parameters that you
         * specify in the Overrides override the same parameters in the launch template.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateAndOverridesResponse.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateAndOverridesResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateAndOverridesResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse)}.
         * 
         * @param launchTemplateAndOverrides
         *        a consumer that will call methods on {@link LaunchTemplateAndOverridesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse)
         */
        default Builder launchTemplateAndOverrides(Consumer<LaunchTemplateAndOverridesResponse.Builder> launchTemplateAndOverrides) {
            return launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse.builder()
                    .applyMutation(launchTemplateAndOverrides).build());
        }

        /**
         * <p>
         * Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
         * </p>
         * 
         * @param lifecycle
         *        Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
         * @see InstanceLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
         * </p>
         * 
         * @param lifecycle
         *        Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
         * @see InstanceLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycle
         */
        Builder lifecycle(InstanceLifecycle lifecycle);

        /**
         * <p>
         * The IDs of the instances.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The IDs of the instances.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The value is <code>Windows</code> for Windows instances; otherwise blank.
         * </p>
         * 
         * @param platform
         *        The value is <code>Windows</code> for Windows instances; otherwise blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * The value is <code>Windows</code> for Windows instances; otherwise blank.
         * </p>
         * 
         * @param platform
         *        The value is <code>Windows</code> for Windows instances; otherwise blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);
    }

    static final class BuilderImpl implements Builder {
        private LaunchTemplateAndOverridesResponse launchTemplateAndOverrides;

        private String lifecycle;

        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private String instanceType;

        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetInstance model) {
            launchTemplateAndOverrides(model.launchTemplateAndOverrides);
            lifecycle(model.lifecycle);
            instanceIds(model.instanceIds);
            instanceType(model.instanceType);
            platform(model.platform);
        }

        public final LaunchTemplateAndOverridesResponse.Builder getLaunchTemplateAndOverrides() {
            return launchTemplateAndOverrides != null ? launchTemplateAndOverrides.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse launchTemplateAndOverrides) {
            this.launchTemplateAndOverrides = launchTemplateAndOverrides;
            return this;
        }

        public final void setLaunchTemplateAndOverrides(LaunchTemplateAndOverridesResponse.BuilderImpl launchTemplateAndOverrides) {
            this.launchTemplateAndOverrides = launchTemplateAndOverrides != null ? launchTemplateAndOverrides.build() : null;
        }

        public final String getLifecycleAsString() {
            return lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(InstanceLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsSetCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsSetCopier.copy(instanceIds);
        }

        public final String getInstanceTypeAsString() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getPlatformAsString() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public CreateFleetInstance build() {
            return new CreateFleetInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
