/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstancesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeInstancesRequest.Builder, DescribeInstancesRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeInstancesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeInstancesRequest::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("InstanceId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("InstanceId").unmarshallLocationName("InstanceId").build())
                                            .build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeInstancesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInstancesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            INSTANCE_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Filter> filters;

    private final List<String> instanceIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.instanceIds = builder.instanceIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (<code>default</code> |
     * <code>host</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
     * <code>arm64</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for
     * example, <code>2010-09-15T17:15:20.000Z</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is
     * deleted on instance termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
     * example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
     * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client-token</code> - The idempotency token you provided when you launched the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dns-name</code> - The public DNS name of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for
     * hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>image-id</code> - The ID of the image used to launch the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
     * <code>spot</code> | <code>scheduled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is used
     * for internal purposes and should be ignored. The low byte is set based on the state represented. The valid values
     * are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
     * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance.group-id</code> - The ID of the security group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance.group-name</code> - The name of the security group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-address</code> - The public IPv4 address of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kernel-id</code> - The kernel ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key-name</code> - The name of the key pair used when the instance was launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the launch
     * group (for example, 0, 1, 2, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch-time</code> - The time when the instance was launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> |
     * <code>required</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>metadata-options.http-put-response-hop-limit</code> - The http metadata request put response hop limit
     * (integer, possible values <code>1</code> to <code>64</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>metadata-options.http-endpoint</code> - Enable or disable metadata access on http endpoint (
     * <code>enabled</code> | <code>disabled</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
     * <code>enabled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the
     * network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network interface is
     * the primary private IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP
     * address (IPv4) with a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address
     * associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the
     * network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated
     * with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the
     * Elastic IP address (IPv4) for your network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.association-id</code> - The association ID returned when the network
     * interface was associated with an IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface is
     * attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the network
     * interface is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.device-index</code> - The device index to which the network interface is
     * attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
     * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to an
     * instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted
     * when an instance is terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.description</code> - The description of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.group-name</code> - The name of a security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.mac-address</code> - The MAC address of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.network-interface-id</code> - The ID of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.requester-id</code> - The requester ID for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed by
     * AWS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
     * <code>in-use</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination
     * checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking
     * is disabled. The value must be <code>false</code> for the network interface to perform network address
     * translation (NAT) in your VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The AWS account ID of the instance owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>placement-group-name</code> - The name of the placement group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>placement-partition-number</code> - The partition in which the instance is located.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-ip-address</code> - The private IPv4 address of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code</code> - The product code associated with the AMI used to launch the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ramdisk-id</code> - The RAM disk ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reason</code> - The reason for the current state of the instance (for example, shows
     * "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
     * Management Console, Auto Scaling, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you
     * launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can be
     * associated with more than one instance if you launch multiple instances using the same launch request. For
     * example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same
     * launch request, you also get one reservation ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
     * <code>instance-store</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value of
     * <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. The
     * value must be <code>false</code> for the instance to perform network address translation (NAT) in your VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state-reason-code</code> - The reason code for the state change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state-reason-message</code> - A message that describes the state change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>subnet-id</code> - The ID of the subnet for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that have
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
     * <code>host</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
     * <code>hvm</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC that the instance is running in.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
     *         <code>default</code> | <code>host</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
     *         <code>arm64</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance,
     *         for example, <code>2010-09-15T17:15:20.000Z</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume
     *         is deleted on instance termination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping
     *         (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
     *         <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client-token</code> - The idempotency token you provided when you launched the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dns-name</code> - The public DNS name of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled
     *         for hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as
     *         an ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>image-id</code> - The ID of the image used to launch the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
     *         <code>spot</code> | <code>scheduled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte
     *         is used for internal purposes and should be ignored. The low byte is set based on the state represented.
     *         The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and
     *         80 (stopped).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code>
     *         | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance.group-id</code> - The ID of the security group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance.group-name</code> - The name of the security group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-address</code> - The public IPv4 address of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kernel-id</code> - The kernel ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>key-name</code> - The name of the key pair used when the instance was launched.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the
     *         launch group (for example, 0, 1, 2, and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch-time</code> - The time when the instance was launched.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>metadata-options.http-tokens</code> - The metadata request authorization state (
     *         <code>optional</code> | <code>required</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>metadata-options.http-put-response-hop-limit</code> - The http metadata request put response hop
     *         limit (integer, possible values <code>1</code> to <code>64</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>metadata-options.http-endpoint</code> - Enable or disable metadata access on http endpoint (
     *         <code>enabled</code> | <code>disabled</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
     *         <code>enabled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with
     *         the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
     *         interface is the primary private IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic
     *         IP address (IPv4) with a network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4
     *         address associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound
     *         to the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
     *         associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated
     *         the Elastic IP address (IPv4) for your network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.association-id</code> - The association ID returned when the network
     *         interface was associated with an IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network
     *         interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the
     *         network interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.device-index</code> - The device index to which the network interface
     *         is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
     *         <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached
     *         to an instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is
     *         deleted when an instance is terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.description</code> - The description of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.group-id</code> - The ID of a security group associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.group-name</code> - The name of a security group associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.mac-address</code> - The MAC address of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.network-interface-id</code> - The ID of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.requester-id</code> - The requester ID for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.requester-managed</code> - Indicates whether the network interface is being
     *         managed by AWS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
     *         <code>in-use</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.source-dest-check</code> - Whether the network interface performs
     *         source/destination checking. A value of <code>true</code> means that checking is enabled, and
     *         <code>false</code> means that checking is disabled. The value must be <code>false</code> for the network
     *         interface to perform network address translation (NAT) in your VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The AWS account ID of the instance owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>placement-group-name</code> - The name of the placement group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>placement-partition-number</code> - The partition in which the instance is located.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-ip-address</code> - The private IPv4 address of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code</code> - The product code associated with the AMI used to launch the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>
     *         ).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ramdisk-id</code> - The RAM disk ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reason</code> - The reason for the current state of the instance (for example, shows
     *         "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code
     *         filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example,
     *         AWS Management Console, Auto Scaling, and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time
     *         you launch an instance. A reservation ID has a one-to-one relationship with an instance launch request,
     *         but can be associated with more than one instance if you launch multiple instances using the same launch
     *         request. For example, if you launch one instance, you get one reservation ID. If you launch ten instances
     *         using the same launch request, you also get one reservation ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>root-device-name</code> - The device name of the root device volume (for example,
     *         <code>/dev/sda1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
     *         <code>instance-store</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A
     *         value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is
     *         disabled. The value must be <code>false</code> for the instance to perform network address translation
     *         (NAT) in your VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state-reason-code</code> - The reason code for the state change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state-reason-message</code> - A message that describes the state change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>subnet-id</code> - The ID of the subnet for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         that have a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
     *         <code>host</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
     *         <code>hvm</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC that the instance is running in.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * Returns true if the InstanceIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance IDs.
     * </p>
     * <p>
     * Default: Describes all your instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The instance IDs.</p>
     *         <p>
     *         Default: Describes all your instances.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this
     * parameter and the instance IDs parameter in the same call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot
     *         specify this parameter and the instance IDs parameter in the same call.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesRequest)) {
            return false;
        }
        DescribeInstancesRequest other = (DescribeInstancesRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(instanceIds(), other.instanceIds())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeInstancesRequest").add("Filters", filters()).add("InstanceIds", instanceIds())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancesRequest, T> g) {
        return obj -> g.apply((DescribeInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstancesRequest> {
        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         * <code>default</code> | <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
         * <code>arm64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for
         * example, <code>2010-09-15T17:15:20.000Z</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is
         * deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
         * example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token you provided when you launched the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dns-name</code> - The public DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for
         * hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an
         * ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
         * <code>spot</code> | <code>scheduled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is
         * used for internal purposes and should be ignored. The low byte is set based on the state represented. The
         * valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80
         * (stopped).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
         * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-id</code> - The ID of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-name</code> - The name of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address</code> - The public IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair used when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the
         * launch group (for example, 0, 1, 2, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-time</code> - The time when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> |
         * <code>required</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-put-response-hop-limit</code> - The http metadata request put response hop limit
         * (integer, possible values <code>1</code> to <code>64</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-endpoint</code> - Enable or disable metadata access on http endpoint (
         * <code>enabled</code> | <code>disabled</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
         * <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         * interface is the primary private IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP
         * address (IPv4) with a network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the
         * Elastic IP address (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.association-id</code> - The association ID returned when the network
         * interface was associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface
         * is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the
         * network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.device-index</code> - The device index to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to
         * an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted
         * when an instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-name</code> - The name of a security group associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-id</code> - The requester ID for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed
         * by AWS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         * <code>in-use</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination
         * checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that
         * checking is disabled. The value must be <code>false</code> for the network interface to perform network
         * address translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the instance owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-group-name</code> - The name of the placement group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-partition-number</code> - The partition in which the instance is located.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reason</code> - The reason for the current state of the instance (for example, shows
         * "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
         * Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you
         * launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can
         * be associated with more than one instance if you launch multiple instances using the same launch request. For
         * example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same
         * launch request, you also get one reservation ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The device name of the root device volume (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value
         * of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled.
         * The value must be <code>false</code> for the instance to perform network address translation (NAT) in your
         * VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - A message that describes the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that
         * have a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         * <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         * <code>hvm</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         *        <code>default</code> | <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
         *        <code>arm64</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the
         *        instance, for example, <code>2010-09-15T17:15:20.000Z</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS
         *        volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping
         *        (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token you provided when you launched the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dns-name</code> - The public DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled
         *        for hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified
         *        as an ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the image used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
         *        <code>spot</code> | <code>scheduled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high
         *        byte is used for internal purposes and should be ignored. The low byte is set based on the state
         *        represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
         *        (stopping), and 80 (stopped).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-name</code> - The state of the instance (<code>pending</code> |
         *        <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> |
         *        <code>stopped</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-id</code> - The ID of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-name</code> - The name of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-address</code> - The public IPv4 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key-name</code> - The name of the key pair used when the instance was launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-index</code> - When launching multiple instances, this is the index for the instance in
         *        the launch group (for example, 0, 1, 2, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-time</code> - The time when the instance was launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-tokens</code> - The metadata request authorization state (
         *        <code>optional</code> | <code>required</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-put-response-hop-limit</code> - The http metadata request put response hop
         *        limit (integer, possible values <code>1</code> to <code>64</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-endpoint</code> - Enable or disable metadata access on http endpoint (
         *        <code>enabled</code> | <code>disabled</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (
         *        <code>disabled</code> | <code>enabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with
         *        the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         *        interface is the primary private IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an
         *        Elastic IP address (IPv4) with a network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4
         *        address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4)
         *        bound to the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         *        associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.allocation-id</code> - The allocation ID returned when you
         *        allocated the Elastic IP address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.association-id</code> - The association ID returned when the
         *        network interface was associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which
         *        the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.device-index</code> - The device index to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.status</code> - The status of the attachment (
         *        <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attach-time</code> - The time that the network interface was
         *        attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is
         *        deleted when an instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-id</code> - The ID of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-name</code> - The name of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-id</code> - The requester ID for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-managed</code> - Indicates whether the network interface is being
         *        managed by AWS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         *        <code>in-use</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.source-dest-check</code> - Whether the network interface performs
         *        source/destination checking. A value of <code>true</code> means that checking is enabled, and
         *        <code>false</code> means that checking is disabled. The value must be <code>false</code> for the
         *        network interface to perform network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the instance owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-group-name</code> - The name of the placement group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-partition-number</code> - The partition in which the instance is located.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code.type</code> - The type of product code (<code>devpay</code> |
         *        <code>marketplace</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reason</code> - The reason for the current state of the instance (for example, shows
         *        "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code
         *        filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for
         *        example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any
         *        time you launch an instance. A reservation ID has a one-to-one relationship with an instance launch
         *        request, but can be associated with more than one instance if you launch multiple instances using the
         *        same launch request. For example, if you launch one instance, you get one reservation ID. If you
         *        launch ten instances using the same launch request, you also get one reservation ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-name</code> - The device name of the root device volume (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         *        <code>instance-store</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking.
         *        A value of <code>true</code> means that checking is enabled, and <code>false</code> means that
         *        checking is disabled. The value must be <code>false</code> for the instance to perform network address
         *        translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-code</code> - The reason code for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-message</code> - A message that describes the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources that have a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         *        <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         *        <code>hvm</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         * <code>default</code> | <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
         * <code>arm64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for
         * example, <code>2010-09-15T17:15:20.000Z</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is
         * deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
         * example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token you provided when you launched the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dns-name</code> - The public DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for
         * hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an
         * ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
         * <code>spot</code> | <code>scheduled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is
         * used for internal purposes and should be ignored. The low byte is set based on the state represented. The
         * valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80
         * (stopped).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
         * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-id</code> - The ID of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-name</code> - The name of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address</code> - The public IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair used when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the
         * launch group (for example, 0, 1, 2, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-time</code> - The time when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> |
         * <code>required</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-put-response-hop-limit</code> - The http metadata request put response hop limit
         * (integer, possible values <code>1</code> to <code>64</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-endpoint</code> - Enable or disable metadata access on http endpoint (
         * <code>enabled</code> | <code>disabled</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
         * <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         * interface is the primary private IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP
         * address (IPv4) with a network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the
         * Elastic IP address (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.association-id</code> - The association ID returned when the network
         * interface was associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface
         * is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the
         * network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.device-index</code> - The device index to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to
         * an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted
         * when an instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-name</code> - The name of a security group associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-id</code> - The requester ID for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed
         * by AWS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         * <code>in-use</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination
         * checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that
         * checking is disabled. The value must be <code>false</code> for the network interface to perform network
         * address translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the instance owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-group-name</code> - The name of the placement group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-partition-number</code> - The partition in which the instance is located.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reason</code> - The reason for the current state of the instance (for example, shows
         * "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
         * Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you
         * launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can
         * be associated with more than one instance if you launch multiple instances using the same launch request. For
         * example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same
         * launch request, you also get one reservation ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The device name of the root device volume (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value
         * of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled.
         * The value must be <code>false</code> for the instance to perform network address translation (NAT) in your
         * VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - A message that describes the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that
         * have a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         * <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         * <code>hvm</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         *        <code>default</code> | <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
         *        <code>arm64</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the
         *        instance, for example, <code>2010-09-15T17:15:20.000Z</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS
         *        volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping
         *        (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token you provided when you launched the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dns-name</code> - The public DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled
         *        for hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified
         *        as an ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the image used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
         *        <code>spot</code> | <code>scheduled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high
         *        byte is used for internal purposes and should be ignored. The low byte is set based on the state
         *        represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
         *        (stopping), and 80 (stopped).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-name</code> - The state of the instance (<code>pending</code> |
         *        <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> |
         *        <code>stopped</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-id</code> - The ID of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-name</code> - The name of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-address</code> - The public IPv4 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key-name</code> - The name of the key pair used when the instance was launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-index</code> - When launching multiple instances, this is the index for the instance in
         *        the launch group (for example, 0, 1, 2, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-time</code> - The time when the instance was launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-tokens</code> - The metadata request authorization state (
         *        <code>optional</code> | <code>required</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-put-response-hop-limit</code> - The http metadata request put response hop
         *        limit (integer, possible values <code>1</code> to <code>64</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-endpoint</code> - Enable or disable metadata access on http endpoint (
         *        <code>enabled</code> | <code>disabled</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (
         *        <code>disabled</code> | <code>enabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with
         *        the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         *        interface is the primary private IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an
         *        Elastic IP address (IPv4) with a network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4
         *        address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4)
         *        bound to the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         *        associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.allocation-id</code> - The allocation ID returned when you
         *        allocated the Elastic IP address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.association-id</code> - The association ID returned when the
         *        network interface was associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which
         *        the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.device-index</code> - The device index to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.status</code> - The status of the attachment (
         *        <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attach-time</code> - The time that the network interface was
         *        attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is
         *        deleted when an instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-id</code> - The ID of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-name</code> - The name of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-id</code> - The requester ID for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-managed</code> - Indicates whether the network interface is being
         *        managed by AWS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         *        <code>in-use</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.source-dest-check</code> - Whether the network interface performs
         *        source/destination checking. A value of <code>true</code> means that checking is enabled, and
         *        <code>false</code> means that checking is disabled. The value must be <code>false</code> for the
         *        network interface to perform network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the instance owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-group-name</code> - The name of the placement group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-partition-number</code> - The partition in which the instance is located.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code.type</code> - The type of product code (<code>devpay</code> |
         *        <code>marketplace</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reason</code> - The reason for the current state of the instance (for example, shows
         *        "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code
         *        filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for
         *        example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any
         *        time you launch an instance. A reservation ID has a one-to-one relationship with an instance launch
         *        request, but can be associated with more than one instance if you launch multiple instances using the
         *        same launch request. For example, if you launch one instance, you get one reservation ID. If you
         *        launch ten instances using the same launch request, you also get one reservation ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-name</code> - The device name of the root device volume (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         *        <code>instance-store</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking.
         *        A value of <code>true</code> means that checking is enabled, and <code>false</code> means that
         *        checking is disabled. The value must be <code>false</code> for the instance to perform network address
         *        translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-code</code> - The reason code for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-message</code> - A message that describes the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources that have a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         *        <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         *        <code>hvm</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         * <code>default</code> | <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
         * <code>arm64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for
         * example, <code>2010-09-15T17:15:20.000Z</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is
         * deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
         * example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token you provided when you launched the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dns-name</code> - The public DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for
         * hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an
         * ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
         * <code>spot</code> | <code>scheduled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is
         * used for internal purposes and should be ignored. The low byte is set based on the state represented. The
         * valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80
         * (stopped).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
         * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-id</code> - The ID of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-name</code> - The name of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address</code> - The public IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair used when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the
         * launch group (for example, 0, 1, 2, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-time</code> - The time when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> |
         * <code>required</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-put-response-hop-limit</code> - The http metadata request put response hop limit
         * (integer, possible values <code>1</code> to <code>64</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-endpoint</code> - Enable or disable metadata access on http endpoint (
         * <code>enabled</code> | <code>disabled</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
         * <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         * interface is the primary private IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP
         * address (IPv4) with a network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the
         * Elastic IP address (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.association-id</code> - The association ID returned when the network
         * interface was associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface
         * is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the
         * network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.device-index</code> - The device index to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to
         * an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted
         * when an instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-name</code> - The name of a security group associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-id</code> - The requester ID for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed
         * by AWS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         * <code>in-use</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination
         * checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that
         * checking is disabled. The value must be <code>false</code> for the network interface to perform network
         * address translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the instance owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-group-name</code> - The name of the placement group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-partition-number</code> - The partition in which the instance is located.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reason</code> - The reason for the current state of the instance (for example, shows
         * "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
         * Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you
         * launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can
         * be associated with more than one instance if you launch multiple instances using the same launch request. For
         * example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same
         * launch request, you also get one reservation ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The device name of the root device volume (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value
         * of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled.
         * The value must be <code>false</code> for the instance to perform network address translation (NAT) in your
         * VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - A message that describes the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that
         * have a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         * <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         * <code>hvm</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The instance IDs.
         * </p>
         * <p>
         * Default: Describes all your instances.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs.</p>
         *        <p>
         *        Default: Describes all your instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The instance IDs.
         * </p>
         * <p>
         * Default: Describes all your instances.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs.</p>
         *        <p>
         *        Default: Describes all your instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify
         * this parameter and the instance IDs parameter in the same call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You
         *        cannot specify this parameter and the instance IDs parameter in the same call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesRequest model) {
            super(model);
            filters(model.filters);
            instanceIds(model.instanceIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancesRequest build() {
            return new DescribeInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
