/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Inference accelerators for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceDeviceInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceDeviceInfo.Builder, InferenceDeviceInfo> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InferenceDeviceInfo::count))
            .setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count")
                    .unmarshallLocationName("count").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InferenceDeviceInfo::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<String> MANUFACTURER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InferenceDeviceInfo::manufacturer))
            .setter(setter(Builder::manufacturer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manufacturer")
                    .unmarshallLocationName("manufacturer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, NAME_FIELD,
            MANUFACTURER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final String name;

    private final String manufacturer;

    private InferenceDeviceInfo(BuilderImpl builder) {
        this.count = builder.count;
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
    }

    /**
     * <p>
     * The number of Inference accelerators for the instance type.
     * </p>
     * 
     * @return The number of Inference accelerators for the instance type.
     */
    public Integer count() {
        return count;
    }

    /**
     * <p>
     * The name of the Inference accelerator.
     * </p>
     * 
     * @return The name of the Inference accelerator.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The manufacturer of the Inference accelerator.
     * </p>
     * 
     * @return The manufacturer of the Inference accelerator.
     */
    public String manufacturer() {
        return manufacturer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(manufacturer());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceDeviceInfo)) {
            return false;
        }
        InferenceDeviceInfo other = (InferenceDeviceInfo) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(name(), other.name())
                && Objects.equals(manufacturer(), other.manufacturer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InferenceDeviceInfo").add("Count", count()).add("Name", name())
                .add("Manufacturer", manufacturer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Manufacturer":
            return Optional.ofNullable(clazz.cast(manufacturer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceDeviceInfo, T> g) {
        return obj -> g.apply((InferenceDeviceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceDeviceInfo> {
        /**
         * <p>
         * The number of Inference accelerators for the instance type.
         * </p>
         * 
         * @param count
         *        The number of Inference accelerators for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The name of the Inference accelerator.
         * </p>
         * 
         * @param name
         *        The name of the Inference accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The manufacturer of the Inference accelerator.
         * </p>
         * 
         * @param manufacturer
         *        The manufacturer of the Inference accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturer(String manufacturer);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private String name;

        private String manufacturer;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceDeviceInfo model) {
            count(model.count);
            name(model.name);
            manufacturer(model.manufacturer);
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getManufacturer() {
            return manufacturer;
        }

        @Override
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        @Override
        public InferenceDeviceInfo build() {
            return new InferenceDeviceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
