/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements SdkPojo, Serializable, ToCopyableBuilder<Instance.Builder, Instance> {
    private static final SdkField<Integer> AMI_LAUNCH_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Instance::amiLaunchIndex))
            .setter(setter(Builder::amiLaunchIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiLaunchIndex")
                    .unmarshallLocationName("amiLaunchIndex").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("kernelId").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("keyName").build()).build();

    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Instance::launchTime))
            .setter(setter(Builder::launchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime")
                    .unmarshallLocationName("launchTime").build()).build();

    private static final SdkField<Monitoring> MONITORING_FIELD = SdkField
            .<Monitoring> builder(MarshallingType.SDK_POJO)
            .getter(getter(Instance::monitoring))
            .setter(setter(Builder::monitoring))
            .constructor(Monitoring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring")
                    .unmarshallLocationName("monitoring").build()).build();

    private static final SdkField<Placement> PLACEMENT_FIELD = SdkField
            .<Placement> builder(MarshallingType.SDK_POJO)
            .getter(getter(Instance::placement))
            .setter(setter(Builder::placement))
            .constructor(Placement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement")
                    .unmarshallLocationName("placement").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::platformAsString))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("platform").build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName")
                    .unmarshallLocationName("privateDnsName").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .getter(getter(Instance::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes")
                    .unmarshallLocationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> PUBLIC_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::publicDnsName))
            .setter(setter(Builder::publicDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName")
                    .unmarshallLocationName("dnsName").build()).build();

    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::publicIpAddress))
            .setter(setter(Builder::publicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress")
                    .unmarshallLocationName("ipAddress").build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId")
                    .unmarshallLocationName("ramdiskId").build()).build();

    private static final SdkField<InstanceState> STATE_FIELD = SdkField
            .<InstanceState> builder(MarshallingType.SDK_POJO)
            .getter(getter(Instance::state))
            .setter(setter(Builder::state))
            .constructor(InstanceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceState")
                    .unmarshallLocationName("instanceState").build()).build();

    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::stateTransitionReason))
            .setter(setter(Builder::stateTransitionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason")
                    .unmarshallLocationName("reason").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::architectureAsString))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture")
                    .unmarshallLocationName("architecture").build()).build();

    private static final SdkField<List<InstanceBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<InstanceBlockDeviceMapping>> builder(MarshallingType.LIST)
            .getter(getter(Instance::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceBlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceBlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Instance::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("ebsOptimized").build()).build();

    private static final SdkField<Boolean> ENA_SUPPORT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Instance::enaSupport))
            .setter(setter(Builder::enaSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport")
                    .unmarshallLocationName("enaSupport").build()).build();

    private static final SdkField<String> HYPERVISOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::hypervisorAsString))
            .setter(setter(Builder::hypervisor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor")
                    .unmarshallLocationName("hypervisor").build()).build();

    private static final SdkField<IamInstanceProfile> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<IamInstanceProfile> builder(MarshallingType.SDK_POJO)
            .getter(getter(Instance::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile))
            .constructor(IamInstanceProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile")
                    .unmarshallLocationName("iamInstanceProfile").build()).build();

    private static final SdkField<String> INSTANCE_LIFECYCLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::instanceLifecycleAsString))
            .setter(setter(Builder::instanceLifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceLifecycle")
                    .unmarshallLocationName("instanceLifecycle").build()).build();

    private static final SdkField<List<ElasticGpuAssociation>> ELASTIC_GPU_ASSOCIATIONS_FIELD = SdkField
            .<List<ElasticGpuAssociation>> builder(MarshallingType.LIST)
            .getter(getter(Instance::elasticGpuAssociations))
            .setter(setter(Builder::elasticGpuAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuAssociationSet")
                    .unmarshallLocationName("elasticGpuAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ElasticGpuAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticGpuAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<ElasticInferenceAcceleratorAssociation>> ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATIONS_FIELD = SdkField
            .<List<ElasticInferenceAcceleratorAssociation>> builder(MarshallingType.LIST)
            .getter(getter(Instance::elasticInferenceAcceleratorAssociations))
            .setter(setter(Builder::elasticInferenceAcceleratorAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ElasticInferenceAcceleratorAssociationSet")
                    .unmarshallLocationName("elasticInferenceAcceleratorAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ElasticInferenceAcceleratorAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticInferenceAcceleratorAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<InstanceNetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<InstanceNetworkInterface>> builder(MarshallingType.LIST)
            .getter(getter(Instance::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceSet")
                    .unmarshallLocationName("networkInterfaceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceNetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceNetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<String> ROOT_DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::rootDeviceName))
            .setter(setter(Builder::rootDeviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceName")
                    .unmarshallLocationName("rootDeviceName").build()).build();

    private static final SdkField<String> ROOT_DEVICE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::rootDeviceTypeAsString))
            .setter(setter(Builder::rootDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceType")
                    .unmarshallLocationName("rootDeviceType").build()).build();

    private static final SdkField<List<GroupIdentifier>> SECURITY_GROUPS_FIELD = SdkField
            .<List<GroupIdentifier>> builder(MarshallingType.LIST)
            .getter(getter(Instance::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet")
                    .unmarshallLocationName("groupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<GroupIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Instance::sourceDestCheck))
            .setter(setter(Builder::sourceDestCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck")
                    .unmarshallLocationName("sourceDestCheck").build()).build();

    private static final SdkField<String> SPOT_INSTANCE_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::spotInstanceRequestId))
            .setter(setter(Builder::spotInstanceRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId")
                    .unmarshallLocationName("spotInstanceRequestId").build()).build();

    private static final SdkField<String> SRIOV_NET_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::sriovNetSupport))
            .setter(setter(Builder::sriovNetSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport")
                    .unmarshallLocationName("sriovNetSupport").build()).build();

    private static final SdkField<StateReason> STATE_REASON_FIELD = SdkField
            .<StateReason> builder(MarshallingType.SDK_POJO)
            .getter(getter(Instance::stateReason))
            .setter(setter(Builder::stateReason))
            .constructor(StateReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason")
                    .unmarshallLocationName("stateReason").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(Instance::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::virtualizationTypeAsString))
            .setter(setter(Builder::virtualizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType")
                    .unmarshallLocationName("virtualizationType").build()).build();

    private static final SdkField<CpuOptions> CPU_OPTIONS_FIELD = SdkField
            .<CpuOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(Instance::cpuOptions))
            .setter(setter(Builder::cpuOptions))
            .constructor(CpuOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions")
                    .unmarshallLocationName("cpuOptions").build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("capacityReservationId").build()).build();

    private static final SdkField<CapacityReservationSpecificationResponse> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField
            .<CapacityReservationSpecificationResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(Instance::capacityReservationSpecification))
            .setter(setter(Builder::capacityReservationSpecification))
            .constructor(CapacityReservationSpecificationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification")
                    .unmarshallLocationName("capacityReservationSpecification").build()).build();

    private static final SdkField<HibernationOptions> HIBERNATION_OPTIONS_FIELD = SdkField
            .<HibernationOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(Instance::hibernationOptions))
            .setter(setter(Builder::hibernationOptions))
            .constructor(HibernationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions")
                    .unmarshallLocationName("hibernationOptions").build()).build();

    private static final SdkField<List<LicenseConfiguration>> LICENSES_FIELD = SdkField
            .<List<LicenseConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(Instance::licenses))
            .setter(setter(Builder::licenses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSet")
                    .unmarshallLocationName("licenseSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LicenseConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<InstanceMetadataOptionsResponse> METADATA_OPTIONS_FIELD = SdkField
            .<InstanceMetadataOptionsResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(Instance::metadataOptions))
            .setter(setter(Builder::metadataOptions))
            .constructor(InstanceMetadataOptionsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions")
                    .unmarshallLocationName("metadataOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMI_LAUNCH_INDEX_FIELD,
            IMAGE_ID_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD, LAUNCH_TIME_FIELD,
            MONITORING_FIELD, PLACEMENT_FIELD, PLATFORM_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD,
            PRODUCT_CODES_FIELD, PUBLIC_DNS_NAME_FIELD, PUBLIC_IP_ADDRESS_FIELD, RAMDISK_ID_FIELD, STATE_FIELD,
            STATE_TRANSITION_REASON_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD, ARCHITECTURE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD,
            CLIENT_TOKEN_FIELD, EBS_OPTIMIZED_FIELD, ENA_SUPPORT_FIELD, HYPERVISOR_FIELD, IAM_INSTANCE_PROFILE_FIELD,
            INSTANCE_LIFECYCLE_FIELD, ELASTIC_GPU_ASSOCIATIONS_FIELD, ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATIONS_FIELD,
            NETWORK_INTERFACES_FIELD, OUTPOST_ARN_FIELD, ROOT_DEVICE_NAME_FIELD, ROOT_DEVICE_TYPE_FIELD, SECURITY_GROUPS_FIELD,
            SOURCE_DEST_CHECK_FIELD, SPOT_INSTANCE_REQUEST_ID_FIELD, SRIOV_NET_SUPPORT_FIELD, STATE_REASON_FIELD, TAGS_FIELD,
            VIRTUALIZATION_TYPE_FIELD, CPU_OPTIONS_FIELD, CAPACITY_RESERVATION_ID_FIELD,
            CAPACITY_RESERVATION_SPECIFICATION_FIELD, HIBERNATION_OPTIONS_FIELD, LICENSES_FIELD, METADATA_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer amiLaunchIndex;

    private final String imageId;

    private final String instanceId;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final Instant launchTime;

    private final Monitoring monitoring;

    private final Placement placement;

    private final String platform;

    private final String privateDnsName;

    private final String privateIpAddress;

    private final List<ProductCode> productCodes;

    private final String publicDnsName;

    private final String publicIpAddress;

    private final String ramdiskId;

    private final InstanceState state;

    private final String stateTransitionReason;

    private final String subnetId;

    private final String vpcId;

    private final String architecture;

    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;

    private final String clientToken;

    private final Boolean ebsOptimized;

    private final Boolean enaSupport;

    private final String hypervisor;

    private final IamInstanceProfile iamInstanceProfile;

    private final String instanceLifecycle;

    private final List<ElasticGpuAssociation> elasticGpuAssociations;

    private final List<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations;

    private final List<InstanceNetworkInterface> networkInterfaces;

    private final String outpostArn;

    private final String rootDeviceName;

    private final String rootDeviceType;

    private final List<GroupIdentifier> securityGroups;

    private final Boolean sourceDestCheck;

    private final String spotInstanceRequestId;

    private final String sriovNetSupport;

    private final StateReason stateReason;

    private final List<Tag> tags;

    private final String virtualizationType;

    private final CpuOptions cpuOptions;

    private final String capacityReservationId;

    private final CapacityReservationSpecificationResponse capacityReservationSpecification;

    private final HibernationOptions hibernationOptions;

    private final List<LicenseConfiguration> licenses;

    private final InstanceMetadataOptionsResponse metadataOptions;

    private Instance(BuilderImpl builder) {
        this.amiLaunchIndex = builder.amiLaunchIndex;
        this.imageId = builder.imageId;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.launchTime = builder.launchTime;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.platform = builder.platform;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.productCodes = builder.productCodes;
        this.publicDnsName = builder.publicDnsName;
        this.publicIpAddress = builder.publicIpAddress;
        this.ramdiskId = builder.ramdiskId;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.architecture = builder.architecture;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.clientToken = builder.clientToken;
        this.ebsOptimized = builder.ebsOptimized;
        this.enaSupport = builder.enaSupport;
        this.hypervisor = builder.hypervisor;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceLifecycle = builder.instanceLifecycle;
        this.elasticGpuAssociations = builder.elasticGpuAssociations;
        this.elasticInferenceAcceleratorAssociations = builder.elasticInferenceAcceleratorAssociations;
        this.networkInterfaces = builder.networkInterfaces;
        this.outpostArn = builder.outpostArn;
        this.rootDeviceName = builder.rootDeviceName;
        this.rootDeviceType = builder.rootDeviceType;
        this.securityGroups = builder.securityGroups;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.virtualizationType = builder.virtualizationType;
        this.cpuOptions = builder.cpuOptions;
        this.capacityReservationId = builder.capacityReservationId;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.hibernationOptions = builder.hibernationOptions;
        this.licenses = builder.licenses;
        this.metadataOptions = builder.metadataOptions;
    }

    /**
     * <p>
     * The AMI launch index, which can be used to find this instance in the launch group.
     * </p>
     * 
     * @return The AMI launch index, which can be used to find this instance in the launch group.
     */
    public Integer amiLaunchIndex() {
        return amiLaunchIndex;
    }

    /**
     * <p>
     * The ID of the AMI used to launch the instance.
     * </p>
     * 
     * @return The ID of the AMI used to launch the instance.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The kernel associated with this instance, if applicable.
     * </p>
     * 
     * @return The kernel associated with this instance, if applicable.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair, if this instance was launched with an associated key pair.
     * </p>
     * 
     * @return The name of the key pair, if this instance was launched with an associated key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The time the instance was launched.
     * </p>
     * 
     * @return The time the instance was launched.
     */
    public Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * The monitoring for the instance.
     * </p>
     * 
     * @return The monitoring for the instance.
     */
    public Monitoring monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * The location where the instance launched, if applicable.
     * </p>
     * 
     * @return The location where the instance launched, if applicable.
     */
    public Placement placement() {
        return placement;
    }

    /**
     * <p>
     * The value is <code>Windows</code> for Windows instances; otherwise blank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The value is <code>Windows</code> for Windows instances; otherwise blank.
     * @see PlatformValues
     */
    public PlatformValues platform() {
        return PlatformValues.fromValue(platform);
    }

    /**
     * <p>
     * The value is <code>Windows</code> for Windows instances; otherwise blank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The value is <code>Windows</code> for Windows instances; otherwise blank.
     * @see PlatformValues
     */
    public String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside the
     * Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state.
     * </p>
     * <p>
     * [EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS
     * resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC, your
     * custom domain name servers must resolve the hostname as appropriate.
     * </p>
     * 
     * @return (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used
     *         inside the Amazon EC2 network. This name is not available until the instance enters the
     *         <code>running</code> state. </p>
     *         <p>
     *         [EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled
     *         DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your
     *         VPC, your custom domain name servers must resolve the hostname as appropriate.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The private IPv4 address assigned to the instance.
     * </p>
     * 
     * @return The private IPv4 address assigned to the instance.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * Returns true if the ProductCodes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProductCodes() {
        return productCodes != null && !(productCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product codes attached to this instance, if applicable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The product codes attached to this instance, if applicable.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * (IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance enters
     * the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS hostnames for your
     * VPC.
     * </p>
     * 
     * @return (IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance
     *         enters the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS
     *         hostnames for your VPC.
     */
    public String publicDnsName() {
        return publicDnsName;
    }

    /**
     * <p>
     * The public IPv4 address assigned to the instance, if applicable.
     * </p>
     * 
     * @return The public IPv4 address assigned to the instance, if applicable.
     */
    public String publicIpAddress() {
        return publicIpAddress;
    }

    /**
     * <p>
     * The RAM disk associated with this instance, if applicable.
     * </p>
     * 
     * @return The RAM disk associated with this instance, if applicable.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * 
     * @return The current state of the instance.
     */
    public InstanceState state() {
        return state;
    }

    /**
     * <p>
     * The reason for the most recent state transition. This might be an empty string.
     * </p>
     * 
     * @return The reason for the most recent state transition. This might be an empty string.
     */
    public String stateTransitionReason() {
        return stateTransitionReason;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the subnet in which the instance is running.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the subnet in which the instance is running.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the VPC in which the instance is running.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the VPC in which the instance is running.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(architecture);
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public String architectureAsString() {
        return architecture;
    }

    /**
     * Returns true if the BlockDeviceMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any block device mapping entries for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlockDeviceMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any block device mapping entries for the instance.
     */
    public List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The idempotency token you provided when you launched the instance, if applicable.
     * </p>
     * 
     * @return The idempotency token you provided when you launched the instance, if applicable.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput
     * to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
     *         optimization isn't available with all instance types. Additional usage charges apply when using an EBS
     *         Optimized instance.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with ENA is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with ENA is enabled.
     */
    public Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * The hypervisor type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link HypervisorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hypervisorAsString}.
     * </p>
     * 
     * @return The hypervisor type of the instance.
     * @see HypervisorType
     */
    public HypervisorType hypervisor() {
        return HypervisorType.fromValue(hypervisor);
    }

    /**
     * <p>
     * The hypervisor type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link HypervisorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hypervisorAsString}.
     * </p>
     * 
     * @return The hypervisor type of the instance.
     * @see HypervisorType
     */
    public String hypervisorAsString() {
        return hypervisor;
    }

    /**
     * <p>
     * The IAM instance profile associated with the instance, if applicable.
     * </p>
     * 
     * @return The IAM instance profile associated with the instance, if applicable.
     */
    public IamInstanceProfile iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * Indicates whether this is a Spot Instance or a Scheduled Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceLifecycle}
     * will return {@link InstanceLifecycleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceLifecycleAsString}.
     * </p>
     * 
     * @return Indicates whether this is a Spot Instance or a Scheduled Instance.
     * @see InstanceLifecycleType
     */
    public InstanceLifecycleType instanceLifecycle() {
        return InstanceLifecycleType.fromValue(instanceLifecycle);
    }

    /**
     * <p>
     * Indicates whether this is a Spot Instance or a Scheduled Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceLifecycle}
     * will return {@link InstanceLifecycleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceLifecycleAsString}.
     * </p>
     * 
     * @return Indicates whether this is a Spot Instance or a Scheduled Instance.
     * @see InstanceLifecycleType
     */
    public String instanceLifecycleAsString() {
        return instanceLifecycle;
    }

    /**
     * Returns true if the ElasticGpuAssociations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasElasticGpuAssociations() {
        return elasticGpuAssociations != null && !(elasticGpuAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Elastic GPU associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElasticGpuAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Elastic GPU associated with the instance.
     */
    public List<ElasticGpuAssociation> elasticGpuAssociations() {
        return elasticGpuAssociations;
    }

    /**
     * Returns true if the ElasticInferenceAcceleratorAssociations property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasElasticInferenceAcceleratorAssociations() {
        return elasticInferenceAcceleratorAssociations != null
                && !(elasticInferenceAcceleratorAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The elastic inference accelerator associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElasticInferenceAcceleratorAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The elastic inference accelerator associated with the instance.
     */
    public List<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations() {
        return elasticInferenceAcceleratorAssociations;
    }

    /**
     * Returns true if the NetworkInterfaces property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [EC2-VPC] The network interfaces for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkInterfaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [EC2-VPC] The network interfaces for the instance.
     */
    public List<InstanceNetworkInterface> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost.
     */
    public String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * 
     * @return The device name of the root device volume (for example, <code>/dev/sda1</code>).
     */
    public String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * @see DeviceType
     */
    public DeviceType rootDeviceType() {
        return DeviceType.fromValue(rootDeviceType);
    }

    /**
     * <p>
     * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * @see DeviceType
     */
    public String rootDeviceTypeAsString() {
        return rootDeviceType;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security groups for the instance.
     */
    public List<GroupIdentifier> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
     * source/destination checking is enabled on the instance. A value of <code>true</code> means that checking is
     * enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the
     * instance to perform NAT. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * 
     * @return Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
     *         source/destination checking is enabled on the instance. A value of <code>true</code> means that checking
     *         is enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code>
     *         for the instance to perform NAT. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in
     *         the <i>Amazon Virtual Private Cloud User Guide</i>.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * If the request is a Spot Instance request, the ID of the request.
     * </p>
     * 
     * @return If the request is a Spot Instance request, the ID of the request.
     */
    public String spotInstanceRequestId() {
        return spotInstanceRequestId;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The reason for the most recent state transition.
     * </p>
     * 
     * @return The reason for the most recent state transition.
     */
    public StateReason stateReason() {
        return stateReason;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the instance.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The virtualization type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeAsString}.
     * </p>
     * 
     * @return The virtualization type of the instance.
     * @see VirtualizationType
     */
    public VirtualizationType virtualizationType() {
        return VirtualizationType.fromValue(virtualizationType);
    }

    /**
     * <p>
     * The virtualization type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeAsString}.
     * </p>
     * 
     * @return The virtualization type of the instance.
     * @see VirtualizationType
     */
    public String virtualizationTypeAsString() {
        return virtualizationType;
    }

    /**
     * <p>
     * The CPU options for the instance.
     * </p>
     * 
     * @return The CPU options for the instance.
     */
    public CpuOptions cpuOptions() {
        return cpuOptions;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Capacity Reservation.
     */
    public String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * Information about the Capacity Reservation targeting option.
     * </p>
     * 
     * @return Information about the Capacity Reservation targeting option.
     */
    public CapacityReservationSpecificationResponse capacityReservationSpecification() {
        return capacityReservationSpecification;
    }

    /**
     * <p>
     * Indicates whether the instance is enabled for hibernation.
     * </p>
     * 
     * @return Indicates whether the instance is enabled for hibernation.
     */
    public HibernationOptions hibernationOptions() {
        return hibernationOptions;
    }

    /**
     * Returns true if the Licenses property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLicenses() {
        return licenses != null && !(licenses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The license configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The license configurations.
     */
    public List<LicenseConfiguration> licenses() {
        return licenses;
    }

    /**
     * <p>
     * The metadata options for the instance.
     * </p>
     * 
     * @return The metadata options for the instance.
     */
    public InstanceMetadataOptionsResponse metadataOptions() {
        return metadataOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amiLaunchIndex());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(instanceLifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(elasticInferenceAcceleratorAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(virtualizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(licenses());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(amiLaunchIndex(), other.amiLaunchIndex()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(kernelId(), other.kernelId()) && Objects.equals(keyName(), other.keyName())
                && Objects.equals(launchTime(), other.launchTime()) && Objects.equals(monitoring(), other.monitoring())
                && Objects.equals(placement(), other.placement()) && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(productCodes(), other.productCodes()) && Objects.equals(publicDnsName(), other.publicDnsName())
                && Objects.equals(publicIpAddress(), other.publicIpAddress()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(state(), other.state())
                && Objects.equals(stateTransitionReason(), other.stateTransitionReason())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(architectureAsString(), other.architectureAsString())
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(enaSupport(), other.enaSupport())
                && Objects.equals(hypervisorAsString(), other.hypervisorAsString())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(instanceLifecycleAsString(), other.instanceLifecycleAsString())
                && Objects.equals(elasticGpuAssociations(), other.elasticGpuAssociations())
                && Objects.equals(elasticInferenceAcceleratorAssociations(), other.elasticInferenceAcceleratorAssociations())
                && Objects.equals(networkInterfaces(), other.networkInterfaces())
                && Objects.equals(outpostArn(), other.outpostArn()) && Objects.equals(rootDeviceName(), other.rootDeviceName())
                && Objects.equals(rootDeviceTypeAsString(), other.rootDeviceTypeAsString())
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(spotInstanceRequestId(), other.spotInstanceRequestId())
                && Objects.equals(sriovNetSupport(), other.sriovNetSupport())
                && Objects.equals(stateReason(), other.stateReason()) && Objects.equals(tags(), other.tags())
                && Objects.equals(virtualizationTypeAsString(), other.virtualizationTypeAsString())
                && Objects.equals(cpuOptions(), other.cpuOptions())
                && Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(capacityReservationSpecification(), other.capacityReservationSpecification())
                && Objects.equals(hibernationOptions(), other.hibernationOptions())
                && Objects.equals(licenses(), other.licenses()) && Objects.equals(metadataOptions(), other.metadataOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Instance").add("AmiLaunchIndex", amiLaunchIndex()).add("ImageId", imageId())
                .add("InstanceId", instanceId()).add("InstanceType", instanceTypeAsString()).add("KernelId", kernelId())
                .add("KeyName", keyName()).add("LaunchTime", launchTime()).add("Monitoring", monitoring())
                .add("Placement", placement()).add("Platform", platformAsString()).add("PrivateDnsName", privateDnsName())
                .add("PrivateIpAddress", privateIpAddress()).add("ProductCodes", productCodes())
                .add("PublicDnsName", publicDnsName()).add("PublicIpAddress", publicIpAddress()).add("RamdiskId", ramdiskId())
                .add("State", state()).add("StateTransitionReason", stateTransitionReason()).add("SubnetId", subnetId())
                .add("VpcId", vpcId()).add("Architecture", architectureAsString())
                .add("BlockDeviceMappings", blockDeviceMappings()).add("ClientToken", clientToken())
                .add("EbsOptimized", ebsOptimized()).add("EnaSupport", enaSupport()).add("Hypervisor", hypervisorAsString())
                .add("IamInstanceProfile", iamInstanceProfile()).add("InstanceLifecycle", instanceLifecycleAsString())
                .add("ElasticGpuAssociations", elasticGpuAssociations())
                .add("ElasticInferenceAcceleratorAssociations", elasticInferenceAcceleratorAssociations())
                .add("NetworkInterfaces", networkInterfaces()).add("OutpostArn", outpostArn())
                .add("RootDeviceName", rootDeviceName()).add("RootDeviceType", rootDeviceTypeAsString())
                .add("SecurityGroups", securityGroups()).add("SourceDestCheck", sourceDestCheck())
                .add("SpotInstanceRequestId", spotInstanceRequestId()).add("SriovNetSupport", sriovNetSupport())
                .add("StateReason", stateReason()).add("Tags", tags()).add("VirtualizationType", virtualizationTypeAsString())
                .add("CpuOptions", cpuOptions()).add("CapacityReservationId", capacityReservationId())
                .add("CapacityReservationSpecification", capacityReservationSpecification())
                .add("HibernationOptions", hibernationOptions()).add("Licenses", licenses())
                .add("MetadataOptions", metadataOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmiLaunchIndex":
            return Optional.ofNullable(clazz.cast(amiLaunchIndex()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "LaunchTime":
            return Optional.ofNullable(clazz.cast(launchTime()));
        case "Monitoring":
            return Optional.ofNullable(clazz.cast(monitoring()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "PublicDnsName":
            return Optional.ofNullable(clazz.cast(publicDnsName()));
        case "PublicIpAddress":
            return Optional.ofNullable(clazz.cast(publicIpAddress()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "StateTransitionReason":
            return Optional.ofNullable(clazz.cast(stateTransitionReason()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "EnaSupport":
            return Optional.ofNullable(clazz.cast(enaSupport()));
        case "Hypervisor":
            return Optional.ofNullable(clazz.cast(hypervisorAsString()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "InstanceLifecycle":
            return Optional.ofNullable(clazz.cast(instanceLifecycleAsString()));
        case "ElasticGpuAssociations":
            return Optional.ofNullable(clazz.cast(elasticGpuAssociations()));
        case "ElasticInferenceAcceleratorAssociations":
            return Optional.ofNullable(clazz.cast(elasticInferenceAcceleratorAssociations()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "RootDeviceName":
            return Optional.ofNullable(clazz.cast(rootDeviceName()));
        case "RootDeviceType":
            return Optional.ofNullable(clazz.cast(rootDeviceTypeAsString()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SourceDestCheck":
            return Optional.ofNullable(clazz.cast(sourceDestCheck()));
        case "SpotInstanceRequestId":
            return Optional.ofNullable(clazz.cast(spotInstanceRequestId()));
        case "SriovNetSupport":
            return Optional.ofNullable(clazz.cast(sriovNetSupport()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VirtualizationType":
            return Optional.ofNullable(clazz.cast(virtualizationTypeAsString()));
        case "CpuOptions":
            return Optional.ofNullable(clazz.cast(cpuOptions()));
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "CapacityReservationSpecification":
            return Optional.ofNullable(clazz.cast(capacityReservationSpecification()));
        case "HibernationOptions":
            return Optional.ofNullable(clazz.cast(hibernationOptions()));
        case "Licenses":
            return Optional.ofNullable(clazz.cast(licenses()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The AMI launch index, which can be used to find this instance in the launch group.
         * </p>
         * 
         * @param amiLaunchIndex
         *        The AMI launch index, which can be used to find this instance in the launch group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiLaunchIndex(Integer amiLaunchIndex);

        /**
         * <p>
         * The ID of the AMI used to launch the instance.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI used to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The kernel associated with this instance, if applicable.
         * </p>
         * 
         * @param kernelId
         *        The kernel associated with this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair, if this instance was launched with an associated key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair, if this instance was launched with an associated key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The time the instance was launched.
         * </p>
         * 
         * @param launchTime
         *        The time the instance was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * 
         * @param monitoring
         *        The monitoring for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(Monitoring monitoring);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link Monitoring.Builder} avoiding the need to create
         * one manually via {@link Monitoring#builder()}.
         *
         * When the {@link Consumer} completes, {@link Monitoring.Builder#build()} is called immediately and its result
         * is passed to {@link #monitoring(Monitoring)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link Monitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(Monitoring)
         */
        default Builder monitoring(Consumer<Monitoring.Builder> monitoring) {
            return monitoring(Monitoring.builder().applyMutation(monitoring).build());
        }

        /**
         * <p>
         * The location where the instance launched, if applicable.
         * </p>
         * 
         * @param placement
         *        The location where the instance launched, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(Placement placement);

        /**
         * <p>
         * The location where the instance launched, if applicable.
         * </p>
         * This is a convenience that creates an instance of the {@link Placement.Builder} avoiding the need to create
         * one manually via {@link Placement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Placement.Builder#build()} is called immediately and its result
         * is passed to {@link #placement(Placement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link Placement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(Placement)
         */
        default Builder placement(Consumer<Placement.Builder> placement) {
            return placement(Placement.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * The value is <code>Windows</code> for Windows instances; otherwise blank.
         * </p>
         * 
         * @param platform
         *        The value is <code>Windows</code> for Windows instances; otherwise blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * The value is <code>Windows</code> for Windows instances; otherwise blank.
         * </p>
         * 
         * @param platform
         *        The value is <code>Windows</code> for Windows instances; otherwise blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);

        /**
         * <p>
         * (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside
         * the Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state.
         * </p>
         * <p>
         * [EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS
         * resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC,
         * your custom domain name servers must resolve the hostname as appropriate.
         * </p>
         * 
         * @param privateDnsName
         *        (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used
         *        inside the Amazon EC2 network. This name is not available until the instance enters the
         *        <code>running</code> state. </p>
         *        <p>
         *        [EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've
         *        enabled DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS
         *        server in your VPC, your custom domain name servers must resolve the hostname as appropriate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The private IPv4 address assigned to the instance.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IPv4 address assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The product codes attached to this instance, if applicable.
         * </p>
         * 
         * @param productCodes
         *        The product codes attached to this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product codes attached to this instance, if applicable.
         * </p>
         * 
         * @param productCodes
         *        The product codes attached to this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The product codes attached to this instance, if applicable.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductCode>.Builder} avoiding the need to
         * create one manually via {@link List<ProductCode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductCode>.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on {@link List<ProductCode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(List<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * (IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance
         * enters the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS
         * hostnames for your VPC.
         * </p>
         * 
         * @param publicDnsName
         *        (IPv4 only) The public DNS name assigned to the instance. This name is not available until the
         *        instance enters the <code>running</code> state. For EC2-VPC, this name is only available if you've
         *        enabled DNS hostnames for your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDnsName(String publicDnsName);

        /**
         * <p>
         * The public IPv4 address assigned to the instance, if applicable.
         * </p>
         * 
         * @param publicIpAddress
         *        The public IPv4 address assigned to the instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpAddress(String publicIpAddress);

        /**
         * <p>
         * The RAM disk associated with this instance, if applicable.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk associated with this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param state
         *        The current state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(InstanceState state);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceState.Builder} avoiding the need to
         * create one manually via {@link InstanceState#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(InstanceState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(InstanceState)
         */
        default Builder state(Consumer<InstanceState.Builder> state) {
            return state(InstanceState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The reason for the most recent state transition. This might be an empty string.
         * </p>
         * 
         * @param stateTransitionReason
         *        The reason for the most recent state transition. This might be an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitionReason(String stateTransitionReason);

        /**
         * <p>
         * [EC2-VPC] The ID of the subnet in which the instance is running.
         * </p>
         * 
         * @param subnetId
         *        [EC2-VPC] The ID of the subnet in which the instance is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * [EC2-VPC] The ID of the VPC in which the instance is running.
         * </p>
         * 
         * @param vpcId
         *        [EC2-VPC] The ID of the VPC in which the instance is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(ArchitectureValues architecture);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceBlockDeviceMapping>.Builder}
         * avoiding the need to create one manually via {@link List<InstanceBlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceBlockDeviceMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #blockDeviceMappings(List<InstanceBlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<InstanceBlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<InstanceBlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The idempotency token you provided when you launched the instance, if applicable.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token you provided when you launched the instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         * throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
         * optimization isn't available with all instance types. Additional usage charges apply when using an EBS
         * Optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
         *        optimization isn't available with all instance types. Additional usage charges apply when using an EBS
         *        Optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * Specifies whether enhanced networking with ENA is enabled.
         * </p>
         * 
         * @param enaSupport
         *        Specifies whether enhanced networking with ENA is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * The hypervisor type of the instance.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the instance.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The hypervisor type of the instance.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the instance.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(HypervisorType hypervisor);

        /**
         * <p>
         * The IAM instance profile associated with the instance, if applicable.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile associated with the instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile);

        /**
         * <p>
         * The IAM instance profile associated with the instance, if applicable.
         * </p>
         * This is a convenience that creates an instance of the {@link IamInstanceProfile.Builder} avoiding the need to
         * create one manually via {@link IamInstanceProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link IamInstanceProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #iamInstanceProfile(IamInstanceProfile)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link IamInstanceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(IamInstanceProfile)
         */
        default Builder iamInstanceProfile(Consumer<IamInstanceProfile.Builder> iamInstanceProfile) {
            return iamInstanceProfile(IamInstanceProfile.builder().applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * Indicates whether this is a Spot Instance or a Scheduled Instance.
         * </p>
         * 
         * @param instanceLifecycle
         *        Indicates whether this is a Spot Instance or a Scheduled Instance.
         * @see InstanceLifecycleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycleType
         */
        Builder instanceLifecycle(String instanceLifecycle);

        /**
         * <p>
         * Indicates whether this is a Spot Instance or a Scheduled Instance.
         * </p>
         * 
         * @param instanceLifecycle
         *        Indicates whether this is a Spot Instance or a Scheduled Instance.
         * @see InstanceLifecycleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycleType
         */
        Builder instanceLifecycle(InstanceLifecycleType instanceLifecycle);

        /**
         * <p>
         * The Elastic GPU associated with the instance.
         * </p>
         * 
         * @param elasticGpuAssociations
         *        The Elastic GPU associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociations(Collection<ElasticGpuAssociation> elasticGpuAssociations);

        /**
         * <p>
         * The Elastic GPU associated with the instance.
         * </p>
         * 
         * @param elasticGpuAssociations
         *        The Elastic GPU associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociations(ElasticGpuAssociation... elasticGpuAssociations);

        /**
         * <p>
         * The Elastic GPU associated with the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ElasticGpuAssociation>.Builder} avoiding
         * the need to create one manually via {@link List<ElasticGpuAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticGpuAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #elasticGpuAssociations(List<ElasticGpuAssociation>)}.
         * 
         * @param elasticGpuAssociations
         *        a consumer that will call methods on {@link List<ElasticGpuAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticGpuAssociations(List<ElasticGpuAssociation>)
         */
        Builder elasticGpuAssociations(Consumer<ElasticGpuAssociation.Builder>... elasticGpuAssociations);

        /**
         * <p>
         * The elastic inference accelerator associated with the instance.
         * </p>
         * 
         * @param elasticInferenceAcceleratorAssociations
         *        The elastic inference accelerator associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAcceleratorAssociations(
                Collection<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations);

        /**
         * <p>
         * The elastic inference accelerator associated with the instance.
         * </p>
         * 
         * @param elasticInferenceAcceleratorAssociations
         *        The elastic inference accelerator associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAcceleratorAssociations(
                ElasticInferenceAcceleratorAssociation... elasticInferenceAcceleratorAssociations);

        /**
         * <p>
         * The elastic inference accelerator associated with the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ElasticInferenceAcceleratorAssociation>.Builder} avoiding the need to create one manually via {@link List
         * <ElasticInferenceAcceleratorAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticInferenceAcceleratorAssociation>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #elasticInferenceAcceleratorAssociations(List<ElasticInferenceAcceleratorAssociation>)}.
         * 
         * @param elasticInferenceAcceleratorAssociations
         *        a consumer that will call methods on {@link List<ElasticInferenceAcceleratorAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticInferenceAcceleratorAssociations(List<ElasticInferenceAcceleratorAssociation>)
         */
        Builder elasticInferenceAcceleratorAssociations(
                Consumer<ElasticInferenceAcceleratorAssociation.Builder>... elasticInferenceAcceleratorAssociations);

        /**
         * <p>
         * [EC2-VPC] The network interfaces for the instance.
         * </p>
         * 
         * @param networkInterfaces
         *        [EC2-VPC] The network interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces);

        /**
         * <p>
         * [EC2-VPC] The network interfaces for the instance.
         * </p>
         * 
         * @param networkInterfaces
         *        [EC2-VPC] The network interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(InstanceNetworkInterface... networkInterfaces);

        /**
         * <p>
         * [EC2-VPC] The network interfaces for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceNetworkInterface>.Builder} avoiding
         * the need to create one manually via {@link List<InstanceNetworkInterface>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceNetworkInterface>.Builder#build()} is called
         * immediately and its result is passed to {@link #networkInterfaces(List<InstanceNetworkInterface>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on {@link List<InstanceNetworkInterface>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(List<InstanceNetworkInterface>)
         */
        Builder networkInterfaces(Consumer<InstanceNetworkInterface.Builder>... networkInterfaces);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(String rootDeviceType);

        /**
         * <p>
         * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(DeviceType rootDeviceType);

        /**
         * <p>
         * The security groups for the instance.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<GroupIdentifier> securityGroups);

        /**
         * <p>
         * The security groups for the instance.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(GroupIdentifier... securityGroups);

        /**
         * <p>
         * The security groups for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupIdentifier>.Builder} avoiding the need
         * to create one manually via {@link List<GroupIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupIdentifier>.Builder#build()} is called immediately and
         * its result is passed to {@link #securityGroups(List<GroupIdentifier>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on {@link List<GroupIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(List<GroupIdentifier>)
         */
        Builder securityGroups(Consumer<GroupIdentifier.Builder>... securityGroups);

        /**
         * <p>
         * Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
         * source/destination checking is enabled on the instance. A value of <code>true</code> means that checking is
         * enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the
         * instance to perform NAT. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the
         * <i>Amazon Virtual Private Cloud User Guide</i>.
         * </p>
         * 
         * @param sourceDestCheck
         *        Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
         *        source/destination checking is enabled on the instance. A value of <code>true</code> means that
         *        checking is enabled, and <code>false</code> means that checking is disabled. The value must be
         *        <code>false</code> for the instance to perform NAT. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a>
         *        in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * If the request is a Spot Instance request, the ID of the request.
         * </p>
         * 
         * @param spotInstanceRequestId
         *        If the request is a Spot Instance request, the ID of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestId(String spotInstanceRequestId);

        /**
         * <p>
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * The reason for the most recent state transition.
         * </p>
         * 
         * @param stateReason
         *        The reason for the most recent state transition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(StateReason stateReason);

        /**
         * <p>
         * The reason for the most recent state transition.
         * </p>
         * This is a convenience that creates an instance of the {@link StateReason.Builder} avoiding the need to create
         * one manually via {@link StateReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link StateReason.Builder#build()} is called immediately and its result
         * is passed to {@link #stateReason(StateReason)}.
         * 
         * @param stateReason
         *        a consumer that will call methods on {@link StateReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateReason(StateReason)
         */
        default Builder stateReason(Consumer<StateReason.Builder> stateReason) {
            return stateReason(StateReason.builder().applyMutation(stateReason).build());
        }

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The virtualization type of the instance.
         * </p>
         * 
         * @param virtualizationType
         *        The virtualization type of the instance.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * The virtualization type of the instance.
         * </p>
         * 
         * @param virtualizationType
         *        The virtualization type of the instance.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(VirtualizationType virtualizationType);

        /**
         * <p>
         * The CPU options for the instance.
         * </p>
         * 
         * @param cpuOptions
         *        The CPU options for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuOptions(CpuOptions cpuOptions);

        /**
         * <p>
         * The CPU options for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link CpuOptions.Builder} avoiding the need to create
         * one manually via {@link CpuOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CpuOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #cpuOptions(CpuOptions)}.
         * 
         * @param cpuOptions
         *        a consumer that will call methods on {@link CpuOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpuOptions(CpuOptions)
         */
        default Builder cpuOptions(Consumer<CpuOptions.Builder> cpuOptions) {
            return cpuOptions(CpuOptions.builder().applyMutation(cpuOptions).build());
        }

        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * Information about the Capacity Reservation targeting option.
         * </p>
         * 
         * @param capacityReservationSpecification
         *        Information about the Capacity Reservation targeting option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationSpecification(CapacityReservationSpecificationResponse capacityReservationSpecification);

        /**
         * <p>
         * Information about the Capacity Reservation targeting option.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link CapacityReservationSpecificationResponse.Builder} avoiding the need to create one manually via
         * {@link CapacityReservationSpecificationResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link CapacityReservationSpecificationResponse.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #capacityReservationSpecification(CapacityReservationSpecificationResponse)}.
         * 
         * @param capacityReservationSpecification
         *        a consumer that will call methods on {@link CapacityReservationSpecificationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationSpecification(CapacityReservationSpecificationResponse)
         */
        default Builder capacityReservationSpecification(
                Consumer<CapacityReservationSpecificationResponse.Builder> capacityReservationSpecification) {
            return capacityReservationSpecification(CapacityReservationSpecificationResponse.builder()
                    .applyMutation(capacityReservationSpecification).build());
        }

        /**
         * <p>
         * Indicates whether the instance is enabled for hibernation.
         * </p>
         * 
         * @param hibernationOptions
         *        Indicates whether the instance is enabled for hibernation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hibernationOptions(HibernationOptions hibernationOptions);

        /**
         * <p>
         * Indicates whether the instance is enabled for hibernation.
         * </p>
         * This is a convenience that creates an instance of the {@link HibernationOptions.Builder} avoiding the need to
         * create one manually via {@link HibernationOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link HibernationOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #hibernationOptions(HibernationOptions)}.
         * 
         * @param hibernationOptions
         *        a consumer that will call methods on {@link HibernationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hibernationOptions(HibernationOptions)
         */
        default Builder hibernationOptions(Consumer<HibernationOptions.Builder> hibernationOptions) {
            return hibernationOptions(HibernationOptions.builder().applyMutation(hibernationOptions).build());
        }

        /**
         * <p>
         * The license configurations.
         * </p>
         * 
         * @param licenses
         *        The license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenses(Collection<LicenseConfiguration> licenses);

        /**
         * <p>
         * The license configurations.
         * </p>
         * 
         * @param licenses
         *        The license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenses(LicenseConfiguration... licenses);

        /**
         * <p>
         * The license configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LicenseConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<LicenseConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LicenseConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #licenses(List<LicenseConfiguration>)}.
         * 
         * @param licenses
         *        a consumer that will call methods on {@link List<LicenseConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenses(List<LicenseConfiguration>)
         */
        Builder licenses(Consumer<LicenseConfiguration.Builder>... licenses);

        /**
         * <p>
         * The metadata options for the instance.
         * </p>
         * 
         * @param metadataOptions
         *        The metadata options for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(InstanceMetadataOptionsResponse metadataOptions);

        /**
         * <p>
         * The metadata options for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceMetadataOptionsResponse.Builder}
         * avoiding the need to create one manually via {@link InstanceMetadataOptionsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceMetadataOptionsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #metadataOptions(InstanceMetadataOptionsResponse)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link InstanceMetadataOptionsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(InstanceMetadataOptionsResponse)
         */
        default Builder metadataOptions(Consumer<InstanceMetadataOptionsResponse.Builder> metadataOptions) {
            return metadataOptions(InstanceMetadataOptionsResponse.builder().applyMutation(metadataOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer amiLaunchIndex;

        private String imageId;

        private String instanceId;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private Instant launchTime;

        private Monitoring monitoring;

        private Placement placement;

        private String platform;

        private String privateDnsName;

        private String privateIpAddress;

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private String publicDnsName;

        private String publicIpAddress;

        private String ramdiskId;

        private InstanceState state;

        private String stateTransitionReason;

        private String subnetId;

        private String vpcId;

        private String architecture;

        private List<InstanceBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private Boolean ebsOptimized;

        private Boolean enaSupport;

        private String hypervisor;

        private IamInstanceProfile iamInstanceProfile;

        private String instanceLifecycle;

        private List<ElasticGpuAssociation> elasticGpuAssociations = DefaultSdkAutoConstructList.getInstance();

        private List<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private List<InstanceNetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private String outpostArn;

        private String rootDeviceName;

        private String rootDeviceType;

        private List<GroupIdentifier> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private Boolean sourceDestCheck;

        private String spotInstanceRequestId;

        private String sriovNetSupport;

        private StateReason stateReason;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String virtualizationType;

        private CpuOptions cpuOptions;

        private String capacityReservationId;

        private CapacityReservationSpecificationResponse capacityReservationSpecification;

        private HibernationOptions hibernationOptions;

        private List<LicenseConfiguration> licenses = DefaultSdkAutoConstructList.getInstance();

        private InstanceMetadataOptionsResponse metadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            amiLaunchIndex(model.amiLaunchIndex);
            imageId(model.imageId);
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            keyName(model.keyName);
            launchTime(model.launchTime);
            monitoring(model.monitoring);
            placement(model.placement);
            platform(model.platform);
            privateDnsName(model.privateDnsName);
            privateIpAddress(model.privateIpAddress);
            productCodes(model.productCodes);
            publicDnsName(model.publicDnsName);
            publicIpAddress(model.publicIpAddress);
            ramdiskId(model.ramdiskId);
            state(model.state);
            stateTransitionReason(model.stateTransitionReason);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
            architecture(model.architecture);
            blockDeviceMappings(model.blockDeviceMappings);
            clientToken(model.clientToken);
            ebsOptimized(model.ebsOptimized);
            enaSupport(model.enaSupport);
            hypervisor(model.hypervisor);
            iamInstanceProfile(model.iamInstanceProfile);
            instanceLifecycle(model.instanceLifecycle);
            elasticGpuAssociations(model.elasticGpuAssociations);
            elasticInferenceAcceleratorAssociations(model.elasticInferenceAcceleratorAssociations);
            networkInterfaces(model.networkInterfaces);
            outpostArn(model.outpostArn);
            rootDeviceName(model.rootDeviceName);
            rootDeviceType(model.rootDeviceType);
            securityGroups(model.securityGroups);
            sourceDestCheck(model.sourceDestCheck);
            spotInstanceRequestId(model.spotInstanceRequestId);
            sriovNetSupport(model.sriovNetSupport);
            stateReason(model.stateReason);
            tags(model.tags);
            virtualizationType(model.virtualizationType);
            cpuOptions(model.cpuOptions);
            capacityReservationId(model.capacityReservationId);
            capacityReservationSpecification(model.capacityReservationSpecification);
            hibernationOptions(model.hibernationOptions);
            licenses(model.licenses);
            metadataOptions(model.metadataOptions);
        }

        public final Integer getAmiLaunchIndex() {
            return amiLaunchIndex;
        }

        @Override
        public final Builder amiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
            return this;
        }

        public final void setAmiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceTypeAsString() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        public final Monitoring.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Monitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final Placement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getPlatformAsString() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return productCodes != null ? productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getPublicDnsName() {
            return publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIpAddress() {
            return publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final InstanceState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final String getStateTransitionReason() {
            return stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getArchitectureAsString() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Collection<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(InstanceBlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> InstanceBlockDeviceMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final String getHypervisorAsString() {
            return hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor == null ? null : hypervisor.toString());
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final IamInstanceProfile.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getInstanceLifecycleAsString() {
            return instanceLifecycle;
        }

        @Override
        public final Builder instanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
            return this;
        }

        @Override
        public final Builder instanceLifecycle(InstanceLifecycleType instanceLifecycle) {
            this.instanceLifecycle(instanceLifecycle == null ? null : instanceLifecycle.toString());
            return this;
        }

        public final void setInstanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
        }

        public final Collection<ElasticGpuAssociation.Builder> getElasticGpuAssociations() {
            return elasticGpuAssociations != null ? elasticGpuAssociations.stream().map(ElasticGpuAssociation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticGpuAssociations(Collection<ElasticGpuAssociation> elasticGpuAssociations) {
            this.elasticGpuAssociations = ElasticGpuAssociationListCopier.copy(elasticGpuAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuAssociations(ElasticGpuAssociation... elasticGpuAssociations) {
            elasticGpuAssociations(Arrays.asList(elasticGpuAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuAssociations(Consumer<ElasticGpuAssociation.Builder>... elasticGpuAssociations) {
            elasticGpuAssociations(Stream.of(elasticGpuAssociations)
                    .map(c -> ElasticGpuAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticGpuAssociations(Collection<ElasticGpuAssociation.BuilderImpl> elasticGpuAssociations) {
            this.elasticGpuAssociations = ElasticGpuAssociationListCopier.copyFromBuilder(elasticGpuAssociations);
        }

        public final Collection<ElasticInferenceAcceleratorAssociation.Builder> getElasticInferenceAcceleratorAssociations() {
            return elasticInferenceAcceleratorAssociations != null ? elasticInferenceAcceleratorAssociations.stream()
                    .map(ElasticInferenceAcceleratorAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticInferenceAcceleratorAssociations(
                Collection<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations) {
            this.elasticInferenceAcceleratorAssociations = ElasticInferenceAcceleratorAssociationListCopier
                    .copy(elasticInferenceAcceleratorAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAcceleratorAssociations(
                ElasticInferenceAcceleratorAssociation... elasticInferenceAcceleratorAssociations) {
            elasticInferenceAcceleratorAssociations(Arrays.asList(elasticInferenceAcceleratorAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAcceleratorAssociations(
                Consumer<ElasticInferenceAcceleratorAssociation.Builder>... elasticInferenceAcceleratorAssociations) {
            elasticInferenceAcceleratorAssociations(Stream.of(elasticInferenceAcceleratorAssociations)
                    .map(c -> ElasticInferenceAcceleratorAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setElasticInferenceAcceleratorAssociations(
                Collection<ElasticInferenceAcceleratorAssociation.BuilderImpl> elasticInferenceAcceleratorAssociations) {
            this.elasticInferenceAcceleratorAssociations = ElasticInferenceAcceleratorAssociationListCopier
                    .copyFromBuilder(elasticInferenceAcceleratorAssociations);
        }

        public final Collection<InstanceNetworkInterface.Builder> getNetworkInterfaces() {
            return networkInterfaces != null ? networkInterfaces.stream().map(InstanceNetworkInterface::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterface.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces).map(c -> InstanceNetworkInterface.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copyFromBuilder(networkInterfaces);
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final String getRootDeviceTypeAsString() {
            return rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType == null ? null : rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final Collection<GroupIdentifier.Builder> getSecurityGroups() {
            return securityGroups != null ? securityGroups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<GroupIdentifier.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups).map(c -> GroupIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getSpotInstanceRequestId() {
            return spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final StateReason.Builder getStateReason() {
            return stateReason != null ? stateReason.toBuilder() : null;
        }

        @Override
        public final Builder stateReason(StateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(StateReason.BuilderImpl stateReason) {
            this.stateReason = stateReason != null ? stateReason.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVirtualizationTypeAsString() {
            return virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType == null ? null : virtualizationType.toString());
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        public final CpuOptions.Builder getCpuOptions() {
            return cpuOptions != null ? cpuOptions.toBuilder() : null;
        }

        @Override
        public final Builder cpuOptions(CpuOptions cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final void setCpuOptions(CpuOptions.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        public final CapacityReservationSpecificationResponse.Builder getCapacityReservationSpecification() {
            return capacityReservationSpecification != null ? capacityReservationSpecification.toBuilder() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(
                CapacityReservationSpecificationResponse capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final void setCapacityReservationSpecification(
                CapacityReservationSpecificationResponse.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification
                    .build() : null;
        }

        public final HibernationOptions.Builder getHibernationOptions() {
            return hibernationOptions != null ? hibernationOptions.toBuilder() : null;
        }

        @Override
        public final Builder hibernationOptions(HibernationOptions hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final void setHibernationOptions(HibernationOptions.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        public final Collection<LicenseConfiguration.Builder> getLicenses() {
            return licenses != null ? licenses.stream().map(LicenseConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenses(Collection<LicenseConfiguration> licenses) {
            this.licenses = LicenseListCopier.copy(licenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(LicenseConfiguration... licenses) {
            licenses(Arrays.asList(licenses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(Consumer<LicenseConfiguration.Builder>... licenses) {
            licenses(Stream.of(licenses).map(c -> LicenseConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLicenses(Collection<LicenseConfiguration.BuilderImpl> licenses) {
            this.licenses = LicenseListCopier.copyFromBuilder(licenses);
        }

        public final InstanceMetadataOptionsResponse.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        @Override
        public final Builder metadataOptions(InstanceMetadataOptionsResponse metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final void setMetadataOptions(InstanceMetadataOptionsResponse.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
