/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the burstable performance instance whose credit option for CPU usage was not modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnsuccessfulInstanceCreditSpecificationItem implements SdkPojo, Serializable,
        ToCopyableBuilder<UnsuccessfulInstanceCreditSpecificationItem.Builder, UnsuccessfulInstanceCreditSpecificationItem> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UnsuccessfulInstanceCreditSpecificationItem::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<UnsuccessfulInstanceCreditSpecificationItemError> ERROR_FIELD = SdkField
            .<UnsuccessfulInstanceCreditSpecificationItemError> builder(MarshallingType.SDK_POJO)
            .getter(getter(UnsuccessfulInstanceCreditSpecificationItem::error))
            .setter(setter(Builder::error))
            .constructor(UnsuccessfulInstanceCreditSpecificationItemError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error")
                    .unmarshallLocationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INSTANCE_ID_FIELD, ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final UnsuccessfulInstanceCreditSpecificationItemError error;

    private UnsuccessfulInstanceCreditSpecificationItem(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.error = builder.error;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The applicable error for the burstable performance instance whose credit option for CPU usage was not modified.
     * </p>
     * 
     * @return The applicable error for the burstable performance instance whose credit option for CPU usage was not
     *         modified.
     */
    public UnsuccessfulInstanceCreditSpecificationItemError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsuccessfulInstanceCreditSpecificationItem)) {
            return false;
        }
        UnsuccessfulInstanceCreditSpecificationItem other = (UnsuccessfulInstanceCreditSpecificationItem) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UnsuccessfulInstanceCreditSpecificationItem").add("InstanceId", instanceId())
                .add("Error", error()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnsuccessfulInstanceCreditSpecificationItem, T> g) {
        return obj -> g.apply((UnsuccessfulInstanceCreditSpecificationItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnsuccessfulInstanceCreditSpecificationItem> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The applicable error for the burstable performance instance whose credit option for CPU usage was not
         * modified.
         * </p>
         * 
         * @param error
         *        The applicable error for the burstable performance instance whose credit option for CPU usage was not
         *        modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(UnsuccessfulInstanceCreditSpecificationItemError error);

        /**
         * <p>
         * The applicable error for the burstable performance instance whose credit option for CPU usage was not
         * modified.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link UnsuccessfulInstanceCreditSpecificationItemError.Builder} avoiding the need to create one manually via
         * {@link UnsuccessfulInstanceCreditSpecificationItemError#builder()}.
         *
         * When the {@link Consumer} completes, {@link UnsuccessfulInstanceCreditSpecificationItemError.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #error(UnsuccessfulInstanceCreditSpecificationItemError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link UnsuccessfulInstanceCreditSpecificationItemError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(UnsuccessfulInstanceCreditSpecificationItemError)
         */
        default Builder error(Consumer<UnsuccessfulInstanceCreditSpecificationItemError.Builder> error) {
            return error(UnsuccessfulInstanceCreditSpecificationItemError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private UnsuccessfulInstanceCreditSpecificationItemError error;

        private BuilderImpl() {
        }

        private BuilderImpl(UnsuccessfulInstanceCreditSpecificationItem model) {
            instanceId(model.instanceId);
            error(model.error);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final UnsuccessfulInstanceCreditSpecificationItemError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        @Override
        public final Builder error(UnsuccessfulInstanceCreditSpecificationItemError error) {
            this.error = error;
            return this;
        }

        public final void setError(UnsuccessfulInstanceCreditSpecificationItemError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public UnsuccessfulInstanceCreditSpecificationItem build() {
            return new UnsuccessfulInstanceCreditSpecificationItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
