/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImportSnapshotTasksResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeImportSnapshotTasksResponse.Builder, DescribeImportSnapshotTasksResponse> {
    private static final SdkField<List<ImportSnapshotTask>> IMPORT_SNAPSHOT_TASKS_FIELD = SdkField
            .<List<ImportSnapshotTask>> builder(MarshallingType.LIST)
            .getter(getter(DescribeImportSnapshotTasksResponse::importSnapshotTasks))
            .setter(setter(Builder::importSnapshotTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportSnapshotTaskSet")
                    .unmarshallLocationName("importSnapshotTaskSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImportSnapshotTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportSnapshotTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeImportSnapshotTasksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_SNAPSHOT_TASKS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ImportSnapshotTask> importSnapshotTasks;

    private final String nextToken;

    private DescribeImportSnapshotTasksResponse(BuilderImpl builder) {
        super(builder);
        this.importSnapshotTasks = builder.importSnapshotTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ImportSnapshotTasks property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasImportSnapshotTasks() {
        return importSnapshotTasks != null && !(importSnapshotTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the
     * previous 7 days.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImportSnapshotTasks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of zero or more import snapshot tasks that are currently active or were completed or canceled in
     *         the previous 7 days.
     */
    public List<ImportSnapshotTask> importSnapshotTasks() {
        return importSnapshotTasks;
    }

    /**
     * <p>
     * The token to use to get the next page of results. This value is <code>null</code> when there are no more results
     * to return.
     * </p>
     * 
     * @return The token to use to get the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importSnapshotTasks());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportSnapshotTasksResponse)) {
            return false;
        }
        DescribeImportSnapshotTasksResponse other = (DescribeImportSnapshotTasksResponse) obj;
        return Objects.equals(importSnapshotTasks(), other.importSnapshotTasks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeImportSnapshotTasksResponse").add("ImportSnapshotTasks", importSnapshotTasks())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportSnapshotTasks":
            return Optional.ofNullable(clazz.cast(importSnapshotTasks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImportSnapshotTasksResponse, T> g) {
        return obj -> g.apply((DescribeImportSnapshotTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImportSnapshotTasksResponse> {
        /**
         * <p>
         * A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * 
         * @param importSnapshotTasks
         *        A list of zero or more import snapshot tasks that are currently active or were completed or canceled
         *        in the previous 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSnapshotTasks(Collection<ImportSnapshotTask> importSnapshotTasks);

        /**
         * <p>
         * A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * 
         * @param importSnapshotTasks
         *        A list of zero or more import snapshot tasks that are currently active or were completed or canceled
         *        in the previous 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSnapshotTasks(ImportSnapshotTask... importSnapshotTasks);

        /**
         * <p>
         * A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImportSnapshotTask>.Builder} avoiding the
         * need to create one manually via {@link List<ImportSnapshotTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImportSnapshotTask>.Builder#build()} is called immediately
         * and its result is passed to {@link #importSnapshotTasks(List<ImportSnapshotTask>)}.
         * 
         * @param importSnapshotTasks
         *        a consumer that will call methods on {@link List<ImportSnapshotTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importSnapshotTasks(List<ImportSnapshotTask>)
         */
        Builder importSnapshotTasks(Consumer<ImportSnapshotTask.Builder>... importSnapshotTasks);

        /**
         * <p>
         * The token to use to get the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ImportSnapshotTask> importSnapshotTasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportSnapshotTasksResponse model) {
            super(model);
            importSnapshotTasks(model.importSnapshotTasks);
            nextToken(model.nextToken);
        }

        public final Collection<ImportSnapshotTask.Builder> getImportSnapshotTasks() {
            return importSnapshotTasks != null ? importSnapshotTasks.stream().map(ImportSnapshotTask::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder importSnapshotTasks(Collection<ImportSnapshotTask> importSnapshotTasks) {
            this.importSnapshotTasks = ImportSnapshotTaskListCopier.copy(importSnapshotTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSnapshotTasks(ImportSnapshotTask... importSnapshotTasks) {
            importSnapshotTasks(Arrays.asList(importSnapshotTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSnapshotTasks(Consumer<ImportSnapshotTask.Builder>... importSnapshotTasks) {
            importSnapshotTasks(Stream.of(importSnapshotTasks).map(c -> ImportSnapshotTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setImportSnapshotTasks(Collection<ImportSnapshotTask.BuilderImpl> importSnapshotTasks) {
            this.importSnapshotTasks = ImportSnapshotTaskListCopier.copyFromBuilder(importSnapshotTasks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImportSnapshotTasksResponse build() {
            return new DescribeImportSnapshotTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
