/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePrefixListsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribePrefixListsResponse.Builder, DescribePrefixListsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribePrefixListsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<PrefixList>> PREFIX_LISTS_FIELD = SdkField
            .<List<PrefixList>> builder(MarshallingType.LIST)
            .getter(getter(DescribePrefixListsResponse::prefixLists))
            .setter(setter(Builder::prefixLists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListSet")
                    .unmarshallLocationName("prefixListSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PrefixList> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrefixList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PREFIX_LISTS_FIELD));

    private final String nextToken;

    private final List<PrefixList> prefixLists;

    private DescribePrefixListsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.prefixLists = builder.prefixLists;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the PrefixLists property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPrefixLists() {
        return prefixLists != null && !(prefixLists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * All available prefix lists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrefixLists()} to see if a value was sent in this field.
     * </p>
     * 
     * @return All available prefix lists.
     */
    public List<PrefixList> prefixLists() {
        return prefixLists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(prefixLists());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrefixListsResponse)) {
            return false;
        }
        DescribePrefixListsResponse other = (DescribePrefixListsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(prefixLists(), other.prefixLists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePrefixListsResponse").add("NextToken", nextToken()).add("PrefixLists", prefixLists())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PrefixLists":
            return Optional.ofNullable(clazz.cast(prefixLists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePrefixListsResponse, T> g) {
        return obj -> g.apply((DescribePrefixListsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribePrefixListsResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * All available prefix lists.
         * </p>
         * 
         * @param prefixLists
         *        All available prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixLists(Collection<PrefixList> prefixLists);

        /**
         * <p>
         * All available prefix lists.
         * </p>
         * 
         * @param prefixLists
         *        All available prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixLists(PrefixList... prefixLists);

        /**
         * <p>
         * All available prefix lists.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrefixList>.Builder} avoiding the need to
         * create one manually via {@link List<PrefixList>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrefixList>.Builder#build()} is called immediately and its
         * result is passed to {@link #prefixLists(List<PrefixList>)}.
         * 
         * @param prefixLists
         *        a consumer that will call methods on {@link List<PrefixList>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prefixLists(List<PrefixList>)
         */
        Builder prefixLists(Consumer<PrefixList.Builder>... prefixLists);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<PrefixList> prefixLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrefixListsResponse model) {
            super(model);
            nextToken(model.nextToken);
            prefixLists(model.prefixLists);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<PrefixList.Builder> getPrefixLists() {
            return prefixLists != null ? prefixLists.stream().map(PrefixList::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder prefixLists(Collection<PrefixList> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copy(prefixLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixLists(PrefixList... prefixLists) {
            prefixLists(Arrays.asList(prefixLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixLists(Consumer<PrefixList.Builder>... prefixLists) {
            prefixLists(Stream.of(prefixLists).map(c -> PrefixList.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPrefixLists(Collection<PrefixList.BuilderImpl> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copyFromBuilder(prefixLists);
        }

        @Override
        public DescribePrefixListsResponse build() {
            return new DescribePrefixListsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
