/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a set of DHCP options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DhcpOptions implements SdkPojo, Serializable, ToCopyableBuilder<DhcpOptions.Builder, DhcpOptions> {
    private static final SdkField<List<DhcpConfiguration>> DHCP_CONFIGURATIONS_FIELD = SdkField
            .<List<DhcpConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(DhcpOptions::dhcpConfigurations))
            .setter(setter(Builder::dhcpConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpConfigurationSet")
                    .unmarshallLocationName("dhcpConfigurationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DhcpConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DhcpConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> DHCP_OPTIONS_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DhcpOptions::dhcpOptionsId))
            .setter(setter(Builder::dhcpOptionsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsId")
                    .unmarshallLocationName("dhcpOptionsId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DhcpOptions::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(DhcpOptions::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DHCP_CONFIGURATIONS_FIELD,
            DHCP_OPTIONS_ID_FIELD, OWNER_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DhcpConfiguration> dhcpConfigurations;

    private final String dhcpOptionsId;

    private final String ownerId;

    private final List<Tag> tags;

    private DhcpOptions(BuilderImpl builder) {
        this.dhcpConfigurations = builder.dhcpConfigurations;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
    }

    /**
     * Returns true if the DhcpConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDhcpConfigurations() {
        return dhcpConfigurations != null && !(dhcpConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more DHCP options in the set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDhcpConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more DHCP options in the set.
     */
    public List<DhcpConfiguration> dhcpConfigurations() {
        return dhcpConfigurations;
    }

    /**
     * <p>
     * The ID of the set of DHCP options.
     * </p>
     * 
     * @return The ID of the set of DHCP options.
     */
    public String dhcpOptionsId() {
        return dhcpOptionsId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the DHCP options set.
     * </p>
     * 
     * @return The ID of the AWS account that owns the DHCP options set.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the DHCP options set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the DHCP options set.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dhcpConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(dhcpOptionsId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DhcpOptions)) {
            return false;
        }
        DhcpOptions other = (DhcpOptions) obj;
        return Objects.equals(dhcpConfigurations(), other.dhcpConfigurations())
                && Objects.equals(dhcpOptionsId(), other.dhcpOptionsId()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DhcpOptions").add("DhcpConfigurations", dhcpConfigurations())
                .add("DhcpOptionsId", dhcpOptionsId()).add("OwnerId", ownerId()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DhcpConfigurations":
            return Optional.ofNullable(clazz.cast(dhcpConfigurations()));
        case "DhcpOptionsId":
            return Optional.ofNullable(clazz.cast(dhcpOptionsId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DhcpOptions, T> g) {
        return obj -> g.apply((DhcpOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DhcpOptions> {
        /**
         * <p>
         * One or more DHCP options in the set.
         * </p>
         * 
         * @param dhcpConfigurations
         *        One or more DHCP options in the set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations);

        /**
         * <p>
         * One or more DHCP options in the set.
         * </p>
         * 
         * @param dhcpConfigurations
         *        One or more DHCP options in the set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpConfigurations(DhcpConfiguration... dhcpConfigurations);

        /**
         * <p>
         * One or more DHCP options in the set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DhcpConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<DhcpConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DhcpConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #dhcpConfigurations(List<DhcpConfiguration>)}.
         * 
         * @param dhcpConfigurations
         *        a consumer that will call methods on {@link List<DhcpConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dhcpConfigurations(List<DhcpConfiguration>)
         */
        Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder>... dhcpConfigurations);

        /**
         * <p>
         * The ID of the set of DHCP options.
         * </p>
         * 
         * @param dhcpOptionsId
         *        The ID of the set of DHCP options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptionsId(String dhcpOptionsId);

        /**
         * <p>
         * The ID of the AWS account that owns the DHCP options set.
         * </p>
         * 
         * @param ownerId
         *        The ID of the AWS account that owns the DHCP options set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Any tags assigned to the DHCP options set.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the DHCP options set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the DHCP options set.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the DHCP options set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the DHCP options set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private List<DhcpConfiguration> dhcpConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String dhcpOptionsId;

        private String ownerId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DhcpOptions model) {
            dhcpConfigurations(model.dhcpConfigurations);
            dhcpOptionsId(model.dhcpOptionsId);
            ownerId(model.ownerId);
            tags(model.tags);
        }

        public final Collection<DhcpConfiguration.Builder> getDhcpConfigurations() {
            return dhcpConfigurations != null ? dhcpConfigurations.stream().map(DhcpConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copy(dhcpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(DhcpConfiguration... dhcpConfigurations) {
            dhcpConfigurations(Arrays.asList(dhcpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder>... dhcpConfigurations) {
            dhcpConfigurations(Stream.of(dhcpConfigurations).map(c -> DhcpConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDhcpConfigurations(Collection<DhcpConfiguration.BuilderImpl> dhcpConfigurations) {
            this.dhcpConfigurations = DhcpConfigurationListCopier.copyFromBuilder(dhcpConfigurations);
        }

        public final String getDhcpOptionsId() {
            return dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public DhcpOptions build() {
            return new DhcpOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
