/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopInstancesRequest extends Ec2Request implements
        ToCopyableBuilder<StopInstancesRequest.Builder, StopInstancesRequest> {
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(StopInstancesRequest::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("InstanceId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("InstanceId").unmarshallLocationName("InstanceId").build())
                                            .build()).build()).build();

    private static final SdkField<Boolean> HIBERNATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(StopInstancesRequest::hibernate))
            .setter(setter(Builder::hibernate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hibernate")
                    .unmarshallLocationName("Hibernate").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(StopInstancesRequest::force))
            .setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force")
                    .unmarshallLocationName("force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDS_FIELD,
            HIBERNATE_FIELD, FORCE_FIELD));

    private final List<String> instanceIds;

    private final Boolean hibernate;

    private final Boolean force;

    private StopInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceIds = builder.instanceIds;
        this.hibernate = builder.hibernate;
        this.force = builder.force;
    }

    /**
     * Returns true if the InstanceIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the instances.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * Hibernates the instance if the instance was enabled for hibernation at launch. If the instance cannot hibernate
     * successfully, a normal shutdown occurs. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Hibernates the instance if the instance was enabled for hibernation at launch. If the instance cannot
     *         hibernate successfully, a normal shutdown occurs. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean hibernate() {
        return hibernate;
    }

    /**
     * <p>
     * Forces the instances to stop. The instances do not have an opportunity to flush file system caches or file system
     * metadata. If you use this option, you must perform file system check and repair procedures. This option is not
     * recommended for Windows instances.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Forces the instances to stop. The instances do not have an opportunity to flush file system caches or
     *         file system metadata. If you use this option, you must perform file system check and repair procedures.
     *         This option is not recommended for Windows instances.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(hibernate());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstancesRequest)) {
            return false;
        }
        StopInstancesRequest other = (StopInstancesRequest) obj;
        return Objects.equals(instanceIds(), other.instanceIds()) && Objects.equals(hibernate(), other.hibernate())
                && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StopInstancesRequest").add("InstanceIds", instanceIds()).add("Hibernate", hibernate())
                .add("Force", force()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "Hibernate":
            return Optional.ofNullable(clazz.cast(hibernate()));
        case "Force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopInstancesRequest, T> g) {
        return obj -> g.apply((StopInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, StopInstancesRequest> {
        /**
         * <p>
         * The IDs of the instances.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The IDs of the instances.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * Hibernates the instance if the instance was enabled for hibernation at launch. If the instance cannot
         * hibernate successfully, a normal shutdown occurs. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param hibernate
         *        Hibernates the instance if the instance was enabled for hibernation at launch. If the instance cannot
         *        hibernate successfully, a normal shutdown occurs. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hibernate(Boolean hibernate);

        /**
         * <p>
         * Forces the instances to stop. The instances do not have an opportunity to flush file system caches or file
         * system metadata. If you use this option, you must perform file system check and repair procedures. This
         * option is not recommended for Windows instances.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param force
         *        Forces the instances to stop. The instances do not have an opportunity to flush file system caches or
         *        file system metadata. If you use this option, you must perform file system check and repair
         *        procedures. This option is not recommended for Windows instances.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean hibernate;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstancesRequest model) {
            super(model);
            instanceIds(model.instanceIds);
            hibernate(model.hibernate);
            force(model.force);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
        }

        public final Boolean getHibernate() {
            return hibernate;
        }

        @Override
        public final Builder hibernate(Boolean hibernate) {
            this.hibernate = hibernate;
            return this;
        }

        public final void setHibernate(Boolean hibernate) {
            this.hibernate = hibernate;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopInstancesRequest build() {
            return new StopInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
