/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the members registered with the transit gateway multicast group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayMulticastRegisteredGroupSources implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayMulticastRegisteredGroupSources.Builder, TransitGatewayMulticastRegisteredGroupSources> {
    private static final SdkField<String> TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastRegisteredGroupSources::transitGatewayMulticastDomainId))
            .setter(setter(Builder::transitGatewayMulticastDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomainId")
                    .unmarshallLocationName("transitGatewayMulticastDomainId").build()).build();

    private static final SdkField<List<String>> REGISTERED_NETWORK_INTERFACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(TransitGatewayMulticastRegisteredGroupSources::registeredNetworkInterfaceIds))
            .setter(setter(Builder::registeredNetworkInterfaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredNetworkInterfaceIds")
                    .unmarshallLocationName("registeredNetworkInterfaceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> GROUP_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayMulticastRegisteredGroupSources::groupIpAddress))
            .setter(setter(Builder::groupIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIpAddress")
                    .unmarshallLocationName("groupIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD, REGISTERED_NETWORK_INTERFACE_IDS_FIELD, GROUP_IP_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayMulticastDomainId;

    private final List<String> registeredNetworkInterfaceIds;

    private final String groupIpAddress;

    private TransitGatewayMulticastRegisteredGroupSources(BuilderImpl builder) {
        this.transitGatewayMulticastDomainId = builder.transitGatewayMulticastDomainId;
        this.registeredNetworkInterfaceIds = builder.registeredNetworkInterfaceIds;
        this.groupIpAddress = builder.groupIpAddress;
    }

    /**
     * <p>
     * The ID of the transit gateway multicast domain.
     * </p>
     * 
     * @return The ID of the transit gateway multicast domain.
     */
    public String transitGatewayMulticastDomainId() {
        return transitGatewayMulticastDomainId;
    }

    /**
     * Returns true if the RegisteredNetworkInterfaceIds property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasRegisteredNetworkInterfaceIds() {
        return registeredNetworkInterfaceIds != null && !(registeredNetworkInterfaceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the network interfaces members registered with the transit gateway multicast group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegisteredNetworkInterfaceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the network interfaces members registered with the transit gateway multicast group.
     */
    public List<String> registeredNetworkInterfaceIds() {
        return registeredNetworkInterfaceIds;
    }

    /**
     * <p>
     * The IP address assigned to the transit gateway multicast group.
     * </p>
     * 
     * @return The IP address assigned to the transit gateway multicast group.
     */
    public String groupIpAddress() {
        return groupIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayMulticastDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(registeredNetworkInterfaceIds());
        hashCode = 31 * hashCode + Objects.hashCode(groupIpAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMulticastRegisteredGroupSources)) {
            return false;
        }
        TransitGatewayMulticastRegisteredGroupSources other = (TransitGatewayMulticastRegisteredGroupSources) obj;
        return Objects.equals(transitGatewayMulticastDomainId(), other.transitGatewayMulticastDomainId())
                && Objects.equals(registeredNetworkInterfaceIds(), other.registeredNetworkInterfaceIds())
                && Objects.equals(groupIpAddress(), other.groupIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransitGatewayMulticastRegisteredGroupSources")
                .add("TransitGatewayMulticastDomainId", transitGatewayMulticastDomainId())
                .add("RegisteredNetworkInterfaceIds", registeredNetworkInterfaceIds()).add("GroupIpAddress", groupIpAddress())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayMulticastDomainId":
            return Optional.ofNullable(clazz.cast(transitGatewayMulticastDomainId()));
        case "RegisteredNetworkInterfaceIds":
            return Optional.ofNullable(clazz.cast(registeredNetworkInterfaceIds()));
        case "GroupIpAddress":
            return Optional.ofNullable(clazz.cast(groupIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMulticastRegisteredGroupSources, T> g) {
        return obj -> g.apply((TransitGatewayMulticastRegisteredGroupSources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayMulticastRegisteredGroupSources> {
        /**
         * <p>
         * The ID of the transit gateway multicast domain.
         * </p>
         * 
         * @param transitGatewayMulticastDomainId
         *        The ID of the transit gateway multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId);

        /**
         * <p>
         * The IDs of the network interfaces members registered with the transit gateway multicast group.
         * </p>
         * 
         * @param registeredNetworkInterfaceIds
         *        The IDs of the network interfaces members registered with the transit gateway multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredNetworkInterfaceIds(Collection<String> registeredNetworkInterfaceIds);

        /**
         * <p>
         * The IDs of the network interfaces members registered with the transit gateway multicast group.
         * </p>
         * 
         * @param registeredNetworkInterfaceIds
         *        The IDs of the network interfaces members registered with the transit gateway multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredNetworkInterfaceIds(String... registeredNetworkInterfaceIds);

        /**
         * <p>
         * The IP address assigned to the transit gateway multicast group.
         * </p>
         * 
         * @param groupIpAddress
         *        The IP address assigned to the transit gateway multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIpAddress(String groupIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayMulticastDomainId;

        private List<String> registeredNetworkInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private String groupIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMulticastRegisteredGroupSources model) {
            transitGatewayMulticastDomainId(model.transitGatewayMulticastDomainId);
            registeredNetworkInterfaceIds(model.registeredNetworkInterfaceIds);
            groupIpAddress(model.groupIpAddress);
        }

        public final String getTransitGatewayMulticastDomainId() {
            return transitGatewayMulticastDomainId;
        }

        @Override
        public final Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        public final void setTransitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
        }

        public final Collection<String> getRegisteredNetworkInterfaceIds() {
            return registeredNetworkInterfaceIds;
        }

        @Override
        public final Builder registeredNetworkInterfaceIds(Collection<String> registeredNetworkInterfaceIds) {
            this.registeredNetworkInterfaceIds = ValueStringListCopier.copy(registeredNetworkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registeredNetworkInterfaceIds(String... registeredNetworkInterfaceIds) {
            registeredNetworkInterfaceIds(Arrays.asList(registeredNetworkInterfaceIds));
            return this;
        }

        public final void setRegisteredNetworkInterfaceIds(Collection<String> registeredNetworkInterfaceIds) {
            this.registeredNetworkInterfaceIds = ValueStringListCopier.copy(registeredNetworkInterfaceIds);
        }

        public final String getGroupIpAddress() {
            return groupIpAddress;
        }

        @Override
        public final Builder groupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
            return this;
        }

        public final void setGroupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
        }

        @Override
        public TransitGatewayMulticastRegisteredGroupSources build() {
            return new TransitGatewayMulticastRegisteredGroupSources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
