/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an image attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageAttributeResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeImageAttributeResponse.Builder, DescribeImageAttributeResponse> {
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .getter(getter(DescribeImageAttributeResponse::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeImageAttributeResponse::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<List<LaunchPermission>> LAUNCH_PERMISSIONS_FIELD = SdkField
            .<List<LaunchPermission>> builder(MarshallingType.LIST)
            .getter(getter(DescribeImageAttributeResponse::launchPermissions))
            .setter(setter(Builder::launchPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPermission")
                    .unmarshallLocationName("launchPermission").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .getter(getter(DescribeImageAttributeResponse::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes")
                    .unmarshallLocationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeImageAttributeResponse::description))
            .setter(setter(Builder::description))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<AttributeValue> KERNEL_ID_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeImageAttributeResponse::kernelId))
            .setter(setter(Builder::kernelId))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Kernel")
                    .unmarshallLocationName("kernel").build()).build();

    private static final SdkField<AttributeValue> RAMDISK_ID_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeImageAttributeResponse::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ramdisk")
                    .unmarshallLocationName("ramdisk").build()).build();

    private static final SdkField<AttributeValue> SRIOV_NET_SUPPORT_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeImageAttributeResponse::sriovNetSupport))
            .setter(setter(Builder::sriovNetSupport))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport")
                    .unmarshallLocationName("sriovNetSupport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DEVICE_MAPPINGS_FIELD,
            IMAGE_ID_FIELD, LAUNCH_PERMISSIONS_FIELD, PRODUCT_CODES_FIELD, DESCRIPTION_FIELD, KERNEL_ID_FIELD, RAMDISK_ID_FIELD,
            SRIOV_NET_SUPPORT_FIELD));

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String imageId;

    private final List<LaunchPermission> launchPermissions;

    private final List<ProductCode> productCodes;

    private final AttributeValue description;

    private final AttributeValue kernelId;

    private final AttributeValue ramdiskId;

    private final AttributeValue sriovNetSupport;

    private DescribeImageAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.imageId = builder.imageId;
        this.launchPermissions = builder.launchPermissions;
        this.productCodes = builder.productCodes;
        this.description = builder.description;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.sriovNetSupport = builder.sriovNetSupport;
    }

    /**
     * Returns true if the BlockDeviceMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlockDeviceMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The block device mapping entries.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * Returns true if the LaunchPermissions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLaunchPermissions() {
        return launchPermissions != null && !(launchPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The launch permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLaunchPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The launch permissions.
     */
    public List<LaunchPermission> launchPermissions() {
        return launchPermissions;
    }

    /**
     * Returns true if the ProductCodes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProductCodes() {
        return productCodes != null && !(productCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The product codes.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * A description for the AMI.
     * </p>
     * 
     * @return A description for the AMI.
     */
    public AttributeValue description() {
        return description;
    }

    /**
     * <p>
     * The kernel ID.
     * </p>
     * 
     * @return The kernel ID.
     */
    public AttributeValue kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The RAM disk ID.
     * </p>
     * 
     * @return The RAM disk ID.
     */
    public AttributeValue ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public AttributeValue sriovNetSupport() {
        return sriovNetSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(launchPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageAttributeResponse)) {
            return false;
        }
        DescribeImageAttributeResponse other = (DescribeImageAttributeResponse) obj;
        return Objects.equals(blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(launchPermissions(), other.launchPermissions())
                && Objects.equals(productCodes(), other.productCodes()) && Objects.equals(description(), other.description())
                && Objects.equals(kernelId(), other.kernelId()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(sriovNetSupport(), other.sriovNetSupport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeImageAttributeResponse").add("BlockDeviceMappings", blockDeviceMappings())
                .add("ImageId", imageId()).add("LaunchPermissions", launchPermissions()).add("ProductCodes", productCodes())
                .add("Description", description()).add("KernelId", kernelId()).add("RamdiskId", ramdiskId())
                .add("SriovNetSupport", sriovNetSupport()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "LaunchPermissions":
            return Optional.ofNullable(clazz.cast(launchPermissions()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "SriovNetSupport":
            return Optional.ofNullable(clazz.cast(sriovNetSupport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageAttributeResponse, T> g) {
        return obj -> g.apply((DescribeImageAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageAttributeResponse> {
        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mapping entries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BlockDeviceMapping>.Builder} avoiding the
         * need to create one manually via {@link List<BlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BlockDeviceMapping>.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<BlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The launch permissions.
         * </p>
         * 
         * @param launchPermissions
         *        The launch permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPermissions(Collection<LaunchPermission> launchPermissions);

        /**
         * <p>
         * The launch permissions.
         * </p>
         * 
         * @param launchPermissions
         *        The launch permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPermissions(LaunchPermission... launchPermissions);

        /**
         * <p>
         * The launch permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchPermission>.Builder} avoiding the
         * need to create one manually via {@link List<LaunchPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchPermission>.Builder#build()} is called immediately and
         * its result is passed to {@link #launchPermissions(List<LaunchPermission>)}.
         * 
         * @param launchPermissions
         *        a consumer that will call methods on {@link List<LaunchPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchPermissions(List<LaunchPermission>)
         */
        Builder launchPermissions(Consumer<LaunchPermission.Builder>... launchPermissions);

        /**
         * <p>
         * The product codes.
         * </p>
         * 
         * @param productCodes
         *        The product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product codes.
         * </p>
         * 
         * @param productCodes
         *        The product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The product codes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductCode>.Builder} avoiding the need to
         * create one manually via {@link List<ProductCode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductCode>.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on {@link List<ProductCode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(List<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * A description for the AMI.
         * </p>
         * 
         * @param description
         *        A description for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(AttributeValue description);

        /**
         * <p>
         * A description for the AMI.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeValue.Builder} avoiding the need to
         * create one manually via {@link AttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #description(AttributeValue)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(AttributeValue)
         */
        default Builder description(Consumer<AttributeValue.Builder> description) {
            return description(AttributeValue.builder().applyMutation(description).build());
        }

        /**
         * <p>
         * The kernel ID.
         * </p>
         * 
         * @param kernelId
         *        The kernel ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(AttributeValue kernelId);

        /**
         * <p>
         * The kernel ID.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeValue.Builder} avoiding the need to
         * create one manually via {@link AttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #kernelId(AttributeValue)}.
         * 
         * @param kernelId
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernelId(AttributeValue)
         */
        default Builder kernelId(Consumer<AttributeValue.Builder> kernelId) {
            return kernelId(AttributeValue.builder().applyMutation(kernelId).build());
        }

        /**
         * <p>
         * The RAM disk ID.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(AttributeValue ramdiskId);

        /**
         * <p>
         * The RAM disk ID.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeValue.Builder} avoiding the need to
         * create one manually via {@link AttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #ramdiskId(AttributeValue)}.
         * 
         * @param ramdiskId
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ramdiskId(AttributeValue)
         */
        default Builder ramdiskId(Consumer<AttributeValue.Builder> ramdiskId) {
            return ramdiskId(AttributeValue.builder().applyMutation(ramdiskId).build());
        }

        /**
         * <p>
         * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(AttributeValue sriovNetSupport);

        /**
         * <p>
         * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeValue.Builder} avoiding the need to
         * create one manually via {@link AttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #sriovNetSupport(AttributeValue)}.
         * 
         * @param sriovNetSupport
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sriovNetSupport(AttributeValue)
         */
        default Builder sriovNetSupport(Consumer<AttributeValue.Builder> sriovNetSupport) {
            return sriovNetSupport(AttributeValue.builder().applyMutation(sriovNetSupport).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private String imageId;

        private List<LaunchPermission> launchPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private AttributeValue description;

        private AttributeValue kernelId;

        private AttributeValue ramdiskId;

        private AttributeValue sriovNetSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageAttributeResponse model) {
            super(model);
            blockDeviceMappings(model.blockDeviceMappings);
            imageId(model.imageId);
            launchPermissions(model.launchPermissions);
            productCodes(model.productCodes);
            description(model.description);
            kernelId(model.kernelId);
            ramdiskId(model.ramdiskId);
            sriovNetSupport(model.sriovNetSupport);
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Collection<LaunchPermission.Builder> getLaunchPermissions() {
            return launchPermissions != null ? launchPermissions.stream().map(LaunchPermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchPermissions(Collection<LaunchPermission> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copy(launchPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(LaunchPermission... launchPermissions) {
            launchPermissions(Arrays.asList(launchPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(Consumer<LaunchPermission.Builder>... launchPermissions) {
            launchPermissions(Stream.of(launchPermissions).map(c -> LaunchPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchPermissions(Collection<LaunchPermission.BuilderImpl> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copyFromBuilder(launchPermissions);
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return productCodes != null ? productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final AttributeValue.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        @Override
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        public final AttributeValue.Builder getKernelId() {
            return kernelId != null ? kernelId.toBuilder() : null;
        }

        @Override
        public final Builder kernelId(AttributeValue kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(AttributeValue.BuilderImpl kernelId) {
            this.kernelId = kernelId != null ? kernelId.build() : null;
        }

        public final AttributeValue.Builder getRamdiskId() {
            return ramdiskId != null ? ramdiskId.toBuilder() : null;
        }

        @Override
        public final Builder ramdiskId(AttributeValue ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(AttributeValue.BuilderImpl ramdiskId) {
            this.ramdiskId = ramdiskId != null ? ramdiskId.build() : null;
        }

        public final AttributeValue.Builder getSriovNetSupport() {
            return sriovNetSupport != null ? sriovNetSupport.toBuilder() : null;
        }

        @Override
        public final Builder sriovNetSupport(AttributeValue sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(AttributeValue.BuilderImpl sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport != null ? sriovNetSupport.build() : null;
        }

        @Override
        public DescribeImageAttributeResponse build() {
            return new DescribeImageAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
