/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<StartInstancesResponse.Builder, StartInstancesResponse> {
    private static final SdkField<List<InstanceStateChange>> STARTING_INSTANCES_FIELD = SdkField
            .<List<InstanceStateChange>> builder(MarshallingType.LIST)
            .getter(getter(StartInstancesResponse::startingInstances))
            .setter(setter(Builder::startingInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet")
                    .unmarshallLocationName("instancesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceStateChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceStateChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTING_INSTANCES_FIELD));

    private final List<InstanceStateChange> startingInstances;

    private StartInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.startingInstances = builder.startingInstances;
    }

    /**
     * Returns true if the StartingInstances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStartingInstances() {
        return startingInstances != null && !(startingInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the started instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStartingInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the started instances.
     */
    public List<InstanceStateChange> startingInstances() {
        return startingInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startingInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInstancesResponse)) {
            return false;
        }
        StartInstancesResponse other = (StartInstancesResponse) obj;
        return Objects.equals(startingInstances(), other.startingInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartInstancesResponse").add("StartingInstances", startingInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartingInstances":
            return Optional.ofNullable(clazz.cast(startingInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartInstancesResponse, T> g) {
        return obj -> g.apply((StartInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, StartInstancesResponse> {
        /**
         * <p>
         * Information about the started instances.
         * </p>
         * 
         * @param startingInstances
         *        Information about the started instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingInstances(Collection<InstanceStateChange> startingInstances);

        /**
         * <p>
         * Information about the started instances.
         * </p>
         * 
         * @param startingInstances
         *        Information about the started instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingInstances(InstanceStateChange... startingInstances);

        /**
         * <p>
         * Information about the started instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceStateChange>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceStateChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceStateChange>.Builder#build()} is called immediately
         * and its result is passed to {@link #startingInstances(List<InstanceStateChange>)}.
         * 
         * @param startingInstances
         *        a consumer that will call methods on {@link List<InstanceStateChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startingInstances(List<InstanceStateChange>)
         */
        Builder startingInstances(Consumer<InstanceStateChange.Builder>... startingInstances);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InstanceStateChange> startingInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartInstancesResponse model) {
            super(model);
            startingInstances(model.startingInstances);
        }

        public final Collection<InstanceStateChange.Builder> getStartingInstances() {
            return startingInstances != null ? startingInstances.stream().map(InstanceStateChange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder startingInstances(Collection<InstanceStateChange> startingInstances) {
            this.startingInstances = InstanceStateChangeListCopier.copy(startingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startingInstances(InstanceStateChange... startingInstances) {
            startingInstances(Arrays.asList(startingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startingInstances(Consumer<InstanceStateChange.Builder>... startingInstances) {
            startingInstances(Stream.of(startingInstances).map(c -> InstanceStateChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStartingInstances(Collection<InstanceStateChange.BuilderImpl> startingInstances) {
            this.startingInstances = InstanceStateChangeListCopier.copyFromBuilder(startingInstances);
        }

        @Override
        public StartInstancesResponse build() {
            return new StartInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
