/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStaleSecurityGroupsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeStaleSecurityGroupsResponse.Builder, DescribeStaleSecurityGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStaleSecurityGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<StaleSecurityGroup>> STALE_SECURITY_GROUP_SET_FIELD = SdkField
            .<List<StaleSecurityGroup>> builder(MarshallingType.LIST)
            .getter(getter(DescribeStaleSecurityGroupsResponse::staleSecurityGroupSet))
            .setter(setter(Builder::staleSecurityGroupSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaleSecurityGroupSet")
                    .unmarshallLocationName("staleSecurityGroupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<StaleSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(StaleSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STALE_SECURITY_GROUP_SET_FIELD));

    private final String nextToken;

    private final List<StaleSecurityGroup> staleSecurityGroupSet;

    private DescribeStaleSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.staleSecurityGroupSet = builder.staleSecurityGroupSet;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the StaleSecurityGroupSet property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStaleSecurityGroupSet() {
        return staleSecurityGroupSet != null && !(staleSecurityGroupSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the stale security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStaleSecurityGroupSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the stale security groups.
     */
    public List<StaleSecurityGroup> staleSecurityGroupSet() {
        return staleSecurityGroupSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(staleSecurityGroupSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStaleSecurityGroupsResponse)) {
            return false;
        }
        DescribeStaleSecurityGroupsResponse other = (DescribeStaleSecurityGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(staleSecurityGroupSet(), other.staleSecurityGroupSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeStaleSecurityGroupsResponse").add("NextToken", nextToken())
                .add("StaleSecurityGroupSet", staleSecurityGroupSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StaleSecurityGroupSet":
            return Optional.ofNullable(clazz.cast(staleSecurityGroupSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStaleSecurityGroupsResponse, T> g) {
        return obj -> g.apply((DescribeStaleSecurityGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStaleSecurityGroupsResponse> {
        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the stale security groups.
         * </p>
         * 
         * @param staleSecurityGroupSet
         *        Information about the stale security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleSecurityGroupSet(Collection<StaleSecurityGroup> staleSecurityGroupSet);

        /**
         * <p>
         * Information about the stale security groups.
         * </p>
         * 
         * @param staleSecurityGroupSet
         *        Information about the stale security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleSecurityGroupSet(StaleSecurityGroup... staleSecurityGroupSet);

        /**
         * <p>
         * Information about the stale security groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StaleSecurityGroup>.Builder} avoiding the
         * need to create one manually via {@link List<StaleSecurityGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StaleSecurityGroup>.Builder#build()} is called immediately
         * and its result is passed to {@link #staleSecurityGroupSet(List<StaleSecurityGroup>)}.
         * 
         * @param staleSecurityGroupSet
         *        a consumer that will call methods on {@link List<StaleSecurityGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staleSecurityGroupSet(List<StaleSecurityGroup>)
         */
        Builder staleSecurityGroupSet(Consumer<StaleSecurityGroup.Builder>... staleSecurityGroupSet);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<StaleSecurityGroup> staleSecurityGroupSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStaleSecurityGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            staleSecurityGroupSet(model.staleSecurityGroupSet);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<StaleSecurityGroup.Builder> getStaleSecurityGroupSet() {
            return staleSecurityGroupSet != null ? staleSecurityGroupSet.stream().map(StaleSecurityGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder staleSecurityGroupSet(Collection<StaleSecurityGroup> staleSecurityGroupSet) {
            this.staleSecurityGroupSet = StaleSecurityGroupSetCopier.copy(staleSecurityGroupSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleSecurityGroupSet(StaleSecurityGroup... staleSecurityGroupSet) {
            staleSecurityGroupSet(Arrays.asList(staleSecurityGroupSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleSecurityGroupSet(Consumer<StaleSecurityGroup.Builder>... staleSecurityGroupSet) {
            staleSecurityGroupSet(Stream.of(staleSecurityGroupSet)
                    .map(c -> StaleSecurityGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStaleSecurityGroupSet(Collection<StaleSecurityGroup.BuilderImpl> staleSecurityGroupSet) {
            this.staleSecurityGroupSet = StaleSecurityGroupSetCopier.copyFromBuilder(staleSecurityGroupSet);
        }

        @Override
        public DescribeStaleSecurityGroupsResponse build() {
            return new DescribeStaleSecurityGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
