/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDefaultCreditSpecificationRequest extends Ec2Request implements
        ToCopyableBuilder<GetDefaultCreditSpecificationRequest.Builder, GetDefaultCreditSpecificationRequest> {
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetDefaultCreditSpecificationRequest::instanceFamilyAsString))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily")
                    .unmarshallLocationName("InstanceFamily").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FAMILY_FIELD));

    private final String instanceFamily;

    private GetDefaultCreditSpecificationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceFamily = builder.instanceFamily;
    }

    /**
     * <p>
     * The instance family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceFamily}
     * will return {@link UnlimitedSupportedInstanceFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instanceFamilyAsString}.
     * </p>
     * 
     * @return The instance family.
     * @see UnlimitedSupportedInstanceFamily
     */
    public UnlimitedSupportedInstanceFamily instanceFamily() {
        return UnlimitedSupportedInstanceFamily.fromValue(instanceFamily);
    }

    /**
     * <p>
     * The instance family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceFamily}
     * will return {@link UnlimitedSupportedInstanceFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instanceFamilyAsString}.
     * </p>
     * 
     * @return The instance family.
     * @see UnlimitedSupportedInstanceFamily
     */
    public String instanceFamilyAsString() {
        return instanceFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamilyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDefaultCreditSpecificationRequest)) {
            return false;
        }
        GetDefaultCreditSpecificationRequest other = (GetDefaultCreditSpecificationRequest) obj;
        return Objects.equals(instanceFamilyAsString(), other.instanceFamilyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDefaultCreditSpecificationRequest").add("InstanceFamily", instanceFamilyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamilyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDefaultCreditSpecificationRequest, T> g) {
        return obj -> g.apply((GetDefaultCreditSpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetDefaultCreditSpecificationRequest> {
        /**
         * <p>
         * The instance family.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family.
         * @see UnlimitedSupportedInstanceFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlimitedSupportedInstanceFamily
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The instance family.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family.
         * @see UnlimitedSupportedInstanceFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnlimitedSupportedInstanceFamily
         */
        Builder instanceFamily(UnlimitedSupportedInstanceFamily instanceFamily);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String instanceFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDefaultCreditSpecificationRequest model) {
            super(model);
            instanceFamily(model.instanceFamily);
        }

        public final String getInstanceFamilyAsString() {
            return instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        @Override
        public final Builder instanceFamily(UnlimitedSupportedInstanceFamily instanceFamily) {
            this.instanceFamily(instanceFamily == null ? null : instanceFamily.toString());
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDefaultCreditSpecificationRequest build() {
            return new GetDefaultCreditSpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
