/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an EC2 Fleet that was not successfully deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFleetErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteFleetErrorItem.Builder, DeleteFleetErrorItem> {
    private static final SdkField<DeleteFleetError> ERROR_FIELD = SdkField
            .<DeleteFleetError> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteFleetErrorItem::error))
            .setter(setter(Builder::error))
            .constructor(DeleteFleetError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error")
                    .unmarshallLocationName("error").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteFleetErrorItem::fleetId))
            .setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId")
                    .unmarshallLocationName("fleetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, FLEET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final DeleteFleetError error;

    private final String fleetId;

    private DeleteFleetErrorItem(BuilderImpl builder) {
        this.error = builder.error;
        this.fleetId = builder.fleetId;
    }

    /**
     * <p>
     * The error.
     * </p>
     * 
     * @return The error.
     */
    public DeleteFleetError error() {
        return error;
    }

    /**
     * <p>
     * The ID of the EC2 Fleet.
     * </p>
     * 
     * @return The ID of the EC2 Fleet.
     */
    public String fleetId() {
        return fleetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetErrorItem)) {
            return false;
        }
        DeleteFleetErrorItem other = (DeleteFleetErrorItem) obj;
        return Objects.equals(error(), other.error()) && Objects.equals(fleetId(), other.fleetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteFleetErrorItem").add("Error", error()).add("FleetId", fleetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFleetErrorItem, T> g) {
        return obj -> g.apply((DeleteFleetErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteFleetErrorItem> {
        /**
         * <p>
         * The error.
         * </p>
         * 
         * @param error
         *        The error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(DeleteFleetError error);

        /**
         * <p>
         * The error.
         * </p>
         * This is a convenience that creates an instance of the {@link DeleteFleetError.Builder} avoiding the need to
         * create one manually via {@link DeleteFleetError#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeleteFleetError.Builder#build()} is called immediately and its
         * result is passed to {@link #error(DeleteFleetError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link DeleteFleetError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(DeleteFleetError)
         */
        default Builder error(Consumer<DeleteFleetError.Builder> error) {
            return error(DeleteFleetError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The ID of the EC2 Fleet.
         * </p>
         * 
         * @param fleetId
         *        The ID of the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);
    }

    static final class BuilderImpl implements Builder {
        private DeleteFleetError error;

        private String fleetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetErrorItem model) {
            error(model.error);
            fleetId(model.fleetId);
        }

        public final DeleteFleetError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        @Override
        public final Builder error(DeleteFleetError error) {
            this.error = error;
            return this;
        }

        public final void setError(DeleteFleetError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public DeleteFleetErrorItem build() {
            return new DeleteFleetErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
