/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a local gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalGateway implements SdkPojo, Serializable, ToCopyableBuilder<LocalGateway.Builder, LocalGateway> {
    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGateway::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("localGatewayId").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGateway::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGateway::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGateway::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_GATEWAY_ID_FIELD,
            OUTPOST_ARN_FIELD, OWNER_ID_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String localGatewayId;

    private final String outpostArn;

    private final String ownerId;

    private final String state;

    private LocalGateway(BuilderImpl builder) {
        this.localGatewayId = builder.localGatewayId;
        this.outpostArn = builder.outpostArn;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public String localGatewayId() {
        return localGatewayId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost.
     */
    public String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The ID of the AWS account ID that owns the local gateway.
     * </p>
     * 
     * @return The ID of the AWS account ID that owns the local gateway.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The state of the local gateway.
     * </p>
     * 
     * @return The state of the local gateway.
     */
    public String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGateway)) {
            return false;
        }
        LocalGateway other = (LocalGateway) obj;
        return Objects.equals(localGatewayId(), other.localGatewayId()) && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LocalGateway").add("LocalGatewayId", localGatewayId()).add("OutpostArn", outpostArn())
                .add("OwnerId", ownerId()).add("State", state()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalGateway, T> g) {
        return obj -> g.apply((LocalGateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalGateway> {
        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The ID of the AWS account ID that owns the local gateway.
         * </p>
         * 
         * @param ownerId
         *        The ID of the AWS account ID that owns the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The state of the local gateway.
         * </p>
         * 
         * @param state
         *        The state of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl implements Builder {
        private String localGatewayId;

        private String outpostArn;

        private String ownerId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGateway model) {
            localGatewayId(model.localGatewayId);
            outpostArn(model.outpostArn);
            ownerId(model.ownerId);
            state(model.state);
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public LocalGateway build() {
            return new LocalGateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
