/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteClientVpnRouteRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteClientVpnRouteRequest.Builder, DeleteClientVpnRouteRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteClientVpnRouteRequest::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("ClientVpnEndpointId").build()).build();

    private static final SdkField<String> TARGET_VPC_SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteClientVpnRouteRequest::targetVpcSubnetId))
            .setter(setter(Builder::targetVpcSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVpcSubnetId")
                    .unmarshallLocationName("TargetVpcSubnetId").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteClientVpnRouteRequest::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("DestinationCidrBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            TARGET_VPC_SUBNET_ID_FIELD, DESTINATION_CIDR_BLOCK_FIELD));

    private final String clientVpnEndpointId;

    private final String targetVpcSubnetId;

    private final String destinationCidrBlock;

    private DeleteClientVpnRouteRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.targetVpcSubnetId = builder.targetVpcSubnetId;
        this.destinationCidrBlock = builder.destinationCidrBlock;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint from which the route is to be deleted.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint from which the route is to be deleted.
     */
    public String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * The ID of the target subnet used by the route.
     * </p>
     * 
     * @return The ID of the target subnet used by the route.
     */
    public String targetVpcSubnetId() {
        return targetVpcSubnetId;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation, of the route to be deleted.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation, of the route to be deleted.
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(targetVpcSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClientVpnRouteRequest)) {
            return false;
        }
        DeleteClientVpnRouteRequest other = (DeleteClientVpnRouteRequest) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(targetVpcSubnetId(), other.targetVpcSubnetId())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteClientVpnRouteRequest").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("TargetVpcSubnetId", targetVpcSubnetId()).add("DestinationCidrBlock", destinationCidrBlock()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "TargetVpcSubnetId":
            return Optional.ofNullable(clazz.cast(targetVpcSubnetId()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteClientVpnRouteRequest, T> g) {
        return obj -> g.apply((DeleteClientVpnRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteClientVpnRouteRequest> {
        /**
         * <p>
         * The ID of the Client VPN endpoint from which the route is to be deleted.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint from which the route is to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * The ID of the target subnet used by the route.
         * </p>
         * 
         * @param targetVpcSubnetId
         *        The ID of the target subnet used by the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVpcSubnetId(String targetVpcSubnetId);

        /**
         * <p>
         * The IPv4 address range, in CIDR notation, of the route to be deleted.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The IPv4 address range, in CIDR notation, of the route to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String targetVpcSubnetId;

        private String destinationCidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClientVpnRouteRequest model) {
            super(model);
            clientVpnEndpointId(model.clientVpnEndpointId);
            targetVpcSubnetId(model.targetVpcSubnetId);
            destinationCidrBlock(model.destinationCidrBlock);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getTargetVpcSubnetId() {
            return targetVpcSubnetId;
        }

        @Override
        public final Builder targetVpcSubnetId(String targetVpcSubnetId) {
            this.targetVpcSubnetId = targetVpcSubnetId;
            return this;
        }

        public final void setTargetVpcSubnetId(String targetVpcSubnetId) {
            this.targetVpcSubnetId = targetVpcSubnetId;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteClientVpnRouteRequest build() {
            return new DeleteClientVpnRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
