/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceTypesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeInstanceTypesRequest.Builder, DescribeInstanceTypesRequest> {
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeInstanceTypesRequest::instanceTypesAsStrings))
            .setter(setter(Builder::instanceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeInstanceTypesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeInstanceTypesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInstanceTypesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPES_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> instanceTypes;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeInstanceTypesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceTypes = builder.instanceTypes;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The instance types. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The instance types. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public List<InstanceType> instanceTypes() {
        return RequestInstanceTypeListCopier.copyStringToEnum(instanceTypes);
    }

    /**
     * Returns true if the InstanceTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstanceTypes() {
        return instanceTypes != null && !(instanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance types. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The instance types. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public List<String> instanceTypesAsStrings() {
        return instanceTypes;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters. Filter names and values are case-sensitive.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>auto-recovery-supported</code> - Indicates whether auto recovery is supported. (<code>true</code> |
     * <code>false</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bare-metal</code> - Indicates whether it is a bare metal instance type. (<code>true</code> |
     * <code>false</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>burstable-performance-supported</code> - Indicates whether it is a burstable performance instance type. (
     * <code>true</code> | <code>false</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>current-generation</code> - Indicates whether this instance type is the latest generation instance type of
     * an instance family. (<code>true</code> | <code>false</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ebs-info.ebs-optimized-support</code> - Indicates whether the instance type is EBS-optimized. (
     * <code>true</code> | <code>false</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ebs-info.encryption-support</code> - Indicates whether EBS encryption is supported. (<code>true</code> |
     * <code>false</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>free-tier-eligible</code> - Indicates whether the instance type is eligible to use in the free tier. (
     * <code>true</code> | <code>false</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hibernation-supported</code> - Indicates whether On-Demand hibernation is supported. (<code>true</code> |
     * <code>false</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hypervisor</code> - The hypervisor used. (<code>nitro</code> | <code>xen</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-storage-info.disk.count</code> - The number of local disks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-storage-info.disk.size-in-gb</code> - The storage size of each instance storage disk, in GB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-storage-info.disk.type</code> - The storage technology for the local instance storage disks. (
     * <code>hdd</code> | <code>ssd</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-storage-info.total-size-in-gb</code> - The total amount of storage available from all local
     * instance storage, in GB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-storage-supported</code> - Indicates whether the instance type has local instance storage. (
     * <code>true</code> | <code>false</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>memory-info.size-in-mib</code> - The memory size.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-info.ena-support</code> - Indicates whether Elastic Network Adapter (ENA) is supported or required.
     * (<code>required</code> | <code>supported</code> | <code>unsupported</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-info.ipv4-addresses-per-interface</code> - The maximum number of private IPv4 addresses per network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-info.ipv6-addresses-per-interface</code> - The maximum number of private IPv6 addresses per network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-info.ipv6-supported</code> - Indicates whether the instance type supports IPv6. (<code>true</code>
     * | <code>false</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-info.maximum-network-interfaces</code> - The maximum number of network interfaces per instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-info.network-performance</code> - Describes the network performance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>processor-info.sustained-clock-speed-in-ghz</code> - The CPU clock speed, in GHz.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vcpu-info.default-cores</code> - The default number of cores for the instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vcpu-info.default-threads-per-core</code> - The default number of threads per cores for the instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vcpu-info.default-vcpus</code> - The default number of vCPUs for the instance type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters. Filter names and values are case-sensitive.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>auto-recovery-supported</code> - Indicates whether auto recovery is supported. (<code>true</code> |
     *         <code>false</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bare-metal</code> - Indicates whether it is a bare metal instance type. (<code>true</code> |
     *         <code>false</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>burstable-performance-supported</code> - Indicates whether it is a burstable performance instance
     *         type. (<code>true</code> | <code>false</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>current-generation</code> - Indicates whether this instance type is the latest generation instance
     *         type of an instance family. (<code>true</code> | <code>false</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ebs-info.ebs-optimized-support</code> - Indicates whether the instance type is EBS-optimized. (
     *         <code>true</code> | <code>false</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ebs-info.encryption-support</code> - Indicates whether EBS encryption is supported. (
     *         <code>true</code> | <code>false</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>free-tier-eligible</code> - Indicates whether the instance type is eligible to use in the free
     *         tier. (<code>true</code> | <code>false</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hibernation-supported</code> - Indicates whether On-Demand hibernation is supported. (
     *         <code>true</code> | <code>false</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hypervisor</code> - The hypervisor used. (<code>nitro</code> | <code>xen</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-storage-info.disk.count</code> - The number of local disks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-storage-info.disk.size-in-gb</code> - The storage size of each instance storage disk, in
     *         GB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-storage-info.disk.type</code> - The storage technology for the local instance storage
     *         disks. (<code>hdd</code> | <code>ssd</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-storage-info.total-size-in-gb</code> - The total amount of storage available from all
     *         local instance storage, in GB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-storage-supported</code> - Indicates whether the instance type has local instance storage.
     *         (<code>true</code> | <code>false</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>memory-info.size-in-mib</code> - The memory size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-info.ena-support</code> - Indicates whether Elastic Network Adapter (ENA) is supported or
     *         required. (<code>required</code> | <code>supported</code> | <code>unsupported</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-info.ipv4-addresses-per-interface</code> - The maximum number of private IPv4 addresses per
     *         network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-info.ipv6-addresses-per-interface</code> - The maximum number of private IPv6 addresses per
     *         network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-info.ipv6-supported</code> - Indicates whether the instance type supports IPv6. (
     *         <code>true</code> | <code>false</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-info.maximum-network-interfaces</code> - The maximum number of network interfaces per
     *         instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-info.network-performance</code> - Describes the network performance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>processor-info.sustained-clock-speed-in-ghz</code> - The CPU clock speed, in GHz.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vcpu-info.default-cores</code> - The default number of cores for the instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vcpu-info.default-threads-per-core</code> - The default number of threads per cores for the
     *         instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vcpu-info.default-vcpus</code> - The default number of vCPUs for the instance type.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the next token value.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the next token value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceTypesRequest)) {
            return false;
        }
        DescribeInstanceTypesRequest other = (DescribeInstanceTypesRequest) obj;
        return Objects.equals(instanceTypesAsStrings(), other.instanceTypesAsStrings())
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeInstanceTypesRequest").add("InstanceTypes", instanceTypesAsStrings())
                .add("Filters", filters()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceTypes":
            return Optional.ofNullable(clazz.cast(instanceTypesAsStrings()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceTypesRequest, T> g) {
        return obj -> g.apply((DescribeInstanceTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstanceTypesRequest> {
        /**
         * <p>
         * The instance types. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceTypes
         *        The instance types. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypesWithStrings(Collection<String> instanceTypes);

        /**
         * <p>
         * The instance types. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceTypes
         *        The instance types. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypesWithStrings(String... instanceTypes);

        /**
         * <p>
         * The instance types. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceTypes
         *        The instance types. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<InstanceType> instanceTypes);

        /**
         * <p>
         * The instance types. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceTypes
         *        The instance types. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(InstanceType... instanceTypes);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>auto-recovery-supported</code> - Indicates whether auto recovery is supported. (<code>true</code> |
         * <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bare-metal</code> - Indicates whether it is a bare metal instance type. (<code>true</code> |
         * <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>burstable-performance-supported</code> - Indicates whether it is a burstable performance instance type.
         * (<code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>current-generation</code> - Indicates whether this instance type is the latest generation instance type
         * of an instance family. (<code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-info.ebs-optimized-support</code> - Indicates whether the instance type is EBS-optimized. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-info.encryption-support</code> - Indicates whether EBS encryption is supported. (<code>true</code>
         * | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>free-tier-eligible</code> - Indicates whether the instance type is eligible to use in the free tier. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hibernation-supported</code> - Indicates whether On-Demand hibernation is supported. (<code>true</code>
         * | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor used. (<code>nitro</code> | <code>xen</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.disk.count</code> - The number of local disks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.disk.size-in-gb</code> - The storage size of each instance storage disk, in GB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.disk.type</code> - The storage technology for the local instance storage disks. (
         * <code>hdd</code> | <code>ssd</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.total-size-in-gb</code> - The total amount of storage available from all local
         * instance storage, in GB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-supported</code> - Indicates whether the instance type has local instance storage. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>memory-info.size-in-mib</code> - The memory size.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ena-support</code> - Indicates whether Elastic Network Adapter (ENA) is supported or
         * required. (<code>required</code> | <code>supported</code> | <code>unsupported</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ipv4-addresses-per-interface</code> - The maximum number of private IPv4 addresses per
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ipv6-addresses-per-interface</code> - The maximum number of private IPv6 addresses per
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ipv6-supported</code> - Indicates whether the instance type supports IPv6. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.maximum-network-interfaces</code> - The maximum number of network interfaces per instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.network-performance</code> - Describes the network performance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>processor-info.sustained-clock-speed-in-ghz</code> - The CPU clock speed, in GHz.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vcpu-info.default-cores</code> - The default number of cores for the instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vcpu-info.default-threads-per-core</code> - The default number of threads per cores for the instance
         * type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vcpu-info.default-vcpus</code> - The default number of vCPUs for the instance type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>auto-recovery-supported</code> - Indicates whether auto recovery is supported. (
         *        <code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bare-metal</code> - Indicates whether it is a bare metal instance type. (<code>true</code> |
         *        <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>burstable-performance-supported</code> - Indicates whether it is a burstable performance
         *        instance type. (<code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>current-generation</code> - Indicates whether this instance type is the latest generation
         *        instance type of an instance family. (<code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ebs-info.ebs-optimized-support</code> - Indicates whether the instance type is EBS-optimized. (
         *        <code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ebs-info.encryption-support</code> - Indicates whether EBS encryption is supported. (
         *        <code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>free-tier-eligible</code> - Indicates whether the instance type is eligible to use in the free
         *        tier. (<code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hibernation-supported</code> - Indicates whether On-Demand hibernation is supported. (
         *        <code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor used. (<code>nitro</code> | <code>xen</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-storage-info.disk.count</code> - The number of local disks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-storage-info.disk.size-in-gb</code> - The storage size of each instance storage disk,
         *        in GB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-storage-info.disk.type</code> - The storage technology for the local instance storage
         *        disks. (<code>hdd</code> | <code>ssd</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-storage-info.total-size-in-gb</code> - The total amount of storage available from all
         *        local instance storage, in GB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-storage-supported</code> - Indicates whether the instance type has local instance
         *        storage. (<code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>memory-info.size-in-mib</code> - The memory size.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.ena-support</code> - Indicates whether Elastic Network Adapter (ENA) is supported
         *        or required. (<code>required</code> | <code>supported</code> | <code>unsupported</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.ipv4-addresses-per-interface</code> - The maximum number of private IPv4 addresses
         *        per network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.ipv6-addresses-per-interface</code> - The maximum number of private IPv6 addresses
         *        per network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.ipv6-supported</code> - Indicates whether the instance type supports IPv6. (
         *        <code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.maximum-network-interfaces</code> - The maximum number of network interfaces per
         *        instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.network-performance</code> - Describes the network performance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>processor-info.sustained-clock-speed-in-ghz</code> - The CPU clock speed, in GHz.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vcpu-info.default-cores</code> - The default number of cores for the instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vcpu-info.default-threads-per-core</code> - The default number of threads per cores for the
         *        instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vcpu-info.default-vcpus</code> - The default number of vCPUs for the instance type.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>auto-recovery-supported</code> - Indicates whether auto recovery is supported. (<code>true</code> |
         * <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bare-metal</code> - Indicates whether it is a bare metal instance type. (<code>true</code> |
         * <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>burstable-performance-supported</code> - Indicates whether it is a burstable performance instance type.
         * (<code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>current-generation</code> - Indicates whether this instance type is the latest generation instance type
         * of an instance family. (<code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-info.ebs-optimized-support</code> - Indicates whether the instance type is EBS-optimized. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-info.encryption-support</code> - Indicates whether EBS encryption is supported. (<code>true</code>
         * | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>free-tier-eligible</code> - Indicates whether the instance type is eligible to use in the free tier. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hibernation-supported</code> - Indicates whether On-Demand hibernation is supported. (<code>true</code>
         * | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor used. (<code>nitro</code> | <code>xen</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.disk.count</code> - The number of local disks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.disk.size-in-gb</code> - The storage size of each instance storage disk, in GB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.disk.type</code> - The storage technology for the local instance storage disks. (
         * <code>hdd</code> | <code>ssd</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.total-size-in-gb</code> - The total amount of storage available from all local
         * instance storage, in GB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-supported</code> - Indicates whether the instance type has local instance storage. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>memory-info.size-in-mib</code> - The memory size.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ena-support</code> - Indicates whether Elastic Network Adapter (ENA) is supported or
         * required. (<code>required</code> | <code>supported</code> | <code>unsupported</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ipv4-addresses-per-interface</code> - The maximum number of private IPv4 addresses per
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ipv6-addresses-per-interface</code> - The maximum number of private IPv6 addresses per
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ipv6-supported</code> - Indicates whether the instance type supports IPv6. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.maximum-network-interfaces</code> - The maximum number of network interfaces per instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.network-performance</code> - Describes the network performance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>processor-info.sustained-clock-speed-in-ghz</code> - The CPU clock speed, in GHz.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vcpu-info.default-cores</code> - The default number of cores for the instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vcpu-info.default-threads-per-core</code> - The default number of threads per cores for the instance
         * type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vcpu-info.default-vcpus</code> - The default number of vCPUs for the instance type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. Filter names and values are case-sensitive.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>auto-recovery-supported</code> - Indicates whether auto recovery is supported. (
         *        <code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bare-metal</code> - Indicates whether it is a bare metal instance type. (<code>true</code> |
         *        <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>burstable-performance-supported</code> - Indicates whether it is a burstable performance
         *        instance type. (<code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>current-generation</code> - Indicates whether this instance type is the latest generation
         *        instance type of an instance family. (<code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ebs-info.ebs-optimized-support</code> - Indicates whether the instance type is EBS-optimized. (
         *        <code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ebs-info.encryption-support</code> - Indicates whether EBS encryption is supported. (
         *        <code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>free-tier-eligible</code> - Indicates whether the instance type is eligible to use in the free
         *        tier. (<code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hibernation-supported</code> - Indicates whether On-Demand hibernation is supported. (
         *        <code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor used. (<code>nitro</code> | <code>xen</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-storage-info.disk.count</code> - The number of local disks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-storage-info.disk.size-in-gb</code> - The storage size of each instance storage disk,
         *        in GB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-storage-info.disk.type</code> - The storage technology for the local instance storage
         *        disks. (<code>hdd</code> | <code>ssd</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-storage-info.total-size-in-gb</code> - The total amount of storage available from all
         *        local instance storage, in GB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-storage-supported</code> - Indicates whether the instance type has local instance
         *        storage. (<code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>memory-info.size-in-mib</code> - The memory size.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.ena-support</code> - Indicates whether Elastic Network Adapter (ENA) is supported
         *        or required. (<code>required</code> | <code>supported</code> | <code>unsupported</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.ipv4-addresses-per-interface</code> - The maximum number of private IPv4 addresses
         *        per network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.ipv6-addresses-per-interface</code> - The maximum number of private IPv6 addresses
         *        per network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.ipv6-supported</code> - Indicates whether the instance type supports IPv6. (
         *        <code>true</code> | <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.maximum-network-interfaces</code> - The maximum number of network interfaces per
         *        instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-info.network-performance</code> - Describes the network performance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>processor-info.sustained-clock-speed-in-ghz</code> - The CPU clock speed, in GHz.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vcpu-info.default-cores</code> - The default number of cores for the instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vcpu-info.default-threads-per-core</code> - The default number of threads per cores for the
         *        instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vcpu-info.default-vcpus</code> - The default number of vCPUs for the instance type.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters. Filter names and values are case-sensitive.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>auto-recovery-supported</code> - Indicates whether auto recovery is supported. (<code>true</code> |
         * <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bare-metal</code> - Indicates whether it is a bare metal instance type. (<code>true</code> |
         * <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>burstable-performance-supported</code> - Indicates whether it is a burstable performance instance type.
         * (<code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>current-generation</code> - Indicates whether this instance type is the latest generation instance type
         * of an instance family. (<code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-info.ebs-optimized-support</code> - Indicates whether the instance type is EBS-optimized. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-info.encryption-support</code> - Indicates whether EBS encryption is supported. (<code>true</code>
         * | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>free-tier-eligible</code> - Indicates whether the instance type is eligible to use in the free tier. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hibernation-supported</code> - Indicates whether On-Demand hibernation is supported. (<code>true</code>
         * | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor used. (<code>nitro</code> | <code>xen</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.disk.count</code> - The number of local disks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.disk.size-in-gb</code> - The storage size of each instance storage disk, in GB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.disk.type</code> - The storage technology for the local instance storage disks. (
         * <code>hdd</code> | <code>ssd</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-info.total-size-in-gb</code> - The total amount of storage available from all local
         * instance storage, in GB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-storage-supported</code> - Indicates whether the instance type has local instance storage. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>memory-info.size-in-mib</code> - The memory size.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ena-support</code> - Indicates whether Elastic Network Adapter (ENA) is supported or
         * required. (<code>required</code> | <code>supported</code> | <code>unsupported</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ipv4-addresses-per-interface</code> - The maximum number of private IPv4 addresses per
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ipv6-addresses-per-interface</code> - The maximum number of private IPv6 addresses per
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.ipv6-supported</code> - Indicates whether the instance type supports IPv6. (
         * <code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.maximum-network-interfaces</code> - The maximum number of network interfaces per instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-info.network-performance</code> - Describes the network performance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>processor-info.sustained-clock-speed-in-ghz</code> - The CPU clock speed, in GHz.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vcpu-info.default-cores</code> - The default number of cores for the instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vcpu-info.default-threads-per-core</code> - The default number of threads per cores for the instance
         * type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vcpu-info.default-vcpus</code> - The default number of vCPUs for the instance type.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the next token value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the next token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceTypesRequest model) {
            super(model);
            instanceTypesWithStrings(model.instanceTypes);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getInstanceTypesAsStrings() {
            return instanceTypes;
        }

        @Override
        public final Builder instanceTypesWithStrings(Collection<String> instanceTypes) {
            this.instanceTypes = RequestInstanceTypeListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypesWithStrings(String... instanceTypes) {
            instanceTypesWithStrings(Arrays.asList(instanceTypes));
            return this;
        }

        @Override
        public final Builder instanceTypes(Collection<InstanceType> instanceTypes) {
            this.instanceTypes = RequestInstanceTypeListCopier.copyEnumToString(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(InstanceType... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypesWithStrings(Collection<String> instanceTypes) {
            this.instanceTypes = RequestInstanceTypeListCopier.copy(instanceTypes);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstanceTypesRequest build() {
            return new DescribeInstanceTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
