/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLaunchTemplateVersionsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeLaunchTemplateVersionsRequest.Builder, DescribeLaunchTemplateVersionsRequest> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLaunchTemplateVersionsRequest::launchTemplateId))
            .setter(setter(Builder::launchTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateId")
                    .unmarshallLocationName("LaunchTemplateId").build()).build();

    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLaunchTemplateVersionsRequest::launchTemplateName))
            .setter(setter(Builder::launchTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName")
                    .unmarshallLocationName("LaunchTemplateName").build()).build();

    private static final SdkField<List<String>> VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeLaunchTemplateVersionsRequest::versions))
            .setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateVersion")
                    .unmarshallLocationName("LaunchTemplateVersion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> MIN_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLaunchTemplateVersionsRequest::minVersion))
            .setter(setter(Builder::minVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinVersion")
                    .unmarshallLocationName("MinVersion").build()).build();

    private static final SdkField<String> MAX_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLaunchTemplateVersionsRequest::maxVersion))
            .setter(setter(Builder::maxVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxVersion")
                    .unmarshallLocationName("MaxVersion").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLaunchTemplateVersionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeLaunchTemplateVersionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeLaunchTemplateVersionsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD,
            LAUNCH_TEMPLATE_NAME_FIELD, VERSIONS_FIELD, MIN_VERSION_FIELD, MAX_VERSION_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, FILTERS_FIELD));

    private final String launchTemplateId;

    private final String launchTemplateName;

    private final List<String> versions;

    private final String minVersion;

    private final String maxVersion;

    private final String nextToken;

    private final Integer maxResults;

    private final List<Filter> filters;

    private DescribeLaunchTemplateVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.versions = builder.versions;
        this.minVersion = builder.minVersion;
        this.maxVersion = builder.maxVersion;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The ID of the launch template. You must specify either the launch template ID or launch template name in the
     * request.
     * </p>
     * 
     * @return The ID of the launch template. You must specify either the launch template ID or launch template name in
     *         the request.
     */
    public String launchTemplateId() {
        return launchTemplateId;
    }

    /**
     * <p>
     * The name of the launch template. You must specify either the launch template ID or launch template name in the
     * request.
     * </p>
     * 
     * @return The name of the launch template. You must specify either the launch template ID or launch template name
     *         in the request.
     */
    public String launchTemplateName() {
        return launchTemplateName;
    }

    /**
     * Returns true if the Versions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVersions() {
        return versions != null && !(versions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more versions of the launch template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more versions of the launch template.
     */
    public List<String> versions() {
        return versions;
    }

    /**
     * <p>
     * The version number after which to describe launch template versions.
     * </p>
     * 
     * @return The version number after which to describe launch template versions.
     */
    public String minVersion() {
        return minVersion;
    }

    /**
     * <p>
     * The version number up to which to describe launch template versions.
     * </p>
     * 
     * @return The version number up to which to describe launch template versions.
     */
    public String maxVersion() {
        return maxVersion;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>NextToken</code> value. This value can be between 1 and 200.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <code>NextToken</code> value. This value can be between 1 and 200.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>create-time</code> - The time the launch template version was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ebs-optimized</code> - A boolean that indicates whether the instance is optimized for Amazon EBS I/O.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>iam-instance-profile</code> - The ARN of the IAM instance profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>image-id</code> - The ID of the AMI.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>is-default-version</code> - A boolean that indicates whether the launch template version is the default
     * version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kernel-id</code> - The kernel ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ram-disk-id</code> - The RAM disk ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>create-time</code> - The time the launch template version was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ebs-optimized</code> - A boolean that indicates whether the instance is optimized for Amazon EBS
     *         I/O.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>iam-instance-profile</code> - The ARN of the IAM instance profile.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>image-id</code> - The ID of the AMI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>is-default-version</code> - A boolean that indicates whether the launch template version is the
     *         default version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kernel-id</code> - The kernel ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ram-disk-id</code> - The RAM disk ID.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(versions());
        hashCode = 31 * hashCode + Objects.hashCode(minVersion());
        hashCode = 31 * hashCode + Objects.hashCode(maxVersion());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchTemplateVersionsRequest)) {
            return false;
        }
        DescribeLaunchTemplateVersionsRequest other = (DescribeLaunchTemplateVersionsRequest) obj;
        return Objects.equals(launchTemplateId(), other.launchTemplateId())
                && Objects.equals(launchTemplateName(), other.launchTemplateName())
                && Objects.equals(versions(), other.versions()) && Objects.equals(minVersion(), other.minVersion())
                && Objects.equals(maxVersion(), other.maxVersion()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLaunchTemplateVersionsRequest").add("LaunchTemplateId", launchTemplateId())
                .add("LaunchTemplateName", launchTemplateName()).add("Versions", versions()).add("MinVersion", minVersion())
                .add("MaxVersion", maxVersion()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Filters", filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateId":
            return Optional.ofNullable(clazz.cast(launchTemplateId()));
        case "LaunchTemplateName":
            return Optional.ofNullable(clazz.cast(launchTemplateName()));
        case "Versions":
            return Optional.ofNullable(clazz.cast(versions()));
        case "MinVersion":
            return Optional.ofNullable(clazz.cast(minVersion()));
        case "MaxVersion":
            return Optional.ofNullable(clazz.cast(maxVersion()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLaunchTemplateVersionsRequest, T> g) {
        return obj -> g.apply((DescribeLaunchTemplateVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLaunchTemplateVersionsRequest> {
        /**
         * <p>
         * The ID of the launch template. You must specify either the launch template ID or launch template name in the
         * request.
         * </p>
         * 
         * @param launchTemplateId
         *        The ID of the launch template. You must specify either the launch template ID or launch template name
         *        in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateId(String launchTemplateId);

        /**
         * <p>
         * The name of the launch template. You must specify either the launch template ID or launch template name in
         * the request.
         * </p>
         * 
         * @param launchTemplateName
         *        The name of the launch template. You must specify either the launch template ID or launch template
         *        name in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateName(String launchTemplateName);

        /**
         * <p>
         * One or more versions of the launch template.
         * </p>
         * 
         * @param versions
         *        One or more versions of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<String> versions);

        /**
         * <p>
         * One or more versions of the launch template.
         * </p>
         * 
         * @param versions
         *        One or more versions of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(String... versions);

        /**
         * <p>
         * The version number after which to describe launch template versions.
         * </p>
         * 
         * @param minVersion
         *        The version number after which to describe launch template versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minVersion(String minVersion);

        /**
         * <p>
         * The version number up to which to describe launch template versions.
         * </p>
         * 
         * @param maxVersion
         *        The version number up to which to describe launch template versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxVersion(String maxVersion);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned <code>NextToken</code> value. This value can be between 1 and 200.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned <code>NextToken</code> value. This value can be between 1 and 200.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>create-time</code> - The time the launch template version was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-optimized</code> - A boolean that indicates whether the instance is optimized for Amazon EBS I/O.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile</code> - The ARN of the IAM instance profile.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>is-default-version</code> - A boolean that indicates whether the launch template version is the default
         * version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ram-disk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The time the launch template version was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ebs-optimized</code> - A boolean that indicates whether the instance is optimized for Amazon EBS
         *        I/O.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-instance-profile</code> - The ARN of the IAM instance profile.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the AMI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>is-default-version</code> - A boolean that indicates whether the launch template version is the
         *        default version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ram-disk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>create-time</code> - The time the launch template version was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-optimized</code> - A boolean that indicates whether the instance is optimized for Amazon EBS I/O.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile</code> - The ARN of the IAM instance profile.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>is-default-version</code> - A boolean that indicates whether the launch template version is the default
         * version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ram-disk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The time the launch template version was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ebs-optimized</code> - A boolean that indicates whether the instance is optimized for Amazon EBS
         *        I/O.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-instance-profile</code> - The ARN of the IAM instance profile.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the AMI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>is-default-version</code> - A boolean that indicates whether the launch template version is the
         *        default version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ram-disk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>create-time</code> - The time the launch template version was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-optimized</code> - A boolean that indicates whether the instance is optimized for Amazon EBS I/O.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile</code> - The ARN of the IAM instance profile.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>is-default-version</code> - A boolean that indicates whether the launch template version is the default
         * version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ram-disk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String launchTemplateId;

        private String launchTemplateName;

        private List<String> versions = DefaultSdkAutoConstructList.getInstance();

        private String minVersion;

        private String maxVersion;

        private String nextToken;

        private Integer maxResults;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchTemplateVersionsRequest model) {
            super(model);
            launchTemplateId(model.launchTemplateId);
            launchTemplateName(model.launchTemplateName);
            versions(model.versions);
            minVersion(model.minVersion);
            maxVersion(model.maxVersion);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
        }

        public final String getLaunchTemplateId() {
            return launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        public final String getLaunchTemplateName() {
            return launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        public final Collection<String> getVersions() {
            return versions;
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = VersionStringListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = VersionStringListCopier.copy(versions);
        }

        public final String getMinVersion() {
            return minVersion;
        }

        @Override
        public final Builder minVersion(String minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        public final void setMinVersion(String minVersion) {
            this.minVersion = minVersion;
        }

        public final String getMaxVersion() {
            return maxVersion;
        }

        @Override
        public final Builder maxVersion(String maxVersion) {
            this.maxVersion = maxVersion;
            return this;
        }

        public final void setMaxVersion(String maxVersion) {
            this.maxVersion = maxVersion;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLaunchTemplateVersionsRequest build() {
            return new DescribeLaunchTemplateVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
