/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance's Capacity Reservation targeting option. You can specify only one parameter at a time. If you
 * specify <code>CapacityReservationPreference</code> and <code>CapacityReservationTarget</code>, the request fails.
 * </p>
 * <p>
 * Use the <code>CapacityReservationPreference</code> parameter to configure the instance to run as an On-Demand
 * Instance or to run in any <code>open</code> Capacity Reservation that has matching attributes (instance type,
 * platform, Availability Zone). Use the <code>CapacityReservationTarget</code> parameter to explicitly target a
 * specific Capacity Reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservationSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservationSpecification.Builder, CapacityReservationSpecification> {
    private static final SdkField<String> CAPACITY_RESERVATION_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CapacityReservationSpecification::capacityReservationPreferenceAsString))
            .setter(setter(Builder::capacityReservationPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationPreference")
                    .unmarshallLocationName("CapacityReservationPreference").build()).build();

    private static final SdkField<CapacityReservationTarget> CAPACITY_RESERVATION_TARGET_FIELD = SdkField
            .<CapacityReservationTarget> builder(MarshallingType.SDK_POJO)
            .getter(getter(CapacityReservationSpecification::capacityReservationTarget))
            .setter(setter(Builder::capacityReservationTarget))
            .constructor(CapacityReservationTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationTarget")
                    .unmarshallLocationName("CapacityReservationTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_RESERVATION_PREFERENCE_FIELD, CAPACITY_RESERVATION_TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String capacityReservationPreference;

    private final CapacityReservationTarget capacityReservationTarget;

    private CapacityReservationSpecification(BuilderImpl builder) {
        this.capacityReservationPreference = builder.capacityReservationPreference;
        this.capacityReservationTarget = builder.capacityReservationTarget;
    }

    /**
     * <p>
     * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
     * attributes (instance type, platform, Availability Zone).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance
     * runs as an On-Demand Instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityReservationPreference} will return {@link CapacityReservationPreference#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityReservationPreferenceAsString}.
     * </p>
     * 
     * @return Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
     *         attributes (instance type, platform, Availability Zone).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
     *         instance runs as an On-Demand Instance.
     *         </p>
     *         </li>
     * @see CapacityReservationPreference
     */
    public CapacityReservationPreference capacityReservationPreference() {
        return CapacityReservationPreference.fromValue(capacityReservationPreference);
    }

    /**
     * <p>
     * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
     * attributes (instance type, platform, Availability Zone).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance
     * runs as an On-Demand Instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityReservationPreference} will return {@link CapacityReservationPreference#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #capacityReservationPreferenceAsString}.
     * </p>
     * 
     * @return Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
     *         attributes (instance type, platform, Availability Zone).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
     *         instance runs as an On-Demand Instance.
     *         </p>
     *         </li>
     * @see CapacityReservationPreference
     */
    public String capacityReservationPreferenceAsString() {
        return capacityReservationPreference;
    }

    /**
     * <p>
     * Information about the target Capacity Reservation.
     * </p>
     * 
     * @return Information about the target Capacity Reservation.
     */
    public CapacityReservationTarget capacityReservationTarget() {
        return capacityReservationTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationTarget());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationSpecification)) {
            return false;
        }
        CapacityReservationSpecification other = (CapacityReservationSpecification) obj;
        return Objects.equals(capacityReservationPreferenceAsString(), other.capacityReservationPreferenceAsString())
                && Objects.equals(capacityReservationTarget(), other.capacityReservationTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CapacityReservationSpecification")
                .add("CapacityReservationPreference", capacityReservationPreferenceAsString())
                .add("CapacityReservationTarget", capacityReservationTarget()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationPreference":
            return Optional.ofNullable(clazz.cast(capacityReservationPreferenceAsString()));
        case "CapacityReservationTarget":
            return Optional.ofNullable(clazz.cast(capacityReservationTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationSpecification, T> g) {
        return obj -> g.apply((CapacityReservationSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservationSpecification> {
        /**
         * <p>
         * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
         * attributes (instance type, platform, Availability Zone).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
         * instance runs as an On-Demand Instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityReservationPreference
         *        Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has
         *        matching attributes (instance type, platform, Availability Zone).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available.
         *        The instance runs as an On-Demand Instance.
         *        </p>
         *        </li>
         * @see CapacityReservationPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationPreference
         */
        Builder capacityReservationPreference(String capacityReservationPreference);

        /**
         * <p>
         * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching
         * attributes (instance type, platform, Availability Zone).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The
         * instance runs as an On-Demand Instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capacityReservationPreference
         *        Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has
         *        matching attributes (instance type, platform, Availability Zone).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available.
         *        The instance runs as an On-Demand Instance.
         *        </p>
         *        </li>
         * @see CapacityReservationPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationPreference
         */
        Builder capacityReservationPreference(CapacityReservationPreference capacityReservationPreference);

        /**
         * <p>
         * Information about the target Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationTarget
         *        Information about the target Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationTarget(CapacityReservationTarget capacityReservationTarget);

        /**
         * <p>
         * Information about the target Capacity Reservation.
         * </p>
         * This is a convenience that creates an instance of the {@link CapacityReservationTarget.Builder} avoiding the
         * need to create one manually via {@link CapacityReservationTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link CapacityReservationTarget.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityReservationTarget(CapacityReservationTarget)}.
         * 
         * @param capacityReservationTarget
         *        a consumer that will call methods on {@link CapacityReservationTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationTarget(CapacityReservationTarget)
         */
        default Builder capacityReservationTarget(Consumer<CapacityReservationTarget.Builder> capacityReservationTarget) {
            return capacityReservationTarget(CapacityReservationTarget.builder().applyMutation(capacityReservationTarget).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationPreference;

        private CapacityReservationTarget capacityReservationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationSpecification model) {
            capacityReservationPreference(model.capacityReservationPreference);
            capacityReservationTarget(model.capacityReservationTarget);
        }

        public final String getCapacityReservationPreferenceAsString() {
            return capacityReservationPreference;
        }

        @Override
        public final Builder capacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
            return this;
        }

        @Override
        public final Builder capacityReservationPreference(CapacityReservationPreference capacityReservationPreference) {
            this.capacityReservationPreference(capacityReservationPreference == null ? null : capacityReservationPreference
                    .toString());
            return this;
        }

        public final void setCapacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
        }

        public final CapacityReservationTarget.Builder getCapacityReservationTarget() {
            return capacityReservationTarget != null ? capacityReservationTarget.toBuilder() : null;
        }

        @Override
        public final Builder capacityReservationTarget(CapacityReservationTarget capacityReservationTarget) {
            this.capacityReservationTarget = capacityReservationTarget;
            return this;
        }

        public final void setCapacityReservationTarget(CapacityReservationTarget.BuilderImpl capacityReservationTarget) {
            this.capacityReservationTarget = capacityReservationTarget != null ? capacityReservationTarget.build() : null;
        }

        @Override
        public CapacityReservationSpecification build() {
            return new CapacityReservationSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
