/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information to include in the launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestLaunchTemplateData implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestLaunchTemplateData.Builder, RequestLaunchTemplateData> {
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RequestLaunchTemplateData::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("KernelId").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RequestLaunchTemplateData::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("EbsOptimized").build()).build();

    private static final SdkField<LaunchTemplateIamInstanceProfileSpecificationRequest> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<LaunchTemplateIamInstanceProfileSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(RequestLaunchTemplateData::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile))
            .constructor(LaunchTemplateIamInstanceProfileSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile")
                    .unmarshallLocationName("IamInstanceProfile").build()).build();

    private static final SdkField<List<LaunchTemplateBlockDeviceMappingRequest>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<LaunchTemplateBlockDeviceMappingRequest>> builder(MarshallingType.LIST)
            .getter(getter(RequestLaunchTemplateData::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("BlockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("BlockDeviceMapping")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateBlockDeviceMappingRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateBlockDeviceMappingRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("BlockDeviceMapping")
                                                    .unmarshallLocationName("BlockDeviceMapping").build()).build()).build())
            .build();

    private static final SdkField<List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>> builder(MarshallingType.LIST)
            .getter(getter(RequestLaunchTemplateData::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface")
                    .unmarshallLocationName("NetworkInterface").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("InstanceNetworkInterfaceSpecification")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("InstanceNetworkInterfaceSpecification")
                                                    .unmarshallLocationName("InstanceNetworkInterfaceSpecification").build())
                                            .build()).build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RequestLaunchTemplateData::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RequestLaunchTemplateData::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RequestLaunchTemplateData::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("KeyName").build()).build();

    private static final SdkField<LaunchTemplatesMonitoringRequest> MONITORING_FIELD = SdkField
            .<LaunchTemplatesMonitoringRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(RequestLaunchTemplateData::monitoring))
            .setter(setter(Builder::monitoring))
            .constructor(LaunchTemplatesMonitoringRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring")
                    .unmarshallLocationName("Monitoring").build()).build();

    private static final SdkField<LaunchTemplatePlacementRequest> PLACEMENT_FIELD = SdkField
            .<LaunchTemplatePlacementRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(RequestLaunchTemplateData::placement))
            .setter(setter(Builder::placement))
            .constructor(LaunchTemplatePlacementRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement")
                    .unmarshallLocationName("Placement").build()).build();

    private static final SdkField<String> RAM_DISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RequestLaunchTemplateData::ramDiskId))
            .setter(setter(Builder::ramDiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamDiskId")
                    .unmarshallLocationName("RamDiskId").build()).build();

    private static final SdkField<Boolean> DISABLE_API_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RequestLaunchTemplateData::disableApiTermination))
            .setter(setter(Builder::disableApiTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination")
                    .unmarshallLocationName("DisableApiTermination").build()).build();

    private static final SdkField<String> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RequestLaunchTemplateData::instanceInitiatedShutdownBehaviorAsString))
            .setter(setter(Builder::instanceInitiatedShutdownBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior")
                    .unmarshallLocationName("InstanceInitiatedShutdownBehavior").build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RequestLaunchTemplateData::userData))
            .setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData")
                    .unmarshallLocationName("UserData").build()).build();

    private static final SdkField<List<LaunchTemplateTagSpecificationRequest>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<LaunchTemplateTagSpecificationRequest>> builder(MarshallingType.LIST)
            .getter(getter(RequestLaunchTemplateData::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("LaunchTemplateTagSpecificationRequest")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateTagSpecificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateTagSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("LaunchTemplateTagSpecificationRequest")
                                                    .unmarshallLocationName("LaunchTemplateTagSpecificationRequest").build())
                                            .build()).build()).build();

    private static final SdkField<List<ElasticGpuSpecification>> ELASTIC_GPU_SPECIFICATIONS_FIELD = SdkField
            .<List<ElasticGpuSpecification>> builder(MarshallingType.LIST)
            .getter(getter(RequestLaunchTemplateData::elasticGpuSpecifications))
            .setter(setter(Builder::elasticGpuSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSpecification")
                    .unmarshallLocationName("ElasticGpuSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ElasticGpuSpecification")
                            .memberFieldInfo(
                                    SdkField.<ElasticGpuSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticGpuSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ElasticGpuSpecification")
                                                    .unmarshallLocationName("ElasticGpuSpecification").build()).build()).build())
            .build();

    private static final SdkField<List<LaunchTemplateElasticInferenceAccelerator>> ELASTIC_INFERENCE_ACCELERATORS_FIELD = SdkField
            .<List<LaunchTemplateElasticInferenceAccelerator>> builder(MarshallingType.LIST)
            .getter(getter(RequestLaunchTemplateData::elasticInferenceAccelerators))
            .setter(setter(Builder::elasticInferenceAccelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticInferenceAccelerator")
                    .unmarshallLocationName("ElasticInferenceAccelerator").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateElasticInferenceAccelerator> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateElasticInferenceAccelerator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RequestLaunchTemplateData::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId")
                                                    .build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(RequestLaunchTemplateData::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup")
                    .unmarshallLocationName("SecurityGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroup").unmarshallLocationName("SecurityGroup")
                                                    .build()).build()).build()).build();

    private static final SdkField<LaunchTemplateInstanceMarketOptionsRequest> INSTANCE_MARKET_OPTIONS_FIELD = SdkField
            .<LaunchTemplateInstanceMarketOptionsRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(RequestLaunchTemplateData::instanceMarketOptions))
            .setter(setter(Builder::instanceMarketOptions))
            .constructor(LaunchTemplateInstanceMarketOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMarketOptions")
                    .unmarshallLocationName("InstanceMarketOptions").build()).build();

    private static final SdkField<CreditSpecificationRequest> CREDIT_SPECIFICATION_FIELD = SdkField
            .<CreditSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(RequestLaunchTemplateData::creditSpecification))
            .setter(setter(Builder::creditSpecification))
            .constructor(CreditSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditSpecification")
                    .unmarshallLocationName("CreditSpecification").build()).build();

    private static final SdkField<LaunchTemplateCpuOptionsRequest> CPU_OPTIONS_FIELD = SdkField
            .<LaunchTemplateCpuOptionsRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(RequestLaunchTemplateData::cpuOptions))
            .setter(setter(Builder::cpuOptions))
            .constructor(LaunchTemplateCpuOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions")
                    .unmarshallLocationName("CpuOptions").build()).build();

    private static final SdkField<LaunchTemplateCapacityReservationSpecificationRequest> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField
            .<LaunchTemplateCapacityReservationSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(RequestLaunchTemplateData::capacityReservationSpecification))
            .setter(setter(Builder::capacityReservationSpecification))
            .constructor(LaunchTemplateCapacityReservationSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification")
                    .unmarshallLocationName("CapacityReservationSpecification").build()).build();

    private static final SdkField<List<LaunchTemplateLicenseConfigurationRequest>> LICENSE_SPECIFICATIONS_FIELD = SdkField
            .<List<LaunchTemplateLicenseConfigurationRequest>> builder(MarshallingType.LIST)
            .getter(getter(RequestLaunchTemplateData::licenseSpecifications))
            .setter(setter(Builder::licenseSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecification")
                    .unmarshallLocationName("LicenseSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateLicenseConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateLicenseConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<LaunchTemplateHibernationOptionsRequest> HIBERNATION_OPTIONS_FIELD = SdkField
            .<LaunchTemplateHibernationOptionsRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(RequestLaunchTemplateData::hibernationOptions))
            .setter(setter(Builder::hibernationOptions))
            .constructor(LaunchTemplateHibernationOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions")
                    .unmarshallLocationName("HibernationOptions").build()).build();

    private static final SdkField<LaunchTemplateInstanceMetadataOptionsRequest> METADATA_OPTIONS_FIELD = SdkField
            .<LaunchTemplateInstanceMetadataOptionsRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(RequestLaunchTemplateData::metadataOptions))
            .setter(setter(Builder::metadataOptions))
            .constructor(LaunchTemplateInstanceMetadataOptionsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions")
                    .unmarshallLocationName("MetadataOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KERNEL_ID_FIELD,
            EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, NETWORK_INTERFACES_FIELD,
            IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, KEY_NAME_FIELD, MONITORING_FIELD, PLACEMENT_FIELD, RAM_DISK_ID_FIELD,
            DISABLE_API_TERMINATION_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, USER_DATA_FIELD, TAG_SPECIFICATIONS_FIELD,
            ELASTIC_GPU_SPECIFICATIONS_FIELD, ELASTIC_INFERENCE_ACCELERATORS_FIELD, SECURITY_GROUP_IDS_FIELD,
            SECURITY_GROUPS_FIELD, INSTANCE_MARKET_OPTIONS_FIELD, CREDIT_SPECIFICATION_FIELD, CPU_OPTIONS_FIELD,
            CAPACITY_RESERVATION_SPECIFICATION_FIELD, LICENSE_SPECIFICATIONS_FIELD, HIBERNATION_OPTIONS_FIELD,
            METADATA_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kernelId;

    private final Boolean ebsOptimized;

    private final LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;

    private final List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings;

    private final List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces;

    private final String imageId;

    private final String instanceType;

    private final String keyName;

    private final LaunchTemplatesMonitoringRequest monitoring;

    private final LaunchTemplatePlacementRequest placement;

    private final String ramDiskId;

    private final Boolean disableApiTermination;

    private final String instanceInitiatedShutdownBehavior;

    private final String userData;

    private final List<LaunchTemplateTagSpecificationRequest> tagSpecifications;

    private final List<ElasticGpuSpecification> elasticGpuSpecifications;

    private final List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators;

    private final List<String> securityGroupIds;

    private final List<String> securityGroups;

    private final LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;

    private final CreditSpecificationRequest creditSpecification;

    private final LaunchTemplateCpuOptionsRequest cpuOptions;

    private final LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification;

    private final List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications;

    private final LaunchTemplateHibernationOptionsRequest hibernationOptions;

    private final LaunchTemplateInstanceMetadataOptionsRequest metadataOptions;

    private RequestLaunchTemplateData(BuilderImpl builder) {
        this.kernelId = builder.kernelId;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.networkInterfaces = builder.networkInterfaces;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramDiskId = builder.ramDiskId;
        this.disableApiTermination = builder.disableApiTermination;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.userData = builder.userData;
        this.tagSpecifications = builder.tagSpecifications;
        this.elasticGpuSpecifications = builder.elasticGpuSpecifications;
        this.elasticInferenceAccelerators = builder.elasticInferenceAccelerators;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.creditSpecification = builder.creditSpecification;
        this.cpuOptions = builder.cpuOptions;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.hibernationOptions = builder.hibernationOptions;
        this.metadataOptions = builder.metadataOptions;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * <important>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided Kernels</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </important>
     * 
     * @return The ID of the kernel.</p> <important>
     *         <p>
     *         We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided
     *         Kernels</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *         </p>
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput
     * to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This
     * optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized
     * instance.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O
     *         performance. This optimization isn't available with all instance types. Additional usage charges apply
     *         when using an EBS-optimized instance.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The IAM instance profile.
     * </p>
     * 
     * @return The IAM instance profile.
     */
    public LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * Returns true if the BlockDeviceMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mapping.
     * </p>
     * <important>
     * <p>
     * Supplying both a snapshot ID and an encryption value as arguments for block-device mapping results in an error.
     * This is because only blank volumes can be encrypted on start, and these are not created from a snapshot. If a
     * snapshot is the basis for the volume, it contains data by definition and its encryption status cannot be changed
     * using this action.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlockDeviceMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The block device mapping.</p> <important>
     *         <p>
     *         Supplying both a snapshot ID and an encryption value as arguments for block-device mapping results in an
     *         error. This is because only blank volumes can be encrypted on start, and these are not created from a
     *         snapshot. If a snapshot is the basis for the volume, it contains data by definition and its encryption
     *         status cannot be changed using this action.
     *         </p>
     */
    public List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * Returns true if the NetworkInterfaces property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more network interfaces. If you specify a network interface, you must specify any security groups and
     * subnets as part of the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkInterfaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more network interfaces. If you specify a network interface, you must specify any security groups
     *         and subnets as part of the network interface.
     */
    public List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     * @see InstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The name of the key pair. You can create a key pair using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.
     * </p>
     * <important>
     * <p>
     * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured
     * to allow users another way to log in.
     * </p>
     * </important>
     * 
     * @return The name of the key pair. You can create a key pair using <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or
     *         <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.
     *         </p> <important>
     *         <p>
     *         If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
     *         configured to allow users another way to log in.
     *         </p>
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The monitoring for the instance.
     * </p>
     * 
     * @return The monitoring for the instance.
     */
    public LaunchTemplatesMonitoringRequest monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * The placement for the instance.
     * </p>
     * 
     * @return The placement for the instance.
     */
    public LaunchTemplatePlacementRequest placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * <important>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided Kernels</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </important>
     * 
     * @return The ID of the RAM disk.</p> <important>
     *         <p>
     *         We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided
     *         Kernels</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *         </p>
     */
    public String ramDiskId() {
        return ramDiskId;
    }

    /**
     * <p>
     * If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2 console,
     * CLI, or API; otherwise, you can. To change this attribute after launch, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
     * >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to
     * <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.
     * </p>
     * 
     * @return If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
     *         console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
     *         >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to
     *         <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.
     */
    public Boolean disableApiTermination() {
        return disableApiTermination;
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * Default: <code>stop</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).</p>
     *         <p>
     *         Default: <code>stop</code>
     * @see ShutdownBehavior
     */
    public ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(instanceInitiatedShutdownBehavior);
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * Default: <code>stop</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).</p>
     *         <p>
     *         Default: <code>stop</code>
     * @see ShutdownBehavior
     */
    public String instanceInitiatedShutdownBehaviorAsString() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * The Base64-encoded user data to make available to the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your Linux Instance
     * at Launch</a> (Linux) and <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
     * >Adding User Data</a> (Windows).
     * </p>
     * 
     * @return The Base64-encoded user data to make available to the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your Linux
     *         Instance at Launch</a> (Linux) and <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
     *         >Adding User Data</a> (Windows).
     */
    public String userData() {
        return userData;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the resources during launch. You can only tag instances and volumes on launch. The specified
     * tags are applied to all instances or volumes that are created during launch. To tag a resource after it has been
     * created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to apply to the resources during launch. You can only tag instances and volumes on launch. The
     *         specified tags are applied to all instances or volumes that are created during launch. To tag a resource
     *         after it has been created, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
     */
    public List<LaunchTemplateTagSpecificationRequest> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * Returns true if the ElasticGpuSpecifications property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasElasticGpuSpecifications() {
        return elasticGpuSpecifications != null && !(elasticGpuSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An elastic GPU to associate with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElasticGpuSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An elastic GPU to associate with the instance.
     */
    public List<ElasticGpuSpecification> elasticGpuSpecifications() {
        return elasticGpuSpecifications;
    }

    /**
     * Returns true if the ElasticInferenceAccelerators property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasElasticInferenceAccelerators() {
        return elasticInferenceAccelerators != null && !(elasticInferenceAccelerators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The elastic inference accelerator for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElasticInferenceAccelerators()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The elastic inference accelerator for the instance.
     */
    public List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators() {
        return elasticInferenceAccelerators;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more security group IDs. You can create a security group using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
     * >CreateSecurityGroup</a>. You cannot specify both a security group ID and security name in the same request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more security group IDs. You can create a security group using <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
     *         >CreateSecurityGroup</a>. You cannot specify both a security group ID and security name in the same
     *         request.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use security group
     * IDs instead. You cannot specify both a security group ID and security name in the same request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use security
     *         group IDs instead. You cannot specify both a security group ID and security name in the same request.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The market (purchasing) option for the instances.
     * </p>
     * 
     * @return The market (purchasing) option for the instances.
     */
    public LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions() {
        return instanceMarketOptions;
    }

    /**
     * <p>
     * The credit option for CPU usage of the instance. Valid for T2 or T3 instances only.
     * </p>
     * 
     * @return The credit option for CPU usage of the instance. Valid for T2 or T3 instances only.
     */
    public CreditSpecificationRequest creditSpecification() {
        return creditSpecification;
    }

    /**
     * <p>
     * The CPU options for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU Options</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The CPU options for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
     *         Options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public LaunchTemplateCpuOptionsRequest cpuOptions() {
        return cpuOptions;
    }

    /**
     * <p>
     * The Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity
     * Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity Reservation
     * that has matching attributes (instance type, platform, Availability Zone).
     * </p>
     * 
     * @return The Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity
     *         Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity
     *         Reservation that has matching attributes (instance type, platform, Availability Zone).
     */
    public LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification() {
        return capacityReservationSpecification;
    }

    /**
     * Returns true if the LicenseSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLicenseSpecifications() {
        return licenseSpecifications != null && !(licenseSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The license configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenseSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The license configurations.
     */
    public List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications() {
        return licenseSpecifications;
    }

    /**
     * <p>
     * Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance meets the
     * <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation
     * prerequisites</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance
     *         meets the <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites"
     *         >hibernation prerequisites</a>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public LaunchTemplateHibernationOptionsRequest hibernationOptions() {
        return hibernationOptions;
    }

    /**
     * <p>
     * The metadata options for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and User
     * Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The metadata options for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata
     *         and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public LaunchTemplateInstanceMetadataOptionsRequest metadataOptions() {
        return metadataOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(ramDiskId());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInitiatedShutdownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(elasticInferenceAccelerators());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(licenseSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestLaunchTemplateData)) {
            return false;
        }
        RequestLaunchTemplateData other = (RequestLaunchTemplateData) obj;
        return Objects.equals(kernelId(), other.kernelId()) && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(networkInterfaces(), other.networkInterfaces()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(keyName(), other.keyName()) && Objects.equals(monitoring(), other.monitoring())
                && Objects.equals(placement(), other.placement()) && Objects.equals(ramDiskId(), other.ramDiskId())
                && Objects.equals(disableApiTermination(), other.disableApiTermination())
                && Objects.equals(instanceInitiatedShutdownBehaviorAsString(), other.instanceInitiatedShutdownBehaviorAsString())
                && Objects.equals(userData(), other.userData()) && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(elasticGpuSpecifications(), other.elasticGpuSpecifications())
                && Objects.equals(elasticInferenceAccelerators(), other.elasticInferenceAccelerators())
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(instanceMarketOptions(), other.instanceMarketOptions())
                && Objects.equals(creditSpecification(), other.creditSpecification())
                && Objects.equals(cpuOptions(), other.cpuOptions())
                && Objects.equals(capacityReservationSpecification(), other.capacityReservationSpecification())
                && Objects.equals(licenseSpecifications(), other.licenseSpecifications())
                && Objects.equals(hibernationOptions(), other.hibernationOptions())
                && Objects.equals(metadataOptions(), other.metadataOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RequestLaunchTemplateData").add("KernelId", kernelId()).add("EbsOptimized", ebsOptimized())
                .add("IamInstanceProfile", iamInstanceProfile()).add("BlockDeviceMappings", blockDeviceMappings())
                .add("NetworkInterfaces", networkInterfaces()).add("ImageId", imageId())
                .add("InstanceType", instanceTypeAsString()).add("KeyName", keyName()).add("Monitoring", monitoring())
                .add("Placement", placement()).add("RamDiskId", ramDiskId())
                .add("DisableApiTermination", disableApiTermination())
                .add("InstanceInitiatedShutdownBehavior", instanceInitiatedShutdownBehaviorAsString())
                .add("UserData", userData()).add("TagSpecifications", tagSpecifications())
                .add("ElasticGpuSpecifications", elasticGpuSpecifications())
                .add("ElasticInferenceAccelerators", elasticInferenceAccelerators()).add("SecurityGroupIds", securityGroupIds())
                .add("SecurityGroups", securityGroups()).add("InstanceMarketOptions", instanceMarketOptions())
                .add("CreditSpecification", creditSpecification()).add("CpuOptions", cpuOptions())
                .add("CapacityReservationSpecification", capacityReservationSpecification())
                .add("LicenseSpecifications", licenseSpecifications()).add("HibernationOptions", hibernationOptions())
                .add("MetadataOptions", metadataOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "Monitoring":
            return Optional.ofNullable(clazz.cast(monitoring()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "RamDiskId":
            return Optional.ofNullable(clazz.cast(ramDiskId()));
        case "DisableApiTermination":
            return Optional.ofNullable(clazz.cast(disableApiTermination()));
        case "InstanceInitiatedShutdownBehavior":
            return Optional.ofNullable(clazz.cast(instanceInitiatedShutdownBehaviorAsString()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ElasticGpuSpecifications":
            return Optional.ofNullable(clazz.cast(elasticGpuSpecifications()));
        case "ElasticInferenceAccelerators":
            return Optional.ofNullable(clazz.cast(elasticInferenceAccelerators()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "InstanceMarketOptions":
            return Optional.ofNullable(clazz.cast(instanceMarketOptions()));
        case "CreditSpecification":
            return Optional.ofNullable(clazz.cast(creditSpecification()));
        case "CpuOptions":
            return Optional.ofNullable(clazz.cast(cpuOptions()));
        case "CapacityReservationSpecification":
            return Optional.ofNullable(clazz.cast(capacityReservationSpecification()));
        case "LicenseSpecifications":
            return Optional.ofNullable(clazz.cast(licenseSpecifications()));
        case "HibernationOptions":
            return Optional.ofNullable(clazz.cast(hibernationOptions()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestLaunchTemplateData, T> g) {
        return obj -> g.apply((RequestLaunchTemplateData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestLaunchTemplateData> {
        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * <important>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided Kernels</a>
         * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * </important>
         * 
         * @param kernelId
         *        The ID of the kernel.</p> <important>
         *        <p>
         *        We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided
         *        Kernels</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         * throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance.
         * This optimization isn't available with all instance types. Additional usage charges apply when using an
         * EBS-optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O
         *        performance. This optimization isn't available with all instance types. Additional usage charges apply
         *        when using an EBS-optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link LaunchTemplateIamInstanceProfileSpecificationRequest.Builder} avoiding the need to create one manually
         * via {@link LaunchTemplateIamInstanceProfileSpecificationRequest#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link LaunchTemplateIamInstanceProfileSpecificationRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on
         *        {@link LaunchTemplateIamInstanceProfileSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest)
         */
        default Builder iamInstanceProfile(
                Consumer<LaunchTemplateIamInstanceProfileSpecificationRequest.Builder> iamInstanceProfile) {
            return iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest.builder()
                    .applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * The block device mapping.
         * </p>
         * <important>
         * <p>
         * Supplying both a snapshot ID and an encryption value as arguments for block-device mapping results in an
         * error. This is because only blank volumes can be encrypted on start, and these are not created from a
         * snapshot. If a snapshot is the basis for the volume, it contains data by definition and its encryption status
         * cannot be changed using this action.
         * </p>
         * </important>
         * 
         * @param blockDeviceMappings
         *        The block device mapping.</p> <important>
         *        <p>
         *        Supplying both a snapshot ID and an encryption value as arguments for block-device mapping results in
         *        an error. This is because only blank volumes can be encrypted on start, and these are not created from
         *        a snapshot. If a snapshot is the basis for the volume, it contains data by definition and its
         *        encryption status cannot be changed using this action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings);

        /**
         * <p>
         * The block device mapping.
         * </p>
         * <important>
         * <p>
         * Supplying both a snapshot ID and an encryption value as arguments for block-device mapping results in an
         * error. This is because only blank volumes can be encrypted on start, and these are not created from a
         * snapshot. If a snapshot is the basis for the volume, it contains data by definition and its encryption status
         * cannot be changed using this action.
         * </p>
         * </important>
         * 
         * @param blockDeviceMappings
         *        The block device mapping.</p> <important>
         *        <p>
         *        Supplying both a snapshot ID and an encryption value as arguments for block-device mapping results in
         *        an error. This is because only blank volumes can be encrypted on start, and these are not created from
         *        a snapshot. If a snapshot is the basis for the volume, it contains data by definition and its
         *        encryption status cannot be changed using this action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(LaunchTemplateBlockDeviceMappingRequest... blockDeviceMappings);

        /**
         * <p>
         * The block device mapping.
         * </p>
         * <important>
         * <p>
         * Supplying both a snapshot ID and an encryption value as arguments for block-device mapping results in an
         * error. This is because only blank volumes can be encrypted on start, and these are not created from a
         * snapshot. If a snapshot is the basis for the volume, it contains data by definition and its encryption status
         * cannot be changed using this action.
         * </p>
         * </important> This is a convenience that creates an instance of the {@link List
         * <LaunchTemplateBlockDeviceMappingRequest>.Builder} avoiding the need to create one manually via {@link List
         * <LaunchTemplateBlockDeviceMappingRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplateBlockDeviceMappingRequest>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #blockDeviceMappings(List<LaunchTemplateBlockDeviceMappingRequest>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<LaunchTemplateBlockDeviceMappingRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<LaunchTemplateBlockDeviceMappingRequest>)
         */
        Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMappingRequest.Builder>... blockDeviceMappings);

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify any security groups and
         * subnets as part of the network interface.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces. If you specify a network interface, you must specify any security
         *        groups and subnets as part of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces);

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify any security groups and
         * subnets as part of the network interface.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces. If you specify a network interface, you must specify any security
         *        groups and subnets as part of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest... networkInterfaces);

        /**
         * <p>
         * One or more network interfaces. If you specify a network interface, you must specify any security groups and
         * subnets as part of the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>.Builder} avoiding the need to create one
         * manually via {@link List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>.Builder#build()} is called immediately and its
         * result is passed to {@link
         * #networkInterfaces(List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on {@link List
         *        <LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>)
         */
        Builder networkInterfaces(
                Consumer<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder>... networkInterfaces);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The name of the key pair. You can create a key pair using <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.
         * </p>
         * <important>
         * <p>
         * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
         * configured to allow users another way to log in.
         * </p>
         * </important>
         * 
         * @param keyName
         *        The name of the key pair. You can create a key pair using <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a>
         *        or <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair
         *        </a>.</p> <important>
         *        <p>
         *        If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
         *        configured to allow users another way to log in.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * 
         * @param monitoring
         *        The monitoring for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(LaunchTemplatesMonitoringRequest monitoring);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplatesMonitoringRequest.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplatesMonitoringRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplatesMonitoringRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoring(LaunchTemplatesMonitoringRequest)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link LaunchTemplatesMonitoringRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(LaunchTemplatesMonitoringRequest)
         */
        default Builder monitoring(Consumer<LaunchTemplatesMonitoringRequest.Builder> monitoring) {
            return monitoring(LaunchTemplatesMonitoringRequest.builder().applyMutation(monitoring).build());
        }

        /**
         * <p>
         * The placement for the instance.
         * </p>
         * 
         * @param placement
         *        The placement for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(LaunchTemplatePlacementRequest placement);

        /**
         * <p>
         * The placement for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplatePlacementRequest.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplatePlacementRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplatePlacementRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #placement(LaunchTemplatePlacementRequest)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link LaunchTemplatePlacementRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(LaunchTemplatePlacementRequest)
         */
        default Builder placement(Consumer<LaunchTemplatePlacementRequest.Builder> placement) {
            return placement(LaunchTemplatePlacementRequest.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * <important>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided Kernels</a>
         * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * </important>
         * 
         * @param ramDiskId
         *        The ID of the RAM disk.</p> <important>
         *        <p>
         *        We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided
         *        Kernels</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramDiskId(String ramDiskId);

        /**
         * <p>
         * If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
         * console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
         * >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to
         * <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.
         * </p>
         * 
         * @param disableApiTermination
         *        If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
         *        console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html"
         *        >ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code>
         *        to <code>terminate</code>, you can terminate the instance by running the shutdown command from the
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiTermination(Boolean disableApiTermination);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * <p>
         * Default: <code>stop</code>
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).</p>
         *        <p>
         *        Default: <code>stop</code>
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * <p>
         * Default: <code>stop</code>
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).</p>
         *        <p>
         *        Default: <code>stop</code>
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * The Base64-encoded user data to make available to the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your Linux
         * Instance at Launch</a> (Linux) and <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
         * >Adding User Data</a> (Windows).
         * </p>
         * 
         * @param userData
         *        The Base64-encoded user data to make available to the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your
         *        Linux Instance at Launch</a> (Linux) and <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
         *        >Adding User Data</a> (Windows).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The tags to apply to the resources during launch. You can only tag instances and volumes on launch. The
         * specified tags are applied to all instances or volumes that are created during launch. To tag a resource
         * after it has been created, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the resources during launch. You can only tag instances and volumes on launch.
         *        The specified tags are applied to all instances or volumes that are created during launch. To tag a
         *        resource after it has been created, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<LaunchTemplateTagSpecificationRequest> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the resources during launch. You can only tag instances and volumes on launch. The
         * specified tags are applied to all instances or volumes that are created during launch. To tag a resource
         * after it has been created, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the resources during launch. You can only tag instances and volumes on launch.
         *        The specified tags are applied to all instances or volumes that are created during launch. To tag a
         *        resource after it has been created, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(LaunchTemplateTagSpecificationRequest... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the resources during launch. You can only tag instances and volumes on launch. The
         * specified tags are applied to all instances or volumes that are created during launch. To tag a resource
         * after it has been created, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LaunchTemplateTagSpecificationRequest>.Builder} avoiding the need to create one manually via {@link List
         * <LaunchTemplateTagSpecificationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplateTagSpecificationRequest>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #tagSpecifications(List<LaunchTemplateTagSpecificationRequest>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<LaunchTemplateTagSpecificationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<LaunchTemplateTagSpecificationRequest>)
         */
        Builder tagSpecifications(Consumer<LaunchTemplateTagSpecificationRequest.Builder>... tagSpecifications);

        /**
         * <p>
         * An elastic GPU to associate with the instance.
         * </p>
         * 
         * @param elasticGpuSpecifications
         *        An elastic GPU to associate with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecifications(Collection<ElasticGpuSpecification> elasticGpuSpecifications);

        /**
         * <p>
         * An elastic GPU to associate with the instance.
         * </p>
         * 
         * @param elasticGpuSpecifications
         *        An elastic GPU to associate with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecifications(ElasticGpuSpecification... elasticGpuSpecifications);

        /**
         * <p>
         * An elastic GPU to associate with the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ElasticGpuSpecification>.Builder} avoiding
         * the need to create one manually via {@link List<ElasticGpuSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticGpuSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #elasticGpuSpecifications(List<ElasticGpuSpecification>)}.
         * 
         * @param elasticGpuSpecifications
         *        a consumer that will call methods on {@link List<ElasticGpuSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticGpuSpecifications(List<ElasticGpuSpecification>)
         */
        Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecification.Builder>... elasticGpuSpecifications);

        /**
         * <p>
         * The elastic inference accelerator for the instance.
         * </p>
         * 
         * @param elasticInferenceAccelerators
         *        The elastic inference accelerator for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAccelerators(Collection<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators);

        /**
         * <p>
         * The elastic inference accelerator for the instance.
         * </p>
         * 
         * @param elasticInferenceAccelerators
         *        The elastic inference accelerator for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAccelerators(LaunchTemplateElasticInferenceAccelerator... elasticInferenceAccelerators);

        /**
         * <p>
         * The elastic inference accelerator for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LaunchTemplateElasticInferenceAccelerator>.Builder} avoiding the need to create one manually via
         * {@link List<LaunchTemplateElasticInferenceAccelerator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplateElasticInferenceAccelerator>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #elasticInferenceAccelerators(List<LaunchTemplateElasticInferenceAccelerator>)}.
         * 
         * @param elasticInferenceAccelerators
         *        a consumer that will call methods on {@link List<LaunchTemplateElasticInferenceAccelerator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticInferenceAccelerators(List<LaunchTemplateElasticInferenceAccelerator>)
         */
        Builder elasticInferenceAccelerators(
                Consumer<LaunchTemplateElasticInferenceAccelerator.Builder>... elasticInferenceAccelerators);

        /**
         * <p>
         * One or more security group IDs. You can create a security group using <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
         * >CreateSecurityGroup</a>. You cannot specify both a security group ID and security name in the same request.
         * </p>
         * 
         * @param securityGroupIds
         *        One or more security group IDs. You can create a security group using <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
         *        >CreateSecurityGroup</a>. You cannot specify both a security group ID and security name in the same
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * One or more security group IDs. You can create a security group using <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
         * >CreateSecurityGroup</a>. You cannot specify both a security group ID and security name in the same request.
         * </p>
         * 
         * @param securityGroupIds
         *        One or more security group IDs. You can create a security group using <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html"
         *        >CreateSecurityGroup</a>. You cannot specify both a security group ID and security name in the same
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use security
         * group IDs instead. You cannot specify both a security group ID and security name in the same request.
         * </p>
         * 
         * @param securityGroups
         *        [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use
         *        security group IDs instead. You cannot specify both a security group ID and security name in the same
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use security
         * group IDs instead. You cannot specify both a security group ID and security name in the same request.
         * </p>
         * 
         * @param securityGroups
         *        [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use
         *        security group IDs instead. You cannot specify both a security group ID and security name in the same
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The market (purchasing) option for the instances.
         * </p>
         * 
         * @param instanceMarketOptions
         *        The market (purchasing) option for the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions);

        /**
         * <p>
         * The market (purchasing) option for the instances.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link LaunchTemplateInstanceMarketOptionsRequest.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplateInstanceMarketOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateInstanceMarketOptionsRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest)}.
         * 
         * @param instanceMarketOptions
         *        a consumer that will call methods on {@link LaunchTemplateInstanceMarketOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest)
         */
        default Builder instanceMarketOptions(Consumer<LaunchTemplateInstanceMarketOptionsRequest.Builder> instanceMarketOptions) {
            return instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest.builder()
                    .applyMutation(instanceMarketOptions).build());
        }

        /**
         * <p>
         * The credit option for CPU usage of the instance. Valid for T2 or T3 instances only.
         * </p>
         * 
         * @param creditSpecification
         *        The credit option for CPU usage of the instance. Valid for T2 or T3 instances only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creditSpecification(CreditSpecificationRequest creditSpecification);

        /**
         * <p>
         * The credit option for CPU usage of the instance. Valid for T2 or T3 instances only.
         * </p>
         * This is a convenience that creates an instance of the {@link CreditSpecificationRequest.Builder} avoiding the
         * need to create one manually via {@link CreditSpecificationRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreditSpecificationRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #creditSpecification(CreditSpecificationRequest)}.
         * 
         * @param creditSpecification
         *        a consumer that will call methods on {@link CreditSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creditSpecification(CreditSpecificationRequest)
         */
        default Builder creditSpecification(Consumer<CreditSpecificationRequest.Builder> creditSpecification) {
            return creditSpecification(CreditSpecificationRequest.builder().applyMutation(creditSpecification).build());
        }

        /**
         * <p>
         * The CPU options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
         * Options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param cpuOptions
         *        The CPU options for the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
         *        Options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuOptions(LaunchTemplateCpuOptionsRequest cpuOptions);

        /**
         * <p>
         * The CPU options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
         * Options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateCpuOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateCpuOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateCpuOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #cpuOptions(LaunchTemplateCpuOptionsRequest)}.
         * 
         * @param cpuOptions
         *        a consumer that will call methods on {@link LaunchTemplateCpuOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpuOptions(LaunchTemplateCpuOptionsRequest)
         */
        default Builder cpuOptions(Consumer<LaunchTemplateCpuOptionsRequest.Builder> cpuOptions) {
            return cpuOptions(LaunchTemplateCpuOptionsRequest.builder().applyMutation(cpuOptions).build());
        }

        /**
         * <p>
         * The Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity
         * Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity
         * Reservation that has matching attributes (instance type, platform, Availability Zone).
         * </p>
         * 
         * @param capacityReservationSpecification
         *        The Capacity Reservation targeting option. If you do not specify this parameter, the instance's
         *        Capacity Reservation preference defaults to <code>open</code>, which enables it to run in any open
         *        Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationSpecification(
                LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification);

        /**
         * <p>
         * The Capacity Reservation targeting option. If you do not specify this parameter, the instance's Capacity
         * Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity
         * Reservation that has matching attributes (instance type, platform, Availability Zone).
         * </p>
         * This is a convenience that creates an instance of the
         * {@link LaunchTemplateCapacityReservationSpecificationRequest.Builder} avoiding the need to create one
         * manually via {@link LaunchTemplateCapacityReservationSpecificationRequest#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link LaunchTemplateCapacityReservationSpecificationRequest.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest)}.
         * 
         * @param capacityReservationSpecification
         *        a consumer that will call methods on
         *        {@link LaunchTemplateCapacityReservationSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest)
         */
        default Builder capacityReservationSpecification(
                Consumer<LaunchTemplateCapacityReservationSpecificationRequest.Builder> capacityReservationSpecification) {
            return capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest.builder()
                    .applyMutation(capacityReservationSpecification).build());
        }

        /**
         * <p>
         * The license configurations.
         * </p>
         * 
         * @param licenseSpecifications
         *        The license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications);

        /**
         * <p>
         * The license configurations.
         * </p>
         * 
         * @param licenseSpecifications
         *        The license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(LaunchTemplateLicenseConfigurationRequest... licenseSpecifications);

        /**
         * <p>
         * The license configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LaunchTemplateLicenseConfigurationRequest>.Builder} avoiding the need to create one manually via
         * {@link List<LaunchTemplateLicenseConfigurationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplateLicenseConfigurationRequest>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #licenseSpecifications(List<LaunchTemplateLicenseConfigurationRequest>)}.
         * 
         * @param licenseSpecifications
         *        a consumer that will call methods on {@link List<LaunchTemplateLicenseConfigurationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseSpecifications(List<LaunchTemplateLicenseConfigurationRequest>)
         */
        Builder licenseSpecifications(Consumer<LaunchTemplateLicenseConfigurationRequest.Builder>... licenseSpecifications);

        /**
         * <p>
         * Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance meets
         * the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">
         * hibernation prerequisites</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param hibernationOptions
         *        Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance
         *        meets the <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites"
         *        >hibernation prerequisites</a>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hibernationOptions(LaunchTemplateHibernationOptionsRequest hibernationOptions);

        /**
         * <p>
         * Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance meets
         * the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">
         * hibernation prerequisites</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateHibernationOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateHibernationOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateHibernationOptionsRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #hibernationOptions(LaunchTemplateHibernationOptionsRequest)}.
         * 
         * @param hibernationOptions
         *        a consumer that will call methods on {@link LaunchTemplateHibernationOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hibernationOptions(LaunchTemplateHibernationOptionsRequest)
         */
        default Builder hibernationOptions(Consumer<LaunchTemplateHibernationOptionsRequest.Builder> hibernationOptions) {
            return hibernationOptions(LaunchTemplateHibernationOptionsRequest.builder().applyMutation(hibernationOptions).build());
        }

        /**
         * <p>
         * The metadata options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and
         * User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param metadataOptions
         *        The metadata options for the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance
         *        Metadata and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest metadataOptions);

        /**
         * <p>
         * The metadata options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and
         * User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link LaunchTemplateInstanceMetadataOptionsRequest.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplateInstanceMetadataOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateInstanceMetadataOptionsRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link LaunchTemplateInstanceMetadataOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest)
         */
        default Builder metadataOptions(Consumer<LaunchTemplateInstanceMetadataOptionsRequest.Builder> metadataOptions) {
            return metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest.builder().applyMutation(metadataOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String kernelId;

        private Boolean ebsOptimized;

        private LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;

        private List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces = DefaultSdkAutoConstructList
                .getInstance();

        private String imageId;

        private String instanceType;

        private String keyName;

        private LaunchTemplatesMonitoringRequest monitoring;

        private LaunchTemplatePlacementRequest placement;

        private String ramDiskId;

        private Boolean disableApiTermination;

        private String instanceInitiatedShutdownBehavior;

        private String userData;

        private List<LaunchTemplateTagSpecificationRequest> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<ElasticGpuSpecification> elasticGpuSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators = DefaultSdkAutoConstructList
                .getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;

        private CreditSpecificationRequest creditSpecification;

        private LaunchTemplateCpuOptionsRequest cpuOptions;

        private LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification;

        private List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private LaunchTemplateHibernationOptionsRequest hibernationOptions;

        private LaunchTemplateInstanceMetadataOptionsRequest metadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestLaunchTemplateData model) {
            kernelId(model.kernelId);
            ebsOptimized(model.ebsOptimized);
            iamInstanceProfile(model.iamInstanceProfile);
            blockDeviceMappings(model.blockDeviceMappings);
            networkInterfaces(model.networkInterfaces);
            imageId(model.imageId);
            instanceType(model.instanceType);
            keyName(model.keyName);
            monitoring(model.monitoring);
            placement(model.placement);
            ramDiskId(model.ramDiskId);
            disableApiTermination(model.disableApiTermination);
            instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            userData(model.userData);
            tagSpecifications(model.tagSpecifications);
            elasticGpuSpecifications(model.elasticGpuSpecifications);
            elasticInferenceAccelerators(model.elasticInferenceAccelerators);
            securityGroupIds(model.securityGroupIds);
            securityGroups(model.securityGroups);
            instanceMarketOptions(model.instanceMarketOptions);
            creditSpecification(model.creditSpecification);
            cpuOptions(model.cpuOptions);
            capacityReservationSpecification(model.capacityReservationSpecification);
            licenseSpecifications(model.licenseSpecifications);
            hibernationOptions(model.hibernationOptions);
            metadataOptions(model.metadataOptions);
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final LaunchTemplateIamInstanceProfileSpecificationRequest.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(
                LaunchTemplateIamInstanceProfileSpecificationRequest.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final Collection<LaunchTemplateBlockDeviceMappingRequest.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream()
                    .map(LaunchTemplateBlockDeviceMappingRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(LaunchTemplateBlockDeviceMappingRequest... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMappingRequest.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> LaunchTemplateBlockDeviceMappingRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(
                Collection<LaunchTemplateBlockDeviceMappingRequest.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder> getNetworkInterfaces() {
            return networkInterfaces != null ? networkInterfaces.stream()
                    .map(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder networkInterfaces(
                Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(
                Consumer<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces)
                    .map(c -> LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(
                Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier
                    .copyFromBuilder(networkInterfaces);
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceTypeAsString() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final LaunchTemplatesMonitoringRequest.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(LaunchTemplatesMonitoringRequest monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(LaunchTemplatesMonitoringRequest.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final LaunchTemplatePlacementRequest.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(LaunchTemplatePlacementRequest placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(LaunchTemplatePlacementRequest.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamDiskId() {
            return ramDiskId;
        }

        @Override
        public final Builder ramDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
            return this;
        }

        public final void setRamDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
        }

        public final Boolean getDisableApiTermination() {
            return disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final String getInstanceInitiatedShutdownBehaviorAsString() {
            return instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior == null ? null
                    : instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final Collection<LaunchTemplateTagSpecificationRequest.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(LaunchTemplateTagSpecificationRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<LaunchTemplateTagSpecificationRequest> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationRequestListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(LaunchTemplateTagSpecificationRequest... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<LaunchTemplateTagSpecificationRequest.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications)
                    .map(c -> LaunchTemplateTagSpecificationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<LaunchTemplateTagSpecificationRequest.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationRequestListCopier.copyFromBuilder(tagSpecifications);
        }

        public final Collection<ElasticGpuSpecification.Builder> getElasticGpuSpecifications() {
            return elasticGpuSpecifications != null ? elasticGpuSpecifications.stream().map(ElasticGpuSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticGpuSpecifications(Collection<ElasticGpuSpecification> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationListCopier.copy(elasticGpuSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(ElasticGpuSpecification... elasticGpuSpecifications) {
            elasticGpuSpecifications(Arrays.asList(elasticGpuSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecification.Builder>... elasticGpuSpecifications) {
            elasticGpuSpecifications(Stream.of(elasticGpuSpecifications)
                    .map(c -> ElasticGpuSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticGpuSpecifications(Collection<ElasticGpuSpecification.BuilderImpl> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationListCopier.copyFromBuilder(elasticGpuSpecifications);
        }

        public final Collection<LaunchTemplateElasticInferenceAccelerator.Builder> getElasticInferenceAccelerators() {
            return elasticInferenceAccelerators != null ? elasticInferenceAccelerators.stream()
                    .map(LaunchTemplateElasticInferenceAccelerator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticInferenceAccelerators(
                Collection<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorListCopier
                    .copy(elasticInferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(
                LaunchTemplateElasticInferenceAccelerator... elasticInferenceAccelerators) {
            elasticInferenceAccelerators(Arrays.asList(elasticInferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(
                Consumer<LaunchTemplateElasticInferenceAccelerator.Builder>... elasticInferenceAccelerators) {
            elasticInferenceAccelerators(Stream.of(elasticInferenceAccelerators)
                    .map(c -> LaunchTemplateElasticInferenceAccelerator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setElasticInferenceAccelerators(
                Collection<LaunchTemplateElasticInferenceAccelerator.BuilderImpl> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorListCopier
                    .copyFromBuilder(elasticInferenceAccelerators);
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
        }

        public final LaunchTemplateInstanceMarketOptionsRequest.Builder getInstanceMarketOptions() {
            return instanceMarketOptions != null ? instanceMarketOptions.toBuilder() : null;
        }

        @Override
        public final Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final void setInstanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        public final CreditSpecificationRequest.Builder getCreditSpecification() {
            return creditSpecification != null ? creditSpecification.toBuilder() : null;
        }

        @Override
        public final Builder creditSpecification(CreditSpecificationRequest creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final void setCreditSpecification(CreditSpecificationRequest.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        public final LaunchTemplateCpuOptionsRequest.Builder getCpuOptions() {
            return cpuOptions != null ? cpuOptions.toBuilder() : null;
        }

        @Override
        public final Builder cpuOptions(LaunchTemplateCpuOptionsRequest cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final void setCpuOptions(LaunchTemplateCpuOptionsRequest.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        public final LaunchTemplateCapacityReservationSpecificationRequest.Builder getCapacityReservationSpecification() {
            return capacityReservationSpecification != null ? capacityReservationSpecification.toBuilder() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(
                LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final void setCapacityReservationSpecification(
                LaunchTemplateCapacityReservationSpecificationRequest.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification
                    .build() : null;
        }

        public final Collection<LaunchTemplateLicenseConfigurationRequest.Builder> getLicenseSpecifications() {
            return licenseSpecifications != null ? licenseSpecifications.stream()
                    .map(LaunchTemplateLicenseConfigurationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseSpecificationListRequestCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LaunchTemplateLicenseConfigurationRequest... licenseSpecifications) {
            licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(
                Consumer<LaunchTemplateLicenseConfigurationRequest.Builder>... licenseSpecifications) {
            licenseSpecifications(Stream.of(licenseSpecifications)
                    .map(c -> LaunchTemplateLicenseConfigurationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseSpecifications(
                Collection<LaunchTemplateLicenseConfigurationRequest.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseSpecificationListRequestCopier
                    .copyFromBuilder(licenseSpecifications);
        }

        public final LaunchTemplateHibernationOptionsRequest.Builder getHibernationOptions() {
            return hibernationOptions != null ? hibernationOptions.toBuilder() : null;
        }

        @Override
        public final Builder hibernationOptions(LaunchTemplateHibernationOptionsRequest hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final void setHibernationOptions(LaunchTemplateHibernationOptionsRequest.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        public final LaunchTemplateInstanceMetadataOptionsRequest.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        @Override
        public final Builder metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final void setMetadataOptions(LaunchTemplateInstanceMetadataOptionsRequest.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public RequestLaunchTemplateData build() {
            return new RequestLaunchTemplateData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
