/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateVpcCidrBlockRequest extends Ec2Request implements
        ToCopyableBuilder<AssociateVpcCidrBlockRequest.Builder, AssociateVpcCidrBlockRequest> {
    private static final SdkField<Boolean> AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AssociateVpcCidrBlockRequest::amazonProvidedIpv6CidrBlock))
            .setter(setter(Builder::amazonProvidedIpv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonProvidedIpv6CidrBlock")
                    .unmarshallLocationName("amazonProvidedIpv6CidrBlock").build()).build();

    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateVpcCidrBlockRequest::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock")
                    .unmarshallLocationName("CidrBlock").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateVpcCidrBlockRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_NETWORK_BORDER_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateVpcCidrBlockRequest::ipv6CidrBlockNetworkBorderGroup))
            .setter(setter(Builder::ipv6CidrBlockNetworkBorderGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockNetworkBorderGroup")
                    .unmarshallLocationName("Ipv6CidrBlockNetworkBorderGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD, CIDR_BLOCK_FIELD, VPC_ID_FIELD, IPV6_CIDR_BLOCK_NETWORK_BORDER_GROUP_FIELD));

    private final Boolean amazonProvidedIpv6CidrBlock;

    private final String cidrBlock;

    private final String vpcId;

    private final String ipv6CidrBlockNetworkBorderGroup;

    private AssociateVpcCidrBlockRequest(BuilderImpl builder) {
        super(builder);
        this.amazonProvidedIpv6CidrBlock = builder.amazonProvidedIpv6CidrBlock;
        this.cidrBlock = builder.cidrBlock;
        this.vpcId = builder.vpcId;
        this.ipv6CidrBlockNetworkBorderGroup = builder.ipv6CidrBlockNetworkBorderGroup;
    }

    /**
     * <p>
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of
     * IPv6 addresses, or the size of the CIDR block.
     * </p>
     * 
     * @return Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the
     *         range of IPv6 addresses, or the size of the CIDR block.
     */
    public Boolean amazonProvidedIpv6CidrBlock() {
        return amazonProvidedIpv6CidrBlock;
    }

    /**
     * <p>
     * An IPv4 CIDR block to associate with the VPC.
     * </p>
     * 
     * @return An IPv4 CIDR block to associate with the VPC.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CiDR block
     * to this location.
     * </p>
     * <p>
     * You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
     * </p>
     * <p>
     * You can have one IPv6 CIDR block association per network border group.
     * </p>
     * 
     * @return The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the
     *         CiDR block to this location.</p>
     *         <p>
     *         You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
     *         </p>
     *         <p>
     *         You can have one IPv6 CIDR block association per network border group.
     */
    public String ipv6CidrBlockNetworkBorderGroup() {
        return ipv6CidrBlockNetworkBorderGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amazonProvidedIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlockNetworkBorderGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVpcCidrBlockRequest)) {
            return false;
        }
        AssociateVpcCidrBlockRequest other = (AssociateVpcCidrBlockRequest) obj;
        return Objects.equals(amazonProvidedIpv6CidrBlock(), other.amazonProvidedIpv6CidrBlock())
                && Objects.equals(cidrBlock(), other.cidrBlock()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(ipv6CidrBlockNetworkBorderGroup(), other.ipv6CidrBlockNetworkBorderGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateVpcCidrBlockRequest").add("AmazonProvidedIpv6CidrBlock", amazonProvidedIpv6CidrBlock())
                .add("CidrBlock", cidrBlock()).add("VpcId", vpcId())
                .add("Ipv6CidrBlockNetworkBorderGroup", ipv6CidrBlockNetworkBorderGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonProvidedIpv6CidrBlock":
            return Optional.ofNullable(clazz.cast(amazonProvidedIpv6CidrBlock()));
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Ipv6CidrBlockNetworkBorderGroup":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockNetworkBorderGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateVpcCidrBlockRequest, T> g) {
        return obj -> g.apply((AssociateVpcCidrBlockRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssociateVpcCidrBlockRequest> {
        /**
         * <p>
         * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the
         * range of IPv6 addresses, or the size of the CIDR block.
         * </p>
         * 
         * @param amazonProvidedIpv6CidrBlock
         *        Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify
         *        the range of IPv6 addresses, or the size of the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock);

        /**
         * <p>
         * An IPv4 CIDR block to associate with the VPC.
         * </p>
         * 
         * @param cidrBlock
         *        An IPv4 CIDR block to associate with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CiDR
         * block to this location.
         * </p>
         * <p>
         * You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
         * </p>
         * <p>
         * You can have one IPv6 CIDR block association per network border group.
         * </p>
         * 
         * @param ipv6CidrBlockNetworkBorderGroup
         *        The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the
         *        CiDR block to this location.</p>
         *        <p>
         *        You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.
         *        </p>
         *        <p>
         *        You can have one IPv6 CIDR block association per network border group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean amazonProvidedIpv6CidrBlock;

        private String cidrBlock;

        private String vpcId;

        private String ipv6CidrBlockNetworkBorderGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVpcCidrBlockRequest model) {
            super(model);
            amazonProvidedIpv6CidrBlock(model.amazonProvidedIpv6CidrBlock);
            cidrBlock(model.cidrBlock);
            vpcId(model.vpcId);
            ipv6CidrBlockNetworkBorderGroup(model.ipv6CidrBlockNetworkBorderGroup);
        }

        public final Boolean getAmazonProvidedIpv6CidrBlock() {
            return amazonProvidedIpv6CidrBlock;
        }

        @Override
        public final Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        public final void setAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getIpv6CidrBlockNetworkBorderGroup() {
            return ipv6CidrBlockNetworkBorderGroup;
        }

        @Override
        public final Builder ipv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup) {
            this.ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup;
            return this;
        }

        public final void setIpv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup) {
            this.ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateVpcCidrBlockRequest build() {
            return new AssociateVpcCidrBlockRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
