/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVolumeStatusResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVolumeStatusResponse.Builder, DescribeVolumeStatusResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeVolumeStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<VolumeStatusItem>> VOLUME_STATUSES_FIELD = SdkField
            .<List<VolumeStatusItem>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVolumeStatusResponse::volumeStatuses))
            .setter(setter(Builder::volumeStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeStatusSet")
                    .unmarshallLocationName("volumeStatusSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VolumeStatusItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeStatusItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VOLUME_STATUSES_FIELD));

    private final String nextToken;

    private final List<VolumeStatusItem> volumeStatuses;

    private DescribeVolumeStatusResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.volumeStatuses = builder.volumeStatuses;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the VolumeStatuses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVolumeStatuses() {
        return volumeStatuses != null && !(volumeStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the status of the volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVolumeStatuses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the status of the volumes.
     */
    public List<VolumeStatusItem> volumeStatuses() {
        return volumeStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(volumeStatuses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeStatusResponse)) {
            return false;
        }
        DescribeVolumeStatusResponse other = (DescribeVolumeStatusResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(volumeStatuses(), other.volumeStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVolumeStatusResponse").add("NextToken", nextToken())
                .add("VolumeStatuses", volumeStatuses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "VolumeStatuses":
            return Optional.ofNullable(clazz.cast(volumeStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVolumeStatusResponse, T> g) {
        return obj -> g.apply((DescribeVolumeStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVolumeStatusResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the status of the volumes.
         * </p>
         * 
         * @param volumeStatuses
         *        Information about the status of the volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatuses(Collection<VolumeStatusItem> volumeStatuses);

        /**
         * <p>
         * Information about the status of the volumes.
         * </p>
         * 
         * @param volumeStatuses
         *        Information about the status of the volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatuses(VolumeStatusItem... volumeStatuses);

        /**
         * <p>
         * Information about the status of the volumes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VolumeStatusItem>.Builder} avoiding the
         * need to create one manually via {@link List<VolumeStatusItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VolumeStatusItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #volumeStatuses(List<VolumeStatusItem>)}.
         * 
         * @param volumeStatuses
         *        a consumer that will call methods on {@link List<VolumeStatusItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeStatuses(List<VolumeStatusItem>)
         */
        Builder volumeStatuses(Consumer<VolumeStatusItem.Builder>... volumeStatuses);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<VolumeStatusItem> volumeStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeStatusResponse model) {
            super(model);
            nextToken(model.nextToken);
            volumeStatuses(model.volumeStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VolumeStatusItem.Builder> getVolumeStatuses() {
            return volumeStatuses != null ? volumeStatuses.stream().map(VolumeStatusItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder volumeStatuses(Collection<VolumeStatusItem> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copy(volumeStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeStatuses(VolumeStatusItem... volumeStatuses) {
            volumeStatuses(Arrays.asList(volumeStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeStatuses(Consumer<VolumeStatusItem.Builder>... volumeStatuses) {
            volumeStatuses(Stream.of(volumeStatuses).map(c -> VolumeStatusItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVolumeStatuses(Collection<VolumeStatusItem.BuilderImpl> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copyFromBuilder(volumeStatuses);
        }

        @Override
        public DescribeVolumeStatusResponse build() {
            return new DescribeVolumeStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
