/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyReservedInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyReservedInstancesRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyReservedInstancesRequest.Builder, ModifyReservedInstancesRequest> {
    private static final SdkField<List<String>> RESERVED_INSTANCES_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyReservedInstancesRequest::reservedInstancesIds))
            .setter(setter(Builder::reservedInstancesIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId")
                    .unmarshallLocationName("ReservedInstancesId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReservedInstancesId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReservedInstancesId")
                                                    .unmarshallLocationName("ReservedInstancesId").build()).build()).build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReservedInstancesRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<List<ReservedInstancesConfiguration>> TARGET_CONFIGURATIONS_FIELD = SdkField
            .<List<ReservedInstancesConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(ModifyReservedInstancesRequest::targetConfigurations))
            .setter(setter(Builder::targetConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReservedInstancesConfigurationSetItemType")
                    .unmarshallLocationName("ReservedInstancesConfigurationSetItemType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ReservedInstancesConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstancesConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCES_IDS_FIELD,
            CLIENT_TOKEN_FIELD, TARGET_CONFIGURATIONS_FIELD));

    private final List<String> reservedInstancesIds;

    private final String clientToken;

    private final List<ReservedInstancesConfiguration> targetConfigurations;

    private ModifyReservedInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.clientToken = builder.clientToken;
        this.targetConfigurations = builder.targetConfigurations;
    }

    /**
     * Returns true if the ReservedInstancesIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReservedInstancesIds() {
        return reservedInstancesIds != null && !(reservedInstancesIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Reserved Instances to modify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReservedInstancesIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the Reserved Instances to modify.
     */
    public List<String> reservedInstancesIds() {
        return reservedInstancesIds;
    }

    /**
     * <p>
     * A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the TargetConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTargetConfigurations() {
        return targetConfigurations != null && !(targetConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration settings for the Reserved Instances to modify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The configuration settings for the Reserved Instances to modify.
     */
    public List<ReservedInstancesConfiguration> targetConfigurations() {
        return targetConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesIds());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReservedInstancesRequest)) {
            return false;
        }
        ModifyReservedInstancesRequest other = (ModifyReservedInstancesRequest) obj;
        return Objects.equals(reservedInstancesIds(), other.reservedInstancesIds())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(targetConfigurations(), other.targetConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyReservedInstancesRequest").add("ReservedInstancesIds", reservedInstancesIds())
                .add("ClientToken", clientToken()).add("TargetConfigurations", targetConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesIds":
            return Optional.ofNullable(clazz.cast(reservedInstancesIds()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "TargetConfigurations":
            return Optional.ofNullable(clazz.cast(targetConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReservedInstancesRequest, T> g) {
        return obj -> g.apply((ModifyReservedInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyReservedInstancesRequest> {
        /**
         * <p>
         * The IDs of the Reserved Instances to modify.
         * </p>
         * 
         * @param reservedInstancesIds
         *        The IDs of the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(Collection<String> reservedInstancesIds);

        /**
         * <p>
         * The IDs of the Reserved Instances to modify.
         * </p>
         * 
         * @param reservedInstancesIds
         *        The IDs of the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(String... reservedInstancesIds);

        /**
         * <p>
         * A unique, case-sensitive token you provide to ensure idempotency of your modification request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token you provide to ensure idempotency of your modification request. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration settings for the Reserved Instances to modify.
         * </p>
         * 
         * @param targetConfigurations
         *        The configuration settings for the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations);

        /**
         * <p>
         * The configuration settings for the Reserved Instances to modify.
         * </p>
         * 
         * @param targetConfigurations
         *        The configuration settings for the Reserved Instances to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurations(ReservedInstancesConfiguration... targetConfigurations);

        /**
         * <p>
         * The configuration settings for the Reserved Instances to modify.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedInstancesConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<ReservedInstancesConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedInstancesConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #targetConfigurations(List<ReservedInstancesConfiguration>)}.
         * 
         * @param targetConfigurations
         *        a consumer that will call methods on {@link List<ReservedInstancesConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfigurations(List<ReservedInstancesConfiguration>)
         */
        Builder targetConfigurations(Consumer<ReservedInstancesConfiguration.Builder>... targetConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> reservedInstancesIds = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private List<ReservedInstancesConfiguration> targetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReservedInstancesRequest model) {
            super(model);
            reservedInstancesIds(model.reservedInstancesIds);
            clientToken(model.clientToken);
            targetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstancesIds() {
            return reservedInstancesIds;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(String... reservedInstancesIds) {
            reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<ReservedInstancesConfiguration.Builder> getTargetConfigurations() {
            return targetConfigurations != null ? targetConfigurations.stream().map(ReservedInstancesConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(ReservedInstancesConfiguration... targetConfigurations) {
            targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(Consumer<ReservedInstancesConfiguration.Builder>... targetConfigurations) {
            targetConfigurations(Stream.of(targetConfigurations)
                    .map(c -> ReservedInstancesConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetConfigurations(Collection<ReservedInstancesConfiguration.BuilderImpl> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copyFromBuilder(targetConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReservedInstancesRequest build() {
            return new ModifyReservedInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
