/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the import snapshot task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotTaskDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotTaskDetail.Builder, SnapshotTaskDetail> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotTaskDetail::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Double> DISK_IMAGE_SIZE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(SnapshotTaskDetail::diskImageSize))
            .setter(setter(Builder::diskImageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImageSize")
                    .unmarshallLocationName("diskImageSize").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SnapshotTaskDetail::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("encrypted").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotTaskDetail::format))
            .setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format")
                    .unmarshallLocationName("format").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotTaskDetail::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("kmsKeyId").build()).build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotTaskDetail::progress))
            .setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress")
                    .unmarshallLocationName("progress").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotTaskDetail::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotTaskDetail::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotTaskDetail::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotTaskDetail::url))
            .setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").unmarshallLocationName("url")
                    .build()).build();

    private static final SdkField<UserBucketDetails> USER_BUCKET_FIELD = SdkField
            .<UserBucketDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(SnapshotTaskDetail::userBucket))
            .setter(setter(Builder::userBucket))
            .constructor(UserBucketDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserBucket")
                    .unmarshallLocationName("userBucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DISK_IMAGE_SIZE_FIELD, ENCRYPTED_FIELD, FORMAT_FIELD, KMS_KEY_ID_FIELD, PROGRESS_FIELD, SNAPSHOT_ID_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, URL_FIELD, USER_BUCKET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final Double diskImageSize;

    private final Boolean encrypted;

    private final String format;

    private final String kmsKeyId;

    private final String progress;

    private final String snapshotId;

    private final String status;

    private final String statusMessage;

    private final String url;

    private final UserBucketDetails userBucket;

    private SnapshotTaskDetail(BuilderImpl builder) {
        this.description = builder.description;
        this.diskImageSize = builder.diskImageSize;
        this.encrypted = builder.encrypted;
        this.format = builder.format;
        this.kmsKeyId = builder.kmsKeyId;
        this.progress = builder.progress;
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    /**
     * <p>
     * The description of the snapshot.
     * </p>
     * 
     * @return The description of the snapshot.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The size of the disk in the snapshot, in GiB.
     * </p>
     * 
     * @return The size of the disk in the snapshot, in GiB.
     */
    public Double diskImageSize() {
        return diskImageSize;
    }

    /**
     * <p>
     * Indicates whether the snapshot is encrypted.
     * </p>
     * 
     * @return Indicates whether the snapshot is encrypted.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The format of the disk image from which the snapshot is created.
     * </p>
     * 
     * @return The format of the disk image from which the snapshot is created.
     */
    public String format() {
        return format;
    }

    /**
     * <p>
     * The identifier for the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to create the
     * encrypted snapshot.
     * </p>
     * 
     * @return The identifier for the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to
     *         create the encrypted snapshot.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The percentage of completion for the import snapshot task.
     * </p>
     * 
     * @return The percentage of completion for the import snapshot task.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * The snapshot ID of the disk being imported.
     * </p>
     * 
     * @return The snapshot ID of the disk being imported.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * A brief status for the import snapshot task.
     * </p>
     * 
     * @return A brief status for the import snapshot task.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A detailed status message for the import snapshot task.
     * </p>
     * 
     * @return A detailed status message for the import snapshot task.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The URL of the disk image from which the snapshot is created.
     * </p>
     * 
     * @return The URL of the disk image from which the snapshot is created.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The S3 bucket for the disk image.
     * </p>
     * 
     * @return The S3 bucket for the disk image.
     */
    public UserBucketDetails userBucket() {
        return userBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(diskImageSize());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(userBucket());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotTaskDetail)) {
            return false;
        }
        SnapshotTaskDetail other = (SnapshotTaskDetail) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(diskImageSize(), other.diskImageSize())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(format(), other.format())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(progress(), other.progress())
                && Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(status(), other.status())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(url(), other.url())
                && Objects.equals(userBucket(), other.userBucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SnapshotTaskDetail").add("Description", description()).add("DiskImageSize", diskImageSize())
                .add("Encrypted", encrypted()).add("Format", format()).add("KmsKeyId", kmsKeyId()).add("Progress", progress())
                .add("SnapshotId", snapshotId()).add("Status", status()).add("StatusMessage", statusMessage()).add("Url", url())
                .add("UserBucket", userBucket()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DiskImageSize":
            return Optional.ofNullable(clazz.cast(diskImageSize()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "UserBucket":
            return Optional.ofNullable(clazz.cast(userBucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotTaskDetail, T> g) {
        return obj -> g.apply((SnapshotTaskDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotTaskDetail> {
        /**
         * <p>
         * The description of the snapshot.
         * </p>
         * 
         * @param description
         *        The description of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The size of the disk in the snapshot, in GiB.
         * </p>
         * 
         * @param diskImageSize
         *        The size of the disk in the snapshot, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskImageSize(Double diskImageSize);

        /**
         * <p>
         * Indicates whether the snapshot is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the snapshot is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The format of the disk image from which the snapshot is created.
         * </p>
         * 
         * @param format
         *        The format of the disk image from which the snapshot is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The identifier for the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to create
         * the encrypted snapshot.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier for the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to
         *        create the encrypted snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The percentage of completion for the import snapshot task.
         * </p>
         * 
         * @param progress
         *        The percentage of completion for the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The snapshot ID of the disk being imported.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot ID of the disk being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * A brief status for the import snapshot task.
         * </p>
         * 
         * @param status
         *        A brief status for the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A detailed status message for the import snapshot task.
         * </p>
         * 
         * @param statusMessage
         *        A detailed status message for the import snapshot task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The URL of the disk image from which the snapshot is created.
         * </p>
         * 
         * @param url
         *        The URL of the disk image from which the snapshot is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The S3 bucket for the disk image.
         * </p>
         * 
         * @param userBucket
         *        The S3 bucket for the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userBucket(UserBucketDetails userBucket);

        /**
         * <p>
         * The S3 bucket for the disk image.
         * </p>
         * This is a convenience that creates an instance of the {@link UserBucketDetails.Builder} avoiding the need to
         * create one manually via {@link UserBucketDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserBucketDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #userBucket(UserBucketDetails)}.
         * 
         * @param userBucket
         *        a consumer that will call methods on {@link UserBucketDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userBucket(UserBucketDetails)
         */
        default Builder userBucket(Consumer<UserBucketDetails.Builder> userBucket) {
            return userBucket(UserBucketDetails.builder().applyMutation(userBucket).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private Double diskImageSize;

        private Boolean encrypted;

        private String format;

        private String kmsKeyId;

        private String progress;

        private String snapshotId;

        private String status;

        private String statusMessage;

        private String url;

        private UserBucketDetails userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotTaskDetail model) {
            description(model.description);
            diskImageSize(model.diskImageSize);
            encrypted(model.encrypted);
            format(model.format);
            kmsKeyId(model.kmsKeyId);
            progress(model.progress);
            snapshotId(model.snapshotId);
            status(model.status);
            statusMessage(model.statusMessage);
            url(model.url);
            userBucket(model.userBucket);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Double getDiskImageSize() {
            return diskImageSize;
        }

        @Override
        public final Builder diskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
            return this;
        }

        public final void setDiskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final UserBucketDetails.Builder getUserBucket() {
            return userBucket != null ? userBucket.toBuilder() : null;
        }

        @Override
        public final Builder userBucket(UserBucketDetails userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        public final void setUserBucket(UserBucketDetails.BuilderImpl userBucket) {
            this.userBucket = userBucket != null ? userBucket.build() : null;
        }

        @Override
        public SnapshotTaskDetail build() {
            return new SnapshotTaskDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
