/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the memory available to the GPU accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GpuDeviceMemoryInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<GpuDeviceMemoryInfo.Builder, GpuDeviceMemoryInfo> {
    private static final SdkField<Integer> SIZE_IN_MIB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GpuDeviceMemoryInfo::sizeInMiB))
            .setter(setter(Builder::sizeInMiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMiB")
                    .unmarshallLocationName("sizeInMiB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_IN_MIB_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer sizeInMiB;

    private GpuDeviceMemoryInfo(BuilderImpl builder) {
        this.sizeInMiB = builder.sizeInMiB;
    }

    /**
     * <p>
     * The size (in MiB) for the memory available to the GPU accelerator.
     * </p>
     * 
     * @return The size (in MiB) for the memory available to the GPU accelerator.
     */
    public Integer sizeInMiB() {
        return sizeInMiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMiB());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GpuDeviceMemoryInfo)) {
            return false;
        }
        GpuDeviceMemoryInfo other = (GpuDeviceMemoryInfo) obj;
        return Objects.equals(sizeInMiB(), other.sizeInMiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GpuDeviceMemoryInfo").add("SizeInMiB", sizeInMiB()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizeInMiB":
            return Optional.ofNullable(clazz.cast(sizeInMiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GpuDeviceMemoryInfo, T> g) {
        return obj -> g.apply((GpuDeviceMemoryInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GpuDeviceMemoryInfo> {
        /**
         * <p>
         * The size (in MiB) for the memory available to the GPU accelerator.
         * </p>
         * 
         * @param sizeInMiB
         *        The size (in MiB) for the memory available to the GPU accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInMiB(Integer sizeInMiB);
    }

    static final class BuilderImpl implements Builder {
        private Integer sizeInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(GpuDeviceMemoryInfo model) {
            sizeInMiB(model.sizeInMiB);
        }

        public final Integer getSizeInMiB() {
            return sizeInMiB;
        }

        @Override
        public final Builder sizeInMiB(Integer sizeInMiB) {
            this.sizeInMiB = sizeInMiB;
            return this;
        }

        public final void setSizeInMiB(Integer sizeInMiB) {
            this.sizeInMiB = sizeInMiB;
        }

        @Override
        public GpuDeviceMemoryInfo build() {
            return new GpuDeviceMemoryInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
