/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcEndpointServiceConfigurationResponse extends Ec2Response implements
        ToCopyableBuilder<CreateVpcEndpointServiceConfigurationResponse.Builder, CreateVpcEndpointServiceConfigurationResponse> {
    private static final SdkField<ServiceConfiguration> SERVICE_CONFIGURATION_FIELD = SdkField
            .<ServiceConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateVpcEndpointServiceConfigurationResponse::serviceConfiguration))
            .setter(setter(Builder::serviceConfiguration))
            .constructor(ServiceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceConfiguration")
                    .unmarshallLocationName("serviceConfiguration").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpcEndpointServiceConfigurationResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CONFIGURATION_FIELD,
            CLIENT_TOKEN_FIELD));

    private final ServiceConfiguration serviceConfiguration;

    private final String clientToken;

    private CreateVpcEndpointServiceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.serviceConfiguration = builder.serviceConfiguration;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the service configuration.
     * </p>
     * 
     * @return Information about the service configuration.
     */
    public ServiceConfiguration serviceConfiguration() {
        return serviceConfiguration;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointServiceConfigurationResponse)) {
            return false;
        }
        CreateVpcEndpointServiceConfigurationResponse other = (CreateVpcEndpointServiceConfigurationResponse) obj;
        return Objects.equals(serviceConfiguration(), other.serviceConfiguration())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVpcEndpointServiceConfigurationResponse")
                .add("ServiceConfiguration", serviceConfiguration()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceConfiguration":
            return Optional.ofNullable(clazz.cast(serviceConfiguration()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointServiceConfigurationResponse, T> g) {
        return obj -> g.apply((CreateVpcEndpointServiceConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcEndpointServiceConfigurationResponse> {
        /**
         * <p>
         * Information about the service configuration.
         * </p>
         * 
         * @param serviceConfiguration
         *        Information about the service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceConfiguration(ServiceConfiguration serviceConfiguration);

        /**
         * <p>
         * Information about the service configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceConfiguration.Builder} avoiding the need
         * to create one manually via {@link ServiceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceConfiguration(ServiceConfiguration)}.
         * 
         * @param serviceConfiguration
         *        a consumer that will call methods on {@link ServiceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceConfiguration(ServiceConfiguration)
         */
        default Builder serviceConfiguration(Consumer<ServiceConfiguration.Builder> serviceConfiguration) {
            return serviceConfiguration(ServiceConfiguration.builder().applyMutation(serviceConfiguration).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private ServiceConfiguration serviceConfiguration;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointServiceConfigurationResponse model) {
            super(model);
            serviceConfiguration(model.serviceConfiguration);
            clientToken(model.clientToken);
        }

        public final ServiceConfiguration.Builder getServiceConfiguration() {
            return serviceConfiguration != null ? serviceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder serviceConfiguration(ServiceConfiguration serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
            return this;
        }

        public final void setServiceConfiguration(ServiceConfiguration.BuilderImpl serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration != null ? serviceConfiguration.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateVpcEndpointServiceConfigurationResponse build() {
            return new CreateVpcEndpointServiceConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
