/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssociatedIpv6PoolCidrsResponse extends Ec2Response implements
        ToCopyableBuilder<GetAssociatedIpv6PoolCidrsResponse.Builder, GetAssociatedIpv6PoolCidrsResponse> {
    private static final SdkField<List<Ipv6CidrAssociation>> IPV6_CIDR_ASSOCIATIONS_FIELD = SdkField
            .<List<Ipv6CidrAssociation>> builder(MarshallingType.LIST)
            .getter(getter(GetAssociatedIpv6PoolCidrsResponse::ipv6CidrAssociations))
            .setter(setter(Builder::ipv6CidrAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrAssociationSet")
                    .unmarshallLocationName("ipv6CidrAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv6CidrAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6CidrAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetAssociatedIpv6PoolCidrsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_CIDR_ASSOCIATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Ipv6CidrAssociation> ipv6CidrAssociations;

    private final String nextToken;

    private GetAssociatedIpv6PoolCidrsResponse(BuilderImpl builder) {
        super(builder);
        this.ipv6CidrAssociations = builder.ipv6CidrAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Ipv6CidrAssociations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasIpv6CidrAssociations() {
        return ipv6CidrAssociations != null && !(ipv6CidrAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv6 CIDR block associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6CidrAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the IPv6 CIDR block associations.
     */
    public List<Ipv6CidrAssociation> ipv6CidrAssociations() {
        return ipv6CidrAssociations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedIpv6PoolCidrsResponse)) {
            return false;
        }
        GetAssociatedIpv6PoolCidrsResponse other = (GetAssociatedIpv6PoolCidrsResponse) obj;
        return Objects.equals(ipv6CidrAssociations(), other.ipv6CidrAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAssociatedIpv6PoolCidrsResponse").add("Ipv6CidrAssociations", ipv6CidrAssociations())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6CidrAssociations":
            return Optional.ofNullable(clazz.cast(ipv6CidrAssociations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedIpv6PoolCidrsResponse, T> g) {
        return obj -> g.apply((GetAssociatedIpv6PoolCidrsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetAssociatedIpv6PoolCidrsResponse> {
        /**
         * <p>
         * Information about the IPv6 CIDR block associations.
         * </p>
         * 
         * @param ipv6CidrAssociations
         *        Information about the IPv6 CIDR block associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrAssociations(Collection<Ipv6CidrAssociation> ipv6CidrAssociations);

        /**
         * <p>
         * Information about the IPv6 CIDR block associations.
         * </p>
         * 
         * @param ipv6CidrAssociations
         *        Information about the IPv6 CIDR block associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrAssociations(Ipv6CidrAssociation... ipv6CidrAssociations);

        /**
         * <p>
         * Information about the IPv6 CIDR block associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ipv6CidrAssociation>.Builder} avoiding the
         * need to create one manually via {@link List<Ipv6CidrAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ipv6CidrAssociation>.Builder#build()} is called immediately
         * and its result is passed to {@link #ipv6CidrAssociations(List<Ipv6CidrAssociation>)}.
         * 
         * @param ipv6CidrAssociations
         *        a consumer that will call methods on {@link List<Ipv6CidrAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrAssociations(List<Ipv6CidrAssociation>)
         */
        Builder ipv6CidrAssociations(Consumer<Ipv6CidrAssociation.Builder>... ipv6CidrAssociations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<Ipv6CidrAssociation> ipv6CidrAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedIpv6PoolCidrsResponse model) {
            super(model);
            ipv6CidrAssociations(model.ipv6CidrAssociations);
            nextToken(model.nextToken);
        }

        public final Collection<Ipv6CidrAssociation.Builder> getIpv6CidrAssociations() {
            return ipv6CidrAssociations != null ? ipv6CidrAssociations.stream().map(Ipv6CidrAssociation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6CidrAssociations(Collection<Ipv6CidrAssociation> ipv6CidrAssociations) {
            this.ipv6CidrAssociations = Ipv6CidrAssociationSetCopier.copy(ipv6CidrAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrAssociations(Ipv6CidrAssociation... ipv6CidrAssociations) {
            ipv6CidrAssociations(Arrays.asList(ipv6CidrAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrAssociations(Consumer<Ipv6CidrAssociation.Builder>... ipv6CidrAssociations) {
            ipv6CidrAssociations(Stream.of(ipv6CidrAssociations).map(c -> Ipv6CidrAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6CidrAssociations(Collection<Ipv6CidrAssociation.BuilderImpl> ipv6CidrAssociations) {
            this.ipv6CidrAssociations = Ipv6CidrAssociationSetCopier.copyFromBuilder(ipv6CidrAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetAssociatedIpv6PoolCidrsResponse build() {
            return new GetAssociatedIpv6PoolCidrsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
