/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportKeyPairRequest extends Ec2Request implements
        ToCopyableBuilder<ImportKeyPairRequest.Builder, ImportKeyPairRequest> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImportKeyPairRequest::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("keyName").build()).build();

    private static final SdkField<SdkBytes> PUBLIC_KEY_MATERIAL_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(ImportKeyPairRequest::publicKeyMaterial))
            .setter(setter(Builder::publicKeyMaterial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyMaterial")
                    .unmarshallLocationName("publicKeyMaterial").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD,
            PUBLIC_KEY_MATERIAL_FIELD));

    private final String keyName;

    private final SdkBytes publicKeyMaterial;

    private ImportKeyPairRequest(BuilderImpl builder) {
        super(builder);
        this.keyName = builder.keyName;
        this.publicKeyMaterial = builder.publicKeyMaterial;
    }

    /**
     * <p>
     * A unique name for the key pair.
     * </p>
     * 
     * @return A unique name for the key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is
     * performed for you.
     * </p>
     * 
     * @return The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding
     *         is performed for you.
     */
    public SdkBytes publicKeyMaterial() {
        return publicKeyMaterial;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyMaterial());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairRequest)) {
            return false;
        }
        ImportKeyPairRequest other = (ImportKeyPairRequest) obj;
        return Objects.equals(keyName(), other.keyName()) && Objects.equals(publicKeyMaterial(), other.publicKeyMaterial());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportKeyPairRequest").add("KeyName", keyName()).add("PublicKeyMaterial", publicKeyMaterial())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "PublicKeyMaterial":
            return Optional.ofNullable(clazz.cast(publicKeyMaterial()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportKeyPairRequest, T> g) {
        return obj -> g.apply((ImportKeyPairRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ImportKeyPairRequest> {
        /**
         * <p>
         * A unique name for the key pair.
         * </p>
         * 
         * @param keyName
         *        A unique name for the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is
         * performed for you.
         * </p>
         * 
         * @param publicKeyMaterial
         *        The public key. For API calls, the text must be base64-encoded. For command line tools, base64
         *        encoding is performed for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyMaterial(SdkBytes publicKeyMaterial);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String keyName;

        private SdkBytes publicKeyMaterial;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairRequest model) {
            super(model);
            keyName(model.keyName);
            publicKeyMaterial(model.publicKeyMaterial);
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final ByteBuffer getPublicKeyMaterial() {
            return publicKeyMaterial == null ? null : publicKeyMaterial.asByteBuffer();
        }

        @Override
        public final Builder publicKeyMaterial(SdkBytes publicKeyMaterial) {
            this.publicKeyMaterial = StandardMemberCopier.copy(publicKeyMaterial);
            return this;
        }

        public final void setPublicKeyMaterial(ByteBuffer publicKeyMaterial) {
            publicKeyMaterial(publicKeyMaterial == null ? null : SdkBytes.fromByteBuffer(publicKeyMaterial));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportKeyPairRequest build() {
            return new ImportKeyPairRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
