/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance listing state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceCount implements SdkPojo, Serializable, ToCopyableBuilder<InstanceCount.Builder, InstanceCount> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InstanceCount::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("instanceCount").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceCount::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD,
            STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer instanceCount;

    private final String state;

    private InstanceCount(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.state = builder.state;
    }

    /**
     * <p>
     * The number of listed Reserved Instances in the state specified by the <code>state</code>.
     * </p>
     * 
     * @return The number of listed Reserved Instances in the state specified by the <code>state</code>.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The states of the listed Reserved Instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ListingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The states of the listed Reserved Instances.
     * @see ListingState
     */
    public ListingState state() {
        return ListingState.fromValue(state);
    }

    /**
     * <p>
     * The states of the listed Reserved Instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ListingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The states of the listed Reserved Instances.
     * @see ListingState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCount)) {
            return false;
        }
        InstanceCount other = (InstanceCount) obj;
        return Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceCount").add("InstanceCount", instanceCount()).add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceCount, T> g) {
        return obj -> g.apply((InstanceCount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceCount> {
        /**
         * <p>
         * The number of listed Reserved Instances in the state specified by the <code>state</code>.
         * </p>
         * 
         * @param instanceCount
         *        The number of listed Reserved Instances in the state specified by the <code>state</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The states of the listed Reserved Instances.
         * </p>
         * 
         * @param state
         *        The states of the listed Reserved Instances.
         * @see ListingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingState
         */
        Builder state(String state);

        /**
         * <p>
         * The states of the listed Reserved Instances.
         * </p>
         * 
         * @param state
         *        The states of the listed Reserved Instances.
         * @see ListingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingState
         */
        Builder state(ListingState state);
    }

    static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCount model) {
            instanceCount(model.instanceCount);
            state(model.state);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ListingState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public InstanceCount build() {
            return new InstanceCount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
