/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeFleetsRequest.Builder, DescribeFleetsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeFleetsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<String>> FLEET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeFleetsRequest::fleetIds))
            .setter(setter(Builder::fleetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId")
                    .unmarshallLocationName("FleetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeFleetsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, FLEET_IDS_FIELD, FILTERS_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> fleetIds;

    private final List<Filter> filters;

    private DescribeFleetsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.fleetIds = builder.fleetIds;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value
     * is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default
     *         value is 1000. To retrieve the remaining results, make another call with the returned
     *         <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the FleetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFleetIds() {
        return fleetIds != null && !(fleetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the EC2 Fleets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFleetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ID of the EC2 Fleets.
     */
    public List<String> fleetIds() {
        return fleetIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
     * <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the target
     * capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
     * <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code> |
     * <code>modifying</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (
     * <code>true</code> | <code>false</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
     *         <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the
     *         target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
     *         <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> |
     *         <code>deleted-terminating</code> | <code>modifying</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances
     *         (<code>true</code> | <code>false</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code> - The type of request (<code>instant</code> | <code>request</code> |
     *         <code>maintain</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(fleetIds());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetsRequest)) {
            return false;
        }
        DescribeFleetsRequest other = (DescribeFleetsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(fleetIds(), other.fleetIds()) && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeFleetsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("FleetIds", fleetIds()).add("Filters", filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FleetIds":
            return Optional.ofNullable(clazz.cast(fleetIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetsRequest, T> g) {
        return obj -> g.apply((DescribeFleetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFleetsRequest> {
        /**
         * <p>
         * The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default
         * value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code>
         * value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. Specify a value between 1 and 1000. The
         *        default value is 1000. To retrieve the remaining results, make another call with the returned
         *        <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the EC2 Fleets.
         * </p>
         * 
         * @param fleetIds
         *        The ID of the EC2 Fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(Collection<String> fleetIds);

        /**
         * <p>
         * The ID of the EC2 Fleets.
         * </p>
         * 
         * @param fleetIds
         *        The ID of the EC2 Fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(String... fleetIds);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
         * <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the
         * target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
         * <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code>
         * | <code>modifying</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (
         * <code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>
         * ).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
         *        <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if
         *        the target capacity is decreased below the current EC2 Fleet size (<code>true</code> |
         *        <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
         *        <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> |
         *        <code>deleted-terminating</code> | <code>modifying</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy
         *        instances (<code>true</code> | <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of request (<code>instant</code> | <code>request</code> |
         *        <code>maintain</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
         * <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the
         * target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
         * <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code>
         * | <code>modifying</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (
         * <code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>
         * ).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
         *        <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if
         *        the target capacity is decreased below the current EC2 Fleet size (<code>true</code> |
         *        <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
         *        <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> |
         *        <code>deleted-terminating</code> | <code>modifying</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy
         *        instances (<code>true</code> | <code>false</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of request (<code>instant</code> | <code>request</code> |
         *        <code>maintain</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
         * <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the
         * target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> |
         * <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code>
         * | <code>modifying</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (
         * <code>true</code> | <code>false</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>
         * ).
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private List<String> fleetIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            fleetIds(model.fleetIds);
            filters(model.filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getFleetIds() {
            return fleetIds;
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdSetCopier.copy(fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String... fleetIds) {
            fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdSetCopier.copy(fleetIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFleetsRequest build() {
            return new DescribeFleetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
