/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterface.Builder, NetworkInterface> {
    private static final SdkField<NetworkInterfaceAssociation> ASSOCIATION_FIELD = SdkField
            .<NetworkInterfaceAssociation> builder(MarshallingType.SDK_POJO)
            .getter(getter(NetworkInterface::association))
            .setter(setter(Builder::association))
            .constructor(NetworkInterfaceAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association")
                    .unmarshallLocationName("association").build()).build();

    private static final SdkField<NetworkInterfaceAttachment> ATTACHMENT_FIELD = SdkField
            .<NetworkInterfaceAttachment> builder(MarshallingType.SDK_POJO)
            .getter(getter(NetworkInterface::attachment))
            .setter(setter(Builder::attachment))
            .constructor(NetworkInterfaceAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment")
                    .unmarshallLocationName("attachment").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<GroupIdentifier>> GROUPS_FIELD = SdkField
            .<List<GroupIdentifier>> builder(MarshallingType.LIST)
            .getter(getter(NetworkInterface::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet")
                    .unmarshallLocationName("groupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<GroupIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::interfaceTypeAsString))
            .setter(setter(Builder::interfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType")
                    .unmarshallLocationName("interfaceType").build()).build();

    private static final SdkField<List<NetworkInterfaceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<NetworkInterfaceIpv6Address>> builder(MarshallingType.LIST)
            .getter(getter(NetworkInterface::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressesSet")
                    .unmarshallLocationName("ipv6AddressesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NetworkInterfaceIpv6Address> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterfaceIpv6Address::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::macAddress))
            .setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress")
                    .unmarshallLocationName("macAddress").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName")
                    .unmarshallLocationName("privateDnsName").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final SdkField<List<NetworkInterfacePrivateIpAddress>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<NetworkInterfacePrivateIpAddress>> builder(MarshallingType.LIST)
            .getter(getter(NetworkInterface::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressesSet")
                    .unmarshallLocationName("privateIpAddressesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NetworkInterfacePrivateIpAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterfacePrivateIpAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> REQUESTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::requesterId))
            .setter(setter(Builder::requesterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterId")
                    .unmarshallLocationName("requesterId").build()).build();

    private static final SdkField<Boolean> REQUESTER_MANAGED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(NetworkInterface::requesterManaged))
            .setter(setter(Builder::requesterManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterManaged")
                    .unmarshallLocationName("requesterManaged").build()).build();

    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(NetworkInterface::sourceDestCheck))
            .setter(setter(Builder::sourceDestCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck")
                    .unmarshallLocationName("sourceDestCheck").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<List<Tag>> TAG_SET_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(NetworkInterface::tagSet))
            .setter(setter(Builder::tagSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD,
            ATTACHMENT_FIELD, AVAILABILITY_ZONE_FIELD, DESCRIPTION_FIELD, GROUPS_FIELD, INTERFACE_TYPE_FIELD,
            IPV6_ADDRESSES_FIELD, MAC_ADDRESS_FIELD, NETWORK_INTERFACE_ID_FIELD, OUTPOST_ARN_FIELD, OWNER_ID_FIELD,
            PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, REQUESTER_ID_FIELD,
            REQUESTER_MANAGED_FIELD, SOURCE_DEST_CHECK_FIELD, STATUS_FIELD, SUBNET_ID_FIELD, TAG_SET_FIELD, VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final NetworkInterfaceAssociation association;

    private final NetworkInterfaceAttachment attachment;

    private final String availabilityZone;

    private final String description;

    private final List<GroupIdentifier> groups;

    private final String interfaceType;

    private final List<NetworkInterfaceIpv6Address> ipv6Addresses;

    private final String macAddress;

    private final String networkInterfaceId;

    private final String outpostArn;

    private final String ownerId;

    private final String privateDnsName;

    private final String privateIpAddress;

    private final List<NetworkInterfacePrivateIpAddress> privateIpAddresses;

    private final String requesterId;

    private final Boolean requesterManaged;

    private final Boolean sourceDestCheck;

    private final String status;

    private final String subnetId;

    private final List<Tag> tagSet;

    private final String vpcId;

    private NetworkInterface(BuilderImpl builder) {
        this.association = builder.association;
        this.attachment = builder.attachment;
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.groups = builder.groups;
        this.interfaceType = builder.interfaceType;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.macAddress = builder.macAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.outpostArn = builder.outpostArn;
        this.ownerId = builder.ownerId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.requesterId = builder.requesterId;
        this.requesterManaged = builder.requesterManaged;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.tagSet = builder.tagSet;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The association information for an Elastic IP address (IPv4) associated with the network interface.
     * </p>
     * 
     * @return The association information for an Elastic IP address (IPv4) associated with the network interface.
     */
    public NetworkInterfaceAssociation association() {
        return association;
    }

    /**
     * <p>
     * The network interface attachment.
     * </p>
     * 
     * @return The network interface attachment.
     */
    public NetworkInterfaceAttachment attachment() {
        return attachment;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A description.
     * </p>
     * 
     * @return A description.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Groups property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any security groups for the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any security groups for the network interface.
     */
    public List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * The type of network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link NetworkInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return The type of network interface.
     * @see NetworkInterfaceType
     */
    public NetworkInterfaceType interfaceType() {
        return NetworkInterfaceType.fromValue(interfaceType);
    }

    /**
     * <p>
     * The type of network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link NetworkInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return The type of network interface.
     * @see NetworkInterfaceType
     */
    public String interfaceTypeAsString() {
        return interfaceType;
    }

    /**
     * Returns true if the Ipv6Addresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6Addresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv6 addresses associated with the network interface.
     */
    public List<NetworkInterfaceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The MAC address.
     * </p>
     * 
     * @return The MAC address.
     */
    public String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost.
     */
    public String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the network interface.
     * </p>
     * 
     * @return The AWS account ID of the owner of the network interface.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The private DNS name.
     * </p>
     * 
     * @return The private DNS name.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The IPv4 address of the network interface within the subnet.
     * </p>
     * 
     * @return The IPv4 address of the network interface within the subnet.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * Returns true if the PrivateIpAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The private IPv4 addresses associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrivateIpAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The private IPv4 addresses associated with the network interface.
     */
    public List<NetworkInterfacePrivateIpAddress> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The ID of the entity that launched the instance on your behalf (for example, AWS Management Console or Auto
     * Scaling).
     * </p>
     * 
     * @return The ID of the entity that launched the instance on your behalf (for example, AWS Management Console or
     *         Auto Scaling).
     */
    public String requesterId() {
        return requesterId;
    }

    /**
     * <p>
     * Indicates whether the network interface is being managed by AWS.
     * </p>
     * 
     * @return Indicates whether the network interface is being managed by AWS.
     */
    public Boolean requesterManaged() {
        return requesterManaged;
    }

    /**
     * <p>
     * Indicates whether traffic to or from the instance is validated.
     * </p>
     * 
     * @return Indicates whether traffic to or from the instance is validated.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * The status of the network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkInterfaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network interface.
     * @see NetworkInterfaceStatus
     */
    public NetworkInterfaceStatus status() {
        return NetworkInterfaceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkInterfaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the network interface.
     * @see NetworkInterfaceStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * Returns true if the TagSet property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTagSet() {
        return tagSet != null && !(tagSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the network interface.
     */
    public List<Tag> tagSet() {
        return tagSet;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(association());
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(requesterId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterManaged());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(tagSet());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface) obj;
        return Objects.equals(association(), other.association()) && Objects.equals(attachment(), other.attachment())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(description(), other.description()) && Objects.equals(groups(), other.groups())
                && Objects.equals(interfaceTypeAsString(), other.interfaceTypeAsString())
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(macAddress(), other.macAddress())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(outpostArn(), other.outpostArn()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(requesterId(), other.requesterId())
                && Objects.equals(requesterManaged(), other.requesterManaged())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(tagSet(), other.tagSet()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkInterface").add("Association", association()).add("Attachment", attachment())
                .add("AvailabilityZone", availabilityZone()).add("Description", description()).add("Groups", groups())
                .add("InterfaceType", interfaceTypeAsString()).add("Ipv6Addresses", ipv6Addresses())
                .add("MacAddress", macAddress()).add("NetworkInterfaceId", networkInterfaceId()).add("OutpostArn", outpostArn())
                .add("OwnerId", ownerId()).add("PrivateDnsName", privateDnsName()).add("PrivateIpAddress", privateIpAddress())
                .add("PrivateIpAddresses", privateIpAddresses()).add("RequesterId", requesterId())
                .add("RequesterManaged", requesterManaged()).add("SourceDestCheck", sourceDestCheck())
                .add("Status", statusAsString()).add("SubnetId", subnetId()).add("TagSet", tagSet()).add("VpcId", vpcId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Association":
            return Optional.ofNullable(clazz.cast(association()));
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "InterfaceType":
            return Optional.ofNullable(clazz.cast(interfaceTypeAsString()));
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "MacAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "RequesterId":
            return Optional.ofNullable(clazz.cast(requesterId()));
        case "RequesterManaged":
            return Optional.ofNullable(clazz.cast(requesterManaged()));
        case "SourceDestCheck":
            return Optional.ofNullable(clazz.cast(sourceDestCheck()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "TagSet":
            return Optional.ofNullable(clazz.cast(tagSet()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterface> {
        /**
         * <p>
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         * </p>
         * 
         * @param association
         *        The association information for an Elastic IP address (IPv4) associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(NetworkInterfaceAssociation association);

        /**
         * <p>
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInterfaceAssociation.Builder} avoiding
         * the need to create one manually via {@link NetworkInterfaceAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInterfaceAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #association(NetworkInterfaceAssociation)}.
         * 
         * @param association
         *        a consumer that will call methods on {@link NetworkInterfaceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #association(NetworkInterfaceAssociation)
         */
        default Builder association(Consumer<NetworkInterfaceAssociation.Builder> association) {
            return association(NetworkInterfaceAssociation.builder().applyMutation(association).build());
        }

        /**
         * <p>
         * The network interface attachment.
         * </p>
         * 
         * @param attachment
         *        The network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(NetworkInterfaceAttachment attachment);

        /**
         * <p>
         * The network interface attachment.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInterfaceAttachment.Builder} avoiding the
         * need to create one manually via {@link NetworkInterfaceAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInterfaceAttachment.Builder#build()} is called immediately
         * and its result is passed to {@link #attachment(NetworkInterfaceAttachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link NetworkInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(NetworkInterfaceAttachment)
         */
        default Builder attachment(Consumer<NetworkInterfaceAttachment.Builder> attachment) {
            return attachment(NetworkInterfaceAttachment.builder().applyMutation(attachment).build());
        }

        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A description.
         * </p>
         * 
         * @param description
         *        A description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Any security groups for the network interface.
         * </p>
         * 
         * @param groups
         *        Any security groups for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * Any security groups for the network interface.
         * </p>
         * 
         * @param groups
         *        Any security groups for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * Any security groups for the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupIdentifier>.Builder} avoiding the need
         * to create one manually via {@link List<GroupIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupIdentifier>.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<GroupIdentifier>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<GroupIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<GroupIdentifier>)
         */
        Builder groups(Consumer<GroupIdentifier.Builder>... groups);

        /**
         * <p>
         * The type of network interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of network interface.
         * @see NetworkInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceType
         */
        Builder interfaceType(String interfaceType);

        /**
         * <p>
         * The type of network interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of network interface.
         * @see NetworkInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceType
         */
        Builder interfaceType(NetworkInterfaceType interfaceType);

        /**
         * <p>
         * The IPv6 addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(NetworkInterfaceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses associated with the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkInterfaceIpv6Address>.Builder}
         * avoiding the need to create one manually via {@link List<NetworkInterfaceIpv6Address>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkInterfaceIpv6Address>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6Addresses(List<NetworkInterfaceIpv6Address>)}.
         * 
         * @param ipv6Addresses
         *        a consumer that will call methods on {@link List<NetworkInterfaceIpv6Address>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Addresses(List<NetworkInterfaceIpv6Address>)
         */
        Builder ipv6Addresses(Consumer<NetworkInterfaceIpv6Address.Builder>... ipv6Addresses);

        /**
         * <p>
         * The MAC address.
         * </p>
         * 
         * @param macAddress
         *        The MAC address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The AWS account ID of the owner of the network interface.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the owner of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The private DNS name.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The IPv4 address of the network interface within the subnet.
         * </p>
         * 
         * @param privateIpAddress
         *        The IPv4 address of the network interface within the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The private IPv4 addresses associated with the network interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses);

        /**
         * <p>
         * The private IPv4 addresses associated with the network interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(NetworkInterfacePrivateIpAddress... privateIpAddresses);

        /**
         * <p>
         * The private IPv4 addresses associated with the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkInterfacePrivateIpAddress>.Builder}
         * avoiding the need to create one manually via {@link List<NetworkInterfacePrivateIpAddress>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkInterfacePrivateIpAddress>.Builder#build()} is called
         * immediately and its result is passed to {@link #privateIpAddresses(List<NetworkInterfacePrivateIpAddress>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on {@link List<NetworkInterfacePrivateIpAddress>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(List<NetworkInterfacePrivateIpAddress>)
         */
        Builder privateIpAddresses(Consumer<NetworkInterfacePrivateIpAddress.Builder>... privateIpAddresses);

        /**
         * <p>
         * The ID of the entity that launched the instance on your behalf (for example, AWS Management Console or Auto
         * Scaling).
         * </p>
         * 
         * @param requesterId
         *        The ID of the entity that launched the instance on your behalf (for example, AWS Management Console or
         *        Auto Scaling).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterId(String requesterId);

        /**
         * <p>
         * Indicates whether the network interface is being managed by AWS.
         * </p>
         * 
         * @param requesterManaged
         *        Indicates whether the network interface is being managed by AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterManaged(Boolean requesterManaged);

        /**
         * <p>
         * Indicates whether traffic to or from the instance is validated.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether traffic to or from the instance is validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * The status of the network interface.
         * </p>
         * 
         * @param status
         *        The status of the network interface.
         * @see NetworkInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the network interface.
         * </p>
         * 
         * @param status
         *        The status of the network interface.
         * @see NetworkInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceStatus
         */
        Builder status(NetworkInterfaceStatus status);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Any tags assigned to the network interface.
         * </p>
         * 
         * @param tagSet
         *        Any tags assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSet(Collection<Tag> tagSet);

        /**
         * <p>
         * Any tags assigned to the network interface.
         * </p>
         * 
         * @param tagSet
         *        Any tags assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSet(Tag... tagSet);

        /**
         * <p>
         * Any tags assigned to the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tagSet(List<Tag>)}.
         * 
         * @param tagSet
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSet(List<Tag>)
         */
        Builder tagSet(Consumer<Tag.Builder>... tagSet);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private NetworkInterfaceAssociation association;

        private NetworkInterfaceAttachment attachment;

        private String availabilityZone;

        private String description;

        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();

        private String interfaceType;

        private List<NetworkInterfaceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String macAddress;

        private String networkInterfaceId;

        private String outpostArn;

        private String ownerId;

        private String privateDnsName;

        private String privateIpAddress;

        private List<NetworkInterfacePrivateIpAddress> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private String requesterId;

        private Boolean requesterManaged;

        private Boolean sourceDestCheck;

        private String status;

        private String subnetId;

        private List<Tag> tagSet = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            association(model.association);
            attachment(model.attachment);
            availabilityZone(model.availabilityZone);
            description(model.description);
            groups(model.groups);
            interfaceType(model.interfaceType);
            ipv6Addresses(model.ipv6Addresses);
            macAddress(model.macAddress);
            networkInterfaceId(model.networkInterfaceId);
            outpostArn(model.outpostArn);
            ownerId(model.ownerId);
            privateDnsName(model.privateDnsName);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            requesterId(model.requesterId);
            requesterManaged(model.requesterManaged);
            sourceDestCheck(model.sourceDestCheck);
            status(model.status);
            subnetId(model.subnetId);
            tagSet(model.tagSet);
            vpcId(model.vpcId);
        }

        public final NetworkInterfaceAssociation.Builder getAssociation() {
            return association != null ? association.toBuilder() : null;
        }

        @Override
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(NetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        public final NetworkInterfaceAttachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(NetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return groups != null ? groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final String getInterfaceTypeAsString() {
            return interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(NetworkInterfaceType interfaceType) {
            this.interfaceType(interfaceType == null ? null : interfaceType.toString());
            return this;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        public final Collection<NetworkInterfaceIpv6Address.Builder> getIpv6Addresses() {
            return ipv6Addresses != null ? ipv6Addresses.stream().map(NetworkInterfaceIpv6Address::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Addresses(Collection<NetworkInterfaceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(NetworkInterfaceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<NetworkInterfaceIpv6Address.Builder>... ipv6Addresses) {
            ipv6Addresses(Stream.of(ipv6Addresses).map(c -> NetworkInterfaceIpv6Address.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Addresses(Collection<NetworkInterfaceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = NetworkInterfaceIpv6AddressesListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getMacAddress() {
            return macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<NetworkInterfacePrivateIpAddress.Builder> getPrivateIpAddresses() {
            return privateIpAddresses != null ? privateIpAddresses.stream().map(NetworkInterfacePrivateIpAddress::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder privateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(NetworkInterfacePrivateIpAddress... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<NetworkInterfacePrivateIpAddress.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses)
                    .map(c -> NetworkInterfacePrivateIpAddress.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<NetworkInterfacePrivateIpAddress.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = NetworkInterfacePrivateIpAddressListCopier.copyFromBuilder(privateIpAddresses);
        }

        public final String getRequesterId() {
            return requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        public final Boolean getRequesterManaged() {
            return requesterManaged;
        }

        @Override
        public final Builder requesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
            return this;
        }

        public final void setRequesterManaged(Boolean requesterManaged) {
            this.requesterManaged = requesterManaged;
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkInterfaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<Tag.Builder> getTagSet() {
            return tagSet != null ? tagSet.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSet(Collection<Tag> tagSet) {
            this.tagSet = TagListCopier.copy(tagSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Tag... tagSet) {
            tagSet(Arrays.asList(tagSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Consumer<Tag.Builder>... tagSet) {
            tagSet(Stream.of(tagSet).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSet(Collection<Tag.BuilderImpl> tagSet) {
            this.tagSet = TagListCopier.copyFromBuilder(tagSet);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
