/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSecurityGroupRequest extends Ec2Request implements
        ToCopyableBuilder<CreateSecurityGroupRequest.Builder, CreateSecurityGroupRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSecurityGroupRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDescription")
                    .unmarshallLocationName("GroupDescription").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSecurityGroupRequest::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("GroupName").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSecurityGroupRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            GROUP_NAME_FIELD, VPC_ID_FIELD));

    private final String description;

    private final String groupName;

    private final String vpcId;

    private CreateSecurityGroupRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.groupName = builder.groupName;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * A description for the security group. This is informational only.
     * </p>
     * <p>
     * Constraints: Up to 255 characters in length
     * </p>
     * <p>
     * Constraints for EC2-Classic: ASCII characters
     * </p>
     * <p>
     * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
     * </p>
     * 
     * @return A description for the security group. This is informational only.</p>
     *         <p>
     *         Constraints: Up to 255 characters in length
     *         </p>
     *         <p>
     *         Constraints for EC2-Classic: ASCII characters
     *         </p>
     *         <p>
     *         Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * <p>
     * Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code>.
     * </p>
     * <p>
     * Constraints for EC2-Classic: ASCII characters
     * </p>
     * <p>
     * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
     * </p>
     * 
     * @return The name of the security group.</p>
     *         <p>
     *         Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code>.
     *         </p>
     *         <p>
     *         Constraints for EC2-Classic: ASCII characters
     *         </p>
     *         <p>
     *         Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityGroupRequest)) {
            return false;
        }
        CreateSecurityGroupRequest other = (CreateSecurityGroupRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSecurityGroupRequest").add("Description", description()).add("GroupName", groupName())
                .add("VpcId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSecurityGroupRequest, T> g) {
        return obj -> g.apply((CreateSecurityGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateSecurityGroupRequest> {
        /**
         * <p>
         * A description for the security group. This is informational only.
         * </p>
         * <p>
         * Constraints: Up to 255 characters in length
         * </p>
         * <p>
         * Constraints for EC2-Classic: ASCII characters
         * </p>
         * <p>
         * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
         * </p>
         * 
         * @param description
         *        A description for the security group. This is informational only.</p>
         *        <p>
         *        Constraints: Up to 255 characters in length
         *        </p>
         *        <p>
         *        Constraints for EC2-Classic: ASCII characters
         *        </p>
         *        <p>
         *        Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the security group.
         * </p>
         * <p>
         * Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code>.
         * </p>
         * <p>
         * Constraints for EC2-Classic: ASCII characters
         * </p>
         * <p>
         * Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
         * </p>
         * 
         * @param groupName
         *        The name of the security group.</p>
         *        <p>
         *        Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code>.
         *        </p>
         *        <p>
         *        Constraints for EC2-Classic: ASCII characters
         *        </p>
         *        <p>
         *        Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
         * </p>
         * 
         * @param vpcId
         *        [EC2-VPC] The ID of the VPC. Required for EC2-VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String description;

        private String groupName;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityGroupRequest model) {
            super(model);
            description(model.description);
            groupName(model.groupName);
            vpcId(model.vpcId);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSecurityGroupRequest build() {
            return new CreateSecurityGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
