/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIpv6PoolsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeIpv6PoolsResponse.Builder, DescribeIpv6PoolsResponse> {
    private static final SdkField<List<Ipv6Pool>> IPV6_POOLS_FIELD = SdkField
            .<List<Ipv6Pool>> builder(MarshallingType.LIST)
            .getter(getter(DescribeIpv6PoolsResponse::ipv6Pools))
            .setter(setter(Builder::ipv6Pools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PoolSet")
                    .unmarshallLocationName("ipv6PoolSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Ipv6Pool> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ipv6Pool::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIpv6PoolsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_POOLS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Ipv6Pool> ipv6Pools;

    private final String nextToken;

    private DescribeIpv6PoolsResponse(BuilderImpl builder) {
        super(builder);
        this.ipv6Pools = builder.ipv6Pools;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Ipv6Pools property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIpv6Pools() {
        return ipv6Pools != null && !(ipv6Pools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv6 address pools.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6Pools()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the IPv6 address pools.
     */
    public List<Ipv6Pool> ipv6Pools() {
        return ipv6Pools;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Pools());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpv6PoolsResponse)) {
            return false;
        }
        DescribeIpv6PoolsResponse other = (DescribeIpv6PoolsResponse) obj;
        return Objects.equals(ipv6Pools(), other.ipv6Pools()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeIpv6PoolsResponse").add("Ipv6Pools", ipv6Pools()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6Pools":
            return Optional.ofNullable(clazz.cast(ipv6Pools()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpv6PoolsResponse, T> g) {
        return obj -> g.apply((DescribeIpv6PoolsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIpv6PoolsResponse> {
        /**
         * <p>
         * Information about the IPv6 address pools.
         * </p>
         * 
         * @param ipv6Pools
         *        Information about the IPv6 address pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Pools(Collection<Ipv6Pool> ipv6Pools);

        /**
         * <p>
         * Information about the IPv6 address pools.
         * </p>
         * 
         * @param ipv6Pools
         *        Information about the IPv6 address pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Pools(Ipv6Pool... ipv6Pools);

        /**
         * <p>
         * Information about the IPv6 address pools.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Ipv6Pool>.Builder} avoiding the need to
         * create one manually via {@link List<Ipv6Pool>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ipv6Pool>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipv6Pools(List<Ipv6Pool>)}.
         * 
         * @param ipv6Pools
         *        a consumer that will call methods on {@link List<Ipv6Pool>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Pools(List<Ipv6Pool>)
         */
        Builder ipv6Pools(Consumer<Ipv6Pool.Builder>... ipv6Pools);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<Ipv6Pool> ipv6Pools = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpv6PoolsResponse model) {
            super(model);
            ipv6Pools(model.ipv6Pools);
            nextToken(model.nextToken);
        }

        public final Collection<Ipv6Pool.Builder> getIpv6Pools() {
            return ipv6Pools != null ? ipv6Pools.stream().map(Ipv6Pool::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Pools(Collection<Ipv6Pool> ipv6Pools) {
            this.ipv6Pools = Ipv6PoolSetCopier.copy(ipv6Pools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Pools(Ipv6Pool... ipv6Pools) {
            ipv6Pools(Arrays.asList(ipv6Pools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Pools(Consumer<Ipv6Pool.Builder>... ipv6Pools) {
            ipv6Pools(Stream.of(ipv6Pools).map(c -> Ipv6Pool.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Pools(Collection<Ipv6Pool.BuilderImpl> ipv6Pools) {
            this.ipv6Pools = Ipv6PoolSetCopier.copyFromBuilder(ipv6Pools);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeIpv6PoolsResponse build() {
            return new DescribeIpv6PoolsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
