/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableFastSnapshotRestoresResponse extends Ec2Response implements
        ToCopyableBuilder<DisableFastSnapshotRestoresResponse.Builder, DisableFastSnapshotRestoresResponse> {
    private static final SdkField<List<DisableFastSnapshotRestoreSuccessItem>> SUCCESSFUL_FIELD = SdkField
            .<List<DisableFastSnapshotRestoreSuccessItem>> builder(MarshallingType.LIST)
            .getter(getter(DisableFastSnapshotRestoresResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful")
                    .unmarshallLocationName("successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DisableFastSnapshotRestoreSuccessItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisableFastSnapshotRestoreSuccessItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<DisableFastSnapshotRestoreErrorItem>> UNSUCCESSFUL_FIELD = SdkField
            .<List<DisableFastSnapshotRestoreErrorItem>> builder(MarshallingType.LIST)
            .getter(getter(DisableFastSnapshotRestoresResponse::unsuccessful))
            .setter(setter(Builder::unsuccessful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unsuccessful")
                    .unmarshallLocationName("unsuccessful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DisableFastSnapshotRestoreErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisableFastSnapshotRestoreErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD,
            UNSUCCESSFUL_FIELD));

    private final List<DisableFastSnapshotRestoreSuccessItem> successful;

    private final List<DisableFastSnapshotRestoreErrorItem> unsuccessful;

    private DisableFastSnapshotRestoresResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    /**
     * Returns true if the Successful property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the snapshots for which fast snapshot restores were successfully disabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuccessful()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the snapshots for which fast snapshot restores were successfully disabled.
     */
    public List<DisableFastSnapshotRestoreSuccessItem> successful() {
        return successful;
    }

    /**
     * Returns true if the Unsuccessful property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUnsuccessful() {
        return unsuccessful != null && !(unsuccessful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the snapshots for which fast snapshot restores could not be disabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnsuccessful()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the snapshots for which fast snapshot restores could not be disabled.
     */
    public List<DisableFastSnapshotRestoreErrorItem> unsuccessful() {
        return unsuccessful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(successful());
        hashCode = 31 * hashCode + Objects.hashCode(unsuccessful());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableFastSnapshotRestoresResponse)) {
            return false;
        }
        DisableFastSnapshotRestoresResponse other = (DisableFastSnapshotRestoresResponse) obj;
        return Objects.equals(successful(), other.successful()) && Objects.equals(unsuccessful(), other.unsuccessful());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisableFastSnapshotRestoresResponse").add("Successful", successful())
                .add("Unsuccessful", unsuccessful()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.ofNullable(clazz.cast(successful()));
        case "Unsuccessful":
            return Optional.ofNullable(clazz.cast(unsuccessful()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableFastSnapshotRestoresResponse, T> g) {
        return obj -> g.apply((DisableFastSnapshotRestoresResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DisableFastSnapshotRestoresResponse> {
        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores were successfully disabled.
         * </p>
         * 
         * @param successful
         *        Information about the snapshots for which fast snapshot restores were successfully disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<DisableFastSnapshotRestoreSuccessItem> successful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores were successfully disabled.
         * </p>
         * 
         * @param successful
         *        Information about the snapshots for which fast snapshot restores were successfully disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(DisableFastSnapshotRestoreSuccessItem... successful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores were successfully disabled.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <DisableFastSnapshotRestoreSuccessItem>.Builder} avoiding the need to create one manually via {@link List
         * <DisableFastSnapshotRestoreSuccessItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DisableFastSnapshotRestoreSuccessItem>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #successful(List<DisableFastSnapshotRestoreSuccessItem>)}.
         * 
         * @param successful
         *        a consumer that will call methods on {@link List<DisableFastSnapshotRestoreSuccessItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(List<DisableFastSnapshotRestoreSuccessItem>)
         */
        Builder successful(Consumer<DisableFastSnapshotRestoreSuccessItem.Builder>... successful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores could not be disabled.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the snapshots for which fast snapshot restores could not be disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(Collection<DisableFastSnapshotRestoreErrorItem> unsuccessful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores could not be disabled.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the snapshots for which fast snapshot restores could not be disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(DisableFastSnapshotRestoreErrorItem... unsuccessful);

        /**
         * <p>
         * Information about the snapshots for which fast snapshot restores could not be disabled.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <DisableFastSnapshotRestoreErrorItem>.Builder} avoiding the need to create one manually via {@link List
         * <DisableFastSnapshotRestoreErrorItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DisableFastSnapshotRestoreErrorItem>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #unsuccessful(List<DisableFastSnapshotRestoreErrorItem>)}.
         * 
         * @param unsuccessful
         *        a consumer that will call methods on {@link List<DisableFastSnapshotRestoreErrorItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessful(List<DisableFastSnapshotRestoreErrorItem>)
         */
        Builder unsuccessful(Consumer<DisableFastSnapshotRestoreErrorItem.Builder>... unsuccessful);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<DisableFastSnapshotRestoreSuccessItem> successful = DefaultSdkAutoConstructList.getInstance();

        private List<DisableFastSnapshotRestoreErrorItem> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableFastSnapshotRestoresResponse model) {
            super(model);
            successful(model.successful);
            unsuccessful(model.unsuccessful);
        }

        public final Collection<DisableFastSnapshotRestoreSuccessItem.Builder> getSuccessful() {
            return successful != null ? successful.stream().map(DisableFastSnapshotRestoreSuccessItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successful(Collection<DisableFastSnapshotRestoreSuccessItem> successful) {
            this.successful = DisableFastSnapshotRestoreSuccessSetCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(DisableFastSnapshotRestoreSuccessItem... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<DisableFastSnapshotRestoreSuccessItem.Builder>... successful) {
            successful(Stream.of(successful).map(c -> DisableFastSnapshotRestoreSuccessItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessful(Collection<DisableFastSnapshotRestoreSuccessItem.BuilderImpl> successful) {
            this.successful = DisableFastSnapshotRestoreSuccessSetCopier.copyFromBuilder(successful);
        }

        public final Collection<DisableFastSnapshotRestoreErrorItem.Builder> getUnsuccessful() {
            return unsuccessful != null ? unsuccessful.stream().map(DisableFastSnapshotRestoreErrorItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessful(Collection<DisableFastSnapshotRestoreErrorItem> unsuccessful) {
            this.unsuccessful = DisableFastSnapshotRestoreErrorSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(DisableFastSnapshotRestoreErrorItem... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<DisableFastSnapshotRestoreErrorItem.Builder>... unsuccessful) {
            unsuccessful(Stream.of(unsuccessful).map(c -> DisableFastSnapshotRestoreErrorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessful(Collection<DisableFastSnapshotRestoreErrorItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = DisableFastSnapshotRestoreErrorSetCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public DisableFastSnapshotRestoresResponse build() {
            return new DisableFastSnapshotRestoresResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
