/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeKeyPairsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeKeyPairsResponse.Builder, DescribeKeyPairsResponse> {
    private static final SdkField<List<KeyPairInfo>> KEY_PAIRS_FIELD = SdkField
            .<List<KeyPairInfo>> builder(MarshallingType.LIST)
            .getter(getter(DescribeKeyPairsResponse::keyPairs))
            .setter(setter(Builder::keyPairs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySet")
                    .unmarshallLocationName("keySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<KeyPairInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyPairInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PAIRS_FIELD));

    private final List<KeyPairInfo> keyPairs;

    private DescribeKeyPairsResponse(BuilderImpl builder) {
        super(builder);
        this.keyPairs = builder.keyPairs;
    }

    /**
     * Returns true if the KeyPairs property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKeyPairs() {
        return keyPairs != null && !(keyPairs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeyPairs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the key pairs.
     */
    public List<KeyPairInfo> keyPairs() {
        return keyPairs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyPairs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsResponse)) {
            return false;
        }
        DescribeKeyPairsResponse other = (DescribeKeyPairsResponse) obj;
        return Objects.equals(keyPairs(), other.keyPairs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeKeyPairsResponse").add("KeyPairs", keyPairs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyPairs":
            return Optional.ofNullable(clazz.cast(keyPairs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyPairsResponse, T> g) {
        return obj -> g.apply((DescribeKeyPairsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeKeyPairsResponse> {
        /**
         * <p>
         * Information about the key pairs.
         * </p>
         * 
         * @param keyPairs
         *        Information about the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(Collection<KeyPairInfo> keyPairs);

        /**
         * <p>
         * Information about the key pairs.
         * </p>
         * 
         * @param keyPairs
         *        Information about the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(KeyPairInfo... keyPairs);

        /**
         * <p>
         * Information about the key pairs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KeyPairInfo>.Builder} avoiding the need to
         * create one manually via {@link List<KeyPairInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeyPairInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #keyPairs(List<KeyPairInfo>)}.
         * 
         * @param keyPairs
         *        a consumer that will call methods on {@link List<KeyPairInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPairs(List<KeyPairInfo>)
         */
        Builder keyPairs(Consumer<KeyPairInfo.Builder>... keyPairs);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<KeyPairInfo> keyPairs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyPairsResponse model) {
            super(model);
            keyPairs(model.keyPairs);
        }

        public final Collection<KeyPairInfo.Builder> getKeyPairs() {
            return keyPairs != null ? keyPairs.stream().map(KeyPairInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPairs(Collection<KeyPairInfo> keyPairs) {
            this.keyPairs = KeyPairListCopier.copy(keyPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(KeyPairInfo... keyPairs) {
            keyPairs(Arrays.asList(keyPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(Consumer<KeyPairInfo.Builder>... keyPairs) {
            keyPairs(Stream.of(keyPairs).map(c -> KeyPairInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyPairs(Collection<KeyPairInfo.BuilderImpl> keyPairs) {
            this.keyPairs = KeyPairListCopier.copyFromBuilder(keyPairs);
        }

        @Override
        public DescribeKeyPairsResponse build() {
            return new DescribeKeyPairsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
