/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a target network that is associated with a Client VPN endpoint. A target network is a subnet in a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedTargetNetwork implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociatedTargetNetwork.Builder, AssociatedTargetNetwork> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AssociatedTargetNetwork::networkId))
            .setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkId")
                    .unmarshallLocationName("networkId").build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AssociatedTargetNetwork::networkTypeAsString))
            .setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType")
                    .unmarshallLocationName("networkType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD,
            NETWORK_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkId;

    private final String networkType;

    private AssociatedTargetNetwork(BuilderImpl builder) {
        this.networkId = builder.networkId;
        this.networkType = builder.networkType;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String networkId() {
        return networkId;
    }

    /**
     * <p>
     * The target network type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link AssociatedNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #networkTypeAsString}.
     * </p>
     * 
     * @return The target network type.
     * @see AssociatedNetworkType
     */
    public AssociatedNetworkType networkType() {
        return AssociatedNetworkType.fromValue(networkType);
    }

    /**
     * <p>
     * The target network type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link AssociatedNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #networkTypeAsString}.
     * </p>
     * 
     * @return The target network type.
     * @see AssociatedNetworkType
     */
    public String networkTypeAsString() {
        return networkType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(networkTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedTargetNetwork)) {
            return false;
        }
        AssociatedTargetNetwork other = (AssociatedTargetNetwork) obj;
        return Objects.equals(networkId(), other.networkId())
                && Objects.equals(networkTypeAsString(), other.networkTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociatedTargetNetwork").add("NetworkId", networkId())
                .add("NetworkType", networkTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatedTargetNetwork, T> g) {
        return obj -> g.apply((AssociatedTargetNetwork) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedTargetNetwork> {
        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param networkId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(String networkId);

        /**
         * <p>
         * The target network type.
         * </p>
         * 
         * @param networkType
         *        The target network type.
         * @see AssociatedNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociatedNetworkType
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * The target network type.
         * </p>
         * 
         * @param networkType
         *        The target network type.
         * @see AssociatedNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociatedNetworkType
         */
        Builder networkType(AssociatedNetworkType networkType);
    }

    static final class BuilderImpl implements Builder {
        private String networkId;

        private String networkType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedTargetNetwork model) {
            networkId(model.networkId);
            networkType(model.networkType);
        }

        public final String getNetworkId() {
            return networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getNetworkTypeAsString() {
            return networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(AssociatedNetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public AssociatedTargetNetwork build() {
            return new AssociatedTargetNetwork(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
