/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateVpcEndpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcEndpointRequest extends Ec2Request implements
        ToCopyableBuilder<CreateVpcEndpointRequest.Builder, CreateVpcEndpointRequest> {
    private static final SdkField<String> VPC_ENDPOINT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpcEndpointRequest::vpcEndpointTypeAsString))
            .setter(setter(Builder::vpcEndpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointType")
                    .unmarshallLocationName("VpcEndpointType").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpcEndpointRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("VpcId").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpcEndpointRequest::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName")
                    .unmarshallLocationName("ServiceName").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpcEndpointRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument")
                    .unmarshallLocationName("PolicyDocument").build()).build();

    private static final SdkField<List<String>> ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateVpcEndpointRequest::routeTableIds))
            .setter(setter(Builder::routeTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId")
                    .unmarshallLocationName("RouteTableId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateVpcEndpointRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("SubnetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateVpcEndpointRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpcEndpointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<Boolean> PRIVATE_DNS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateVpcEndpointRequest::privateDnsEnabled))
            .setter(setter(Builder::privateDnsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsEnabled")
                    .unmarshallLocationName("PrivateDnsEnabled").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .getter(getter(CreateVpcEndpointRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_TYPE_FIELD,
            VPC_ID_FIELD, SERVICE_NAME_FIELD, POLICY_DOCUMENT_FIELD, ROUTE_TABLE_IDS_FIELD, SUBNET_IDS_FIELD,
            SECURITY_GROUP_IDS_FIELD, CLIENT_TOKEN_FIELD, PRIVATE_DNS_ENABLED_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final String vpcEndpointType;

    private final String vpcId;

    private final String serviceName;

    private final String policyDocument;

    private final List<String> routeTableIds;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final String clientToken;

    private final Boolean privateDnsEnabled;

    private final List<TagSpecification> tagSpecifications;

    private CreateVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointType = builder.vpcEndpointType;
        this.vpcId = builder.vpcId;
        this.serviceName = builder.serviceName;
        this.policyDocument = builder.policyDocument;
        this.routeTableIds = builder.routeTableIds;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.clientToken = builder.clientToken;
        this.privateDnsEnabled = builder.privateDnsEnabled;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The type of endpoint.
     * </p>
     * <p>
     * Default: Gateway
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcEndpointType}
     * will return {@link VpcEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vpcEndpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint.</p>
     *         <p>
     *         Default: Gateway
     * @see VpcEndpointType
     */
    public VpcEndpointType vpcEndpointType() {
        return VpcEndpointType.fromValue(vpcEndpointType);
    }

    /**
     * <p>
     * The type of endpoint.
     * </p>
     * <p>
     * Default: Gateway
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcEndpointType}
     * will return {@link VpcEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vpcEndpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint.</p>
     *         <p>
     *         Default: Gateway
     * @see VpcEndpointType
     */
    public String vpcEndpointTypeAsString() {
        return vpcEndpointType;
    }

    /**
     * <p>
     * The ID of the VPC in which the endpoint will be used.
     * </p>
     * 
     * @return The ID of the VPC in which the endpoint will be used.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The service name. To get a list of available services, use the <a>DescribeVpcEndpointServices</a> request, or get
     * the name from the service provider.
     * </p>
     * 
     * @return The service name. To get a list of available services, use the <a>DescribeVpcEndpointServices</a>
     *         request, or get the name from the service provider.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON format.
     * If this parameter is not specified, we attach a default policy that allows full access to the service.
     * </p>
     * 
     * @return A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON
     *         format. If this parameter is not specified, we attach a default policy that allows full access to the
     *         service.
     */
    public String policyDocument() {
        return policyDocument;
    }

    /**
     * Returns true if the RouteTableIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRouteTableIds() {
        return routeTableIds != null && !(routeTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Gateway endpoint) One or more route table IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRouteTableIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Gateway endpoint) One or more route table IDs.
     */
    public List<String> routeTableIds() {
        return routeTableIds;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface endpoint) The ID of one or more subnets in which to create an endpoint network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Interface endpoint) The ID of one or more subnets in which to create an endpoint network interface.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface endpoint) The ID of one or more security groups to associate with the endpoint network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Interface endpoint) The ID of one or more security groups to associate with the endpoint network
     *         interface.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private
     * hosted zone contains a record set for the default public DNS name for the service for the Region (for example,
     * <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP addresses of the endpoint network
     * interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead
     * of the public DNS names that are automatically generated by the VPC endpoint service.
     * </p>
     * <p>
     * To use a private hosted zone, you must set the following VPC attributes to <code>true</code>:
     * <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to set the VPC
     * attributes.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The
     *         private hosted zone contains a record set for the default public DNS name for the service for the Region
     *         (for example, <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP addresses
     *         of the endpoint network interfaces in the VPC. This enables you to make requests to the default public
     *         DNS name for the service instead of the public DNS names that are automatically generated by the VPC
     *         endpoint service.</p>
     *         <p>
     *         To use a private hosted zone, you must set the following VPC attributes to <code>true</code>:
     *         <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to set
     *         the VPC attributes.
     *         </p>
     *         <p>
     *         Default: <code>true</code>
     */
    public Boolean privateDnsEnabled() {
        return privateDnsEnabled;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to associate with the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to associate with the endpoint.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointRequest)) {
            return false;
        }
        CreateVpcEndpointRequest other = (CreateVpcEndpointRequest) obj;
        return Objects.equals(vpcEndpointTypeAsString(), other.vpcEndpointTypeAsString())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(routeTableIds(), other.routeTableIds()) && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(privateDnsEnabled(), other.privateDnsEnabled())
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVpcEndpointRequest").add("VpcEndpointType", vpcEndpointTypeAsString())
                .add("VpcId", vpcId()).add("ServiceName", serviceName()).add("PolicyDocument", policyDocument())
                .add("RouteTableIds", routeTableIds()).add("SubnetIds", subnetIds()).add("SecurityGroupIds", securityGroupIds())
                .add("ClientToken", clientToken()).add("PrivateDnsEnabled", privateDnsEnabled())
                .add("TagSpecifications", tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointType":
            return Optional.ofNullable(clazz.cast(vpcEndpointTypeAsString()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "RouteTableIds":
            return Optional.ofNullable(clazz.cast(routeTableIds()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "PrivateDnsEnabled":
            return Optional.ofNullable(clazz.cast(privateDnsEnabled()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointRequest, T> g) {
        return obj -> g.apply((CreateVpcEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcEndpointRequest> {
        /**
         * <p>
         * The type of endpoint.
         * </p>
         * <p>
         * Default: Gateway
         * </p>
         * 
         * @param vpcEndpointType
         *        The type of endpoint.</p>
         *        <p>
         *        Default: Gateway
         * @see VpcEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointType
         */
        Builder vpcEndpointType(String vpcEndpointType);

        /**
         * <p>
         * The type of endpoint.
         * </p>
         * <p>
         * Default: Gateway
         * </p>
         * 
         * @param vpcEndpointType
         *        The type of endpoint.</p>
         *        <p>
         *        Default: Gateway
         * @see VpcEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointType
         */
        Builder vpcEndpointType(VpcEndpointType vpcEndpointType);

        /**
         * <p>
         * The ID of the VPC in which the endpoint will be used.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC in which the endpoint will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The service name. To get a list of available services, use the <a>DescribeVpcEndpointServices</a> request, or
         * get the name from the service provider.
         * </p>
         * 
         * @param serviceName
         *        The service name. To get a list of available services, use the <a>DescribeVpcEndpointServices</a>
         *        request, or get the name from the service provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON
         * format. If this parameter is not specified, we attach a default policy that allows full access to the
         * service.
         * </p>
         * 
         * @param policyDocument
         *        A policy to attach to the endpoint that controls access to the service. The policy must be in valid
         *        JSON format. If this parameter is not specified, we attach a default policy that allows full access to
         *        the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * (Gateway endpoint) One or more route table IDs.
         * </p>
         * 
         * @param routeTableIds
         *        (Gateway endpoint) One or more route table IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(Collection<String> routeTableIds);

        /**
         * <p>
         * (Gateway endpoint) One or more route table IDs.
         * </p>
         * 
         * @param routeTableIds
         *        (Gateway endpoint) One or more route table IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableIds(String... routeTableIds);

        /**
         * <p>
         * (Interface endpoint) The ID of one or more subnets in which to create an endpoint network interface.
         * </p>
         * 
         * @param subnetIds
         *        (Interface endpoint) The ID of one or more subnets in which to create an endpoint network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * (Interface endpoint) The ID of one or more subnets in which to create an endpoint network interface.
         * </p>
         * 
         * @param subnetIds
         *        (Interface endpoint) The ID of one or more subnets in which to create an endpoint network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * (Interface endpoint) The ID of one or more security groups to associate with the endpoint network interface.
         * </p>
         * 
         * @param securityGroupIds
         *        (Interface endpoint) The ID of one or more security groups to associate with the endpoint network
         *        interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * (Interface endpoint) The ID of one or more security groups to associate with the endpoint network interface.
         * </p>
         * 
         * @param securityGroupIds
         *        (Interface endpoint) The ID of one or more security groups to associate with the endpoint network
         *        interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private
         * hosted zone contains a record set for the default public DNS name for the service for the Region (for
         * example, <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP addresses of the
         * endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for
         * the service instead of the public DNS names that are automatically generated by the VPC endpoint service.
         * </p>
         * <p>
         * To use a private hosted zone, you must set the following VPC attributes to <code>true</code>:
         * <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to set the
         * VPC attributes.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param privateDnsEnabled
         *        (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The
         *        private hosted zone contains a record set for the default public DNS name for the service for the
         *        Region (for example, <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP
         *        addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the
         *        default public DNS name for the service instead of the public DNS names that are automatically
         *        generated by the VPC endpoint service.</p>
         *        <p>
         *        To use a private hosted zone, you must set the following VPC attributes to <code>true</code>:
         *        <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to
         *        set the VPC attributes.
         *        </p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsEnabled(Boolean privateDnsEnabled);

        /**
         * <p>
         * The tags to associate with the endpoint.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to associate with the endpoint.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to associate with the endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String vpcEndpointType;

        private String vpcId;

        private String serviceName;

        private String policyDocument;

        private List<String> routeTableIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private Boolean privateDnsEnabled;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointRequest model) {
            super(model);
            vpcEndpointType(model.vpcEndpointType);
            vpcId(model.vpcId);
            serviceName(model.serviceName);
            policyDocument(model.policyDocument);
            routeTableIds(model.routeTableIds);
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            clientToken(model.clientToken);
            privateDnsEnabled(model.privateDnsEnabled);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getVpcEndpointTypeAsString() {
            return vpcEndpointType;
        }

        @Override
        public final Builder vpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
            return this;
        }

        @Override
        public final Builder vpcEndpointType(VpcEndpointType vpcEndpointType) {
            this.vpcEndpointType(vpcEndpointType == null ? null : vpcEndpointType.toString());
            return this;
        }

        public final void setVpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getRouteTableIds() {
            return routeTableIds;
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = VpcEndpointRouteTableIdListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String... routeTableIds) {
            routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = VpcEndpointRouteTableIdListCopier.copy(routeTableIds);
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = VpcEndpointSubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = VpcEndpointSubnetIdListCopier.copy(subnetIds);
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(securityGroupIds);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Boolean getPrivateDnsEnabled() {
            return privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcEndpointRequest build() {
            return new CreateVpcEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
