/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplaceNetworkAclEntryRequest extends Ec2Request implements
        ToCopyableBuilder<ReplaceNetworkAclEntryRequest.Builder, ReplaceNetworkAclEntryRequest> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReplaceNetworkAclEntryRequest::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock")
                    .unmarshallLocationName("cidrBlock").build()).build();

    private static final SdkField<Boolean> EGRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ReplaceNetworkAclEntryRequest::egress))
            .setter(setter(Builder::egress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Egress")
                    .unmarshallLocationName("egress").build()).build();

    private static final SdkField<IcmpTypeCode> ICMP_TYPE_CODE_FIELD = SdkField
            .<IcmpTypeCode> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReplaceNetworkAclEntryRequest::icmpTypeCode))
            .setter(setter(Builder::icmpTypeCode))
            .constructor(IcmpTypeCode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Icmp")
                    .unmarshallLocationName("Icmp").build()).build();

    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReplaceNetworkAclEntryRequest::ipv6CidrBlock))
            .setter(setter(Builder::ipv6CidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock")
                    .unmarshallLocationName("ipv6CidrBlock").build()).build();

    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReplaceNetworkAclEntryRequest::networkAclId))
            .setter(setter(Builder::networkAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId")
                    .unmarshallLocationName("networkAclId").build()).build();

    private static final SdkField<PortRange> PORT_RANGE_FIELD = SdkField
            .<PortRange> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReplaceNetworkAclEntryRequest::portRange))
            .setter(setter(Builder::portRange))
            .constructor(PortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange")
                    .unmarshallLocationName("portRange").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReplaceNetworkAclEntryRequest::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final SdkField<String> RULE_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReplaceNetworkAclEntryRequest::ruleActionAsString))
            .setter(setter(Builder::ruleAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction")
                    .unmarshallLocationName("ruleAction").build()).build();

    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ReplaceNetworkAclEntryRequest::ruleNumber))
            .setter(setter(Builder::ruleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber")
                    .unmarshallLocationName("ruleNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD,
            EGRESS_FIELD, ICMP_TYPE_CODE_FIELD, IPV6_CIDR_BLOCK_FIELD, NETWORK_ACL_ID_FIELD, PORT_RANGE_FIELD, PROTOCOL_FIELD,
            RULE_ACTION_FIELD, RULE_NUMBER_FIELD));

    private final String cidrBlock;

    private final Boolean egress;

    private final IcmpTypeCode icmpTypeCode;

    private final String ipv6CidrBlock;

    private final String networkAclId;

    private final PortRange portRange;

    private final String protocol;

    private final String ruleAction;

    private final Integer ruleNumber;

    private ReplaceNetworkAclEntryRequest(BuilderImpl builder) {
        super(builder);
        this.cidrBlock = builder.cidrBlock;
        this.egress = builder.egress;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.networkAclId = builder.networkAclId;
        this.portRange = builder.portRange;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.ruleNumber = builder.ruleNumber;
    }

    /**
     * <p>
     * The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
     * </p>
     * 
     * @return The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Indicates whether to replace the egress rule.
     * </p>
     * <p>
     * Default: If no value is specified, we replace the ingress rule.
     * </p>
     * 
     * @return Indicates whether to replace the egress rule.</p>
     *         <p>
     *         Default: If no value is specified, we replace the ingress rule.
     */
    public Boolean egress() {
        return egress;
    }

    /**
     * <p>
     * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6)
     * with an IPv6 CIDR block.
     * </p>
     * 
     * @return ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58
     *         (ICMPv6) with an IPv6 CIDR block.
     */
    public IcmpTypeCode icmpTypeCode() {
        return icmpTypeCode;
    }

    /**
     * <p>
     * The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:bd8:1234:1a00::/64</code>).
     * </p>
     * 
     * @return The IPv6 network range to allow or deny, in CIDR notation (for example
     *         <code>2001:bd8:1234:1a00::/64</code>).
     */
    public String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * The ID of the ACL.
     * </p>
     * 
     * @return The ID of the ACL.
     */
    public String networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17
     * (UDP).
     * </p>
     * 
     * @return TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or
     *         17 (UDP).
     */
    public PortRange portRange() {
        return portRange;
    }

    /**
     * <p>
     * The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6"
     * (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes
     * that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP
     * types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an
     * IPv6 CIDR block, you must specify an ICMP type and code.
     * </p>
     * 
     * @return The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other
     *         than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or
     *         ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR
     *         block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify
     *         protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.
     */
    public String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Indicates whether to allow or deny the traffic that matches the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleActionAsString}.
     * </p>
     * 
     * @return Indicates whether to allow or deny the traffic that matches the rule.
     * @see RuleAction
     */
    public RuleAction ruleAction() {
        return RuleAction.fromValue(ruleAction);
    }

    /**
     * <p>
     * Indicates whether to allow or deny the traffic that matches the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleActionAsString}.
     * </p>
     * 
     * @return Indicates whether to allow or deny the traffic that matches the rule.
     * @see RuleAction
     */
    public String ruleActionAsString() {
        return ruleAction;
    }

    /**
     * <p>
     * The rule number of the entry to replace.
     * </p>
     * 
     * @return The rule number of the entry to replace.
     */
    public Integer ruleNumber() {
        return ruleNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(egress());
        hashCode = 31 * hashCode + Objects.hashCode(icmpTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(portRange());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceNetworkAclEntryRequest)) {
            return false;
        }
        ReplaceNetworkAclEntryRequest other = (ReplaceNetworkAclEntryRequest) obj;
        return Objects.equals(cidrBlock(), other.cidrBlock()) && Objects.equals(egress(), other.egress())
                && Objects.equals(icmpTypeCode(), other.icmpTypeCode()) && Objects.equals(ipv6CidrBlock(), other.ipv6CidrBlock())
                && Objects.equals(networkAclId(), other.networkAclId()) && Objects.equals(portRange(), other.portRange())
                && Objects.equals(protocol(), other.protocol())
                && Objects.equals(ruleActionAsString(), other.ruleActionAsString())
                && Objects.equals(ruleNumber(), other.ruleNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReplaceNetworkAclEntryRequest").add("CidrBlock", cidrBlock()).add("Egress", egress())
                .add("IcmpTypeCode", icmpTypeCode()).add("Ipv6CidrBlock", ipv6CidrBlock()).add("NetworkAclId", networkAclId())
                .add("PortRange", portRange()).add("Protocol", protocol()).add("RuleAction", ruleActionAsString())
                .add("RuleNumber", ruleNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "Egress":
            return Optional.ofNullable(clazz.cast(egress()));
        case "IcmpTypeCode":
            return Optional.ofNullable(clazz.cast(icmpTypeCode()));
        case "Ipv6CidrBlock":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlock()));
        case "NetworkAclId":
            return Optional.ofNullable(clazz.cast(networkAclId()));
        case "PortRange":
            return Optional.ofNullable(clazz.cast(portRange()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "RuleAction":
            return Optional.ofNullable(clazz.cast(ruleActionAsString()));
        case "RuleNumber":
            return Optional.ofNullable(clazz.cast(ruleNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceNetworkAclEntryRequest, T> g) {
        return obj -> g.apply((ReplaceNetworkAclEntryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ReplaceNetworkAclEntryRequest> {
        /**
         * <p>
         * The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Indicates whether to replace the egress rule.
         * </p>
         * <p>
         * Default: If no value is specified, we replace the ingress rule.
         * </p>
         * 
         * @param egress
         *        Indicates whether to replace the egress rule.</p>
         *        <p>
         *        Default: If no value is specified, we replace the ingress rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egress(Boolean egress);

        /**
         * <p>
         * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58
         * (ICMPv6) with an IPv6 CIDR block.
         * </p>
         * 
         * @param icmpTypeCode
         *        ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol
         *        58 (ICMPv6) with an IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icmpTypeCode(IcmpTypeCode icmpTypeCode);

        /**
         * <p>
         * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58
         * (ICMPv6) with an IPv6 CIDR block.
         * </p>
         * This is a convenience that creates an instance of the {@link IcmpTypeCode.Builder} avoiding the need to
         * create one manually via {@link IcmpTypeCode#builder()}.
         *
         * When the {@link Consumer} completes, {@link IcmpTypeCode.Builder#build()} is called immediately and its
         * result is passed to {@link #icmpTypeCode(IcmpTypeCode)}.
         * 
         * @param icmpTypeCode
         *        a consumer that will call methods on {@link IcmpTypeCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icmpTypeCode(IcmpTypeCode)
         */
        default Builder icmpTypeCode(Consumer<IcmpTypeCode.Builder> icmpTypeCode) {
            return icmpTypeCode(IcmpTypeCode.builder().applyMutation(icmpTypeCode).build());
        }

        /**
         * <p>
         * The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:bd8:1234:1a00::/64</code>).
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 network range to allow or deny, in CIDR notation (for example
         *        <code>2001:bd8:1234:1a00::/64</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * The ID of the ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17
         * (UDP).
         * </p>
         * 
         * @param portRange
         *        TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP)
         *        or 17 (UDP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRange(PortRange portRange);

        /**
         * <p>
         * TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17
         * (UDP).
         * </p>
         * This is a convenience that creates an instance of the {@link PortRange.Builder} avoiding the need to create
         * one manually via {@link PortRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link PortRange.Builder#build()} is called immediately and its result
         * is passed to {@link #portRange(PortRange)}.
         * 
         * @param portRange
         *        a consumer that will call methods on {@link PortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRange(PortRange)
         */
        default Builder portRange(Consumer<PortRange.Builder> portRange) {
            return portRange(PortRange.builder().applyMutation(portRange).build());
        }

        /**
         * <p>
         * The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than
         * "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types
         * or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for
         * all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6)
         * and specify an IPv6 CIDR block, you must specify an ICMP type and code.
         * </p>
         * 
         * @param protocol
         *        The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number
         *        other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any
         *        ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an
         *        IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If
         *        you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and
         *        code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Indicates whether to allow or deny the traffic that matches the rule.
         * </p>
         * 
         * @param ruleAction
         *        Indicates whether to allow or deny the traffic that matches the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * Indicates whether to allow or deny the traffic that matches the rule.
         * </p>
         * 
         * @param ruleAction
         *        Indicates whether to allow or deny the traffic that matches the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder ruleAction(RuleAction ruleAction);

        /**
         * <p>
         * The rule number of the entry to replace.
         * </p>
         * 
         * @param ruleNumber
         *        The rule number of the entry to replace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String cidrBlock;

        private Boolean egress;

        private IcmpTypeCode icmpTypeCode;

        private String ipv6CidrBlock;

        private String networkAclId;

        private PortRange portRange;

        private String protocol;

        private String ruleAction;

        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceNetworkAclEntryRequest model) {
            super(model);
            cidrBlock(model.cidrBlock);
            egress(model.egress);
            icmpTypeCode(model.icmpTypeCode);
            ipv6CidrBlock(model.ipv6CidrBlock);
            networkAclId(model.networkAclId);
            portRange(model.portRange);
            protocol(model.protocol);
            ruleAction(model.ruleAction);
            ruleNumber(model.ruleNumber);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getEgress() {
            return egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        public final IcmpTypeCode.Builder getIcmpTypeCode() {
            return icmpTypeCode != null ? icmpTypeCode.toBuilder() : null;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final void setIcmpTypeCode(IcmpTypeCode.BuilderImpl icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode != null ? icmpTypeCode.build() : null;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final PortRange.Builder getPortRange() {
            return portRange != null ? portRange.toBuilder() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRuleActionAsString() {
            return ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplaceNetworkAclEntryRequest build() {
            return new ReplaceNetworkAclEntryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
