/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the instances that could not be launched by the fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetError implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeFleetError.Builder, DescribeFleetError> {
    private static final SdkField<LaunchTemplateAndOverridesResponse> LAUNCH_TEMPLATE_AND_OVERRIDES_FIELD = SdkField
            .<LaunchTemplateAndOverridesResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeFleetError::launchTemplateAndOverrides))
            .setter(setter(Builder::launchTemplateAndOverrides))
            .constructor(LaunchTemplateAndOverridesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateAndOverrides")
                    .unmarshallLocationName("launchTemplateAndOverrides").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetError::lifecycleAsString))
            .setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle")
                    .unmarshallLocationName("lifecycle").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetError::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode")
                    .unmarshallLocationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetError::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage")
                    .unmarshallLocationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_TEMPLATE_AND_OVERRIDES_FIELD, LIFECYCLE_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final LaunchTemplateAndOverridesResponse launchTemplateAndOverrides;

    private final String lifecycle;

    private final String errorCode;

    private final String errorMessage;

    private DescribeFleetError(BuilderImpl builder) {
        this.launchTemplateAndOverrides = builder.launchTemplateAndOverrides;
        this.lifecycle = builder.lifecycle;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The launch templates and overrides that were used for launching the instances. The values that you specify in the
     * Overrides replace the values in the launch template.
     * </p>
     * 
     * @return The launch templates and overrides that were used for launching the instances. The values that you
     *         specify in the Overrides replace the values in the launch template.
     */
    public LaunchTemplateAndOverridesResponse launchTemplateAndOverrides() {
        return launchTemplateAndOverrides;
    }

    /**
     * <p>
     * Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link InstanceLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
     * @see InstanceLifecycle
     */
    public InstanceLifecycle lifecycle() {
        return InstanceLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link InstanceLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
     * @see InstanceLifecycle
     */
    public String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * <p>
     * The error code that indicates why the instance could not be launched. For more information about error codes, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes</a>.
     * </p>
     * 
     * @return The error code that indicates why the instance could not be launched. For more information about error
     *         codes, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes</a>.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message that describes why the instance could not be launched. For more information about error
     * messages, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error
     * Codes</a>.
     * </p>
     * 
     * @return The error message that describes why the instance could not be launched. For more information about error
     *         messages, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes</a>.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateAndOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetError)) {
            return false;
        }
        DescribeFleetError other = (DescribeFleetError) obj;
        return Objects.equals(launchTemplateAndOverrides(), other.launchTemplateAndOverrides())
                && Objects.equals(lifecycleAsString(), other.lifecycleAsString())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeFleetError").add("LaunchTemplateAndOverrides", launchTemplateAndOverrides())
                .add("Lifecycle", lifecycleAsString()).add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateAndOverrides":
            return Optional.ofNullable(clazz.cast(launchTemplateAndOverrides()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetError, T> g) {
        return obj -> g.apply((DescribeFleetError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeFleetError> {
        /**
         * <p>
         * The launch templates and overrides that were used for launching the instances. The values that you specify in
         * the Overrides replace the values in the launch template.
         * </p>
         * 
         * @param launchTemplateAndOverrides
         *        The launch templates and overrides that were used for launching the instances. The values that you
         *        specify in the Overrides replace the values in the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse launchTemplateAndOverrides);

        /**
         * <p>
         * The launch templates and overrides that were used for launching the instances. The values that you specify in
         * the Overrides replace the values in the launch template.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateAndOverridesResponse.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateAndOverridesResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateAndOverridesResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse)}.
         * 
         * @param launchTemplateAndOverrides
         *        a consumer that will call methods on {@link LaunchTemplateAndOverridesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse)
         */
        default Builder launchTemplateAndOverrides(Consumer<LaunchTemplateAndOverridesResponse.Builder> launchTemplateAndOverrides) {
            return launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse.builder()
                    .applyMutation(launchTemplateAndOverrides).build());
        }

        /**
         * <p>
         * Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
         * </p>
         * 
         * @param lifecycle
         *        Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
         * @see InstanceLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
         * </p>
         * 
         * @param lifecycle
         *        Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
         * @see InstanceLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycle
         */
        Builder lifecycle(InstanceLifecycle lifecycle);

        /**
         * <p>
         * The error code that indicates why the instance could not be launched. For more information about error codes,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error
         * Codes</a>.
         * </p>
         * 
         * @param errorCode
         *        The error code that indicates why the instance could not be launched. For more information about error
         *        codes, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error
         *        Codes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message that describes why the instance could not be launched. For more information about error
         * messages, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes</a>.
         * </p>
         * 
         * @param errorMessage
         *        The error message that describes why the instance could not be launched. For more information about
         *        error messages, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error
         *        Codes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private LaunchTemplateAndOverridesResponse launchTemplateAndOverrides;

        private String lifecycle;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetError model) {
            launchTemplateAndOverrides(model.launchTemplateAndOverrides);
            lifecycle(model.lifecycle);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final LaunchTemplateAndOverridesResponse.Builder getLaunchTemplateAndOverrides() {
            return launchTemplateAndOverrides != null ? launchTemplateAndOverrides.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse launchTemplateAndOverrides) {
            this.launchTemplateAndOverrides = launchTemplateAndOverrides;
            return this;
        }

        public final void setLaunchTemplateAndOverrides(LaunchTemplateAndOverridesResponse.BuilderImpl launchTemplateAndOverrides) {
            this.launchTemplateAndOverrides = launchTemplateAndOverrides != null ? launchTemplateAndOverrides.build() : null;
        }

        public final String getLifecycleAsString() {
            return lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(InstanceLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public DescribeFleetError build() {
            return new DescribeFleetError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
